/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ThreesideDiffChangeBase {
    @NotNull
    private ConflictType myType;

    public ThreesideDiffChangeBase(@NotNull MergeLineFragment fragment, @NotNull List<? extends EditorEx> editors, @NotNull ComparisonPolicy policy) {
        List documents = ContainerUtil.map(editors, (Function)new Function<EditorEx, Document>(){

            public Document fun(EditorEx editorEx) {
                return editorEx.getDocument();
            }
        });
        this.myType = ThreesideDiffChangeBase.calcType(fragment, documents, policy);
    }

    public abstract int getStartLine(@NotNull ThreeSide var1);

    public abstract int getEndLine(@NotNull ThreeSide var1);

    @NotNull
    public TextDiffType getDiffType() {
        return this.myType.getDiffType();
    }

    @NotNull
    public ConflictType getType() {
        return this.myType;
    }

    public boolean isConflict() {
        return this.getDiffType() == TextDiffType.CONFLICT;
    }

    public boolean isChange(@NotNull Side side) {
        return this.myType.isChange(side);
    }

    public boolean isChange(@NotNull ThreeSide side) {
        switch (side) {
            case LEFT: {
                return this.isChange(Side.LEFT);
            }
            case BASE: {
                return true;
            }
            case RIGHT: {
                return this.isChange(Side.RIGHT);
            }
        }
        throw new IllegalArgumentException(side.toString());
    }

    @NotNull
    public static ConflictType calcType(@NotNull MergeLineFragment fragment, @NotNull List<? extends Document> documents, @NotNull ComparisonPolicy policy) {
        boolean isLeftEmpty = ThreesideDiffChangeBase.isIntervalEmpty(fragment, ThreeSide.LEFT);
        boolean isBaseEmpty = ThreesideDiffChangeBase.isIntervalEmpty(fragment, ThreeSide.BASE);
        boolean isRightEmpty = ThreesideDiffChangeBase.isIntervalEmpty(fragment, ThreeSide.RIGHT);
        assert (!(isLeftEmpty && isBaseEmpty && isRightEmpty));
        if (isBaseEmpty) {
            if (isLeftEmpty) {
                return new ConflictType(TextDiffType.INSERTED, false, true);
            }
            if (isRightEmpty) {
                return new ConflictType(TextDiffType.INSERTED, true, false);
            }
            boolean equalModifications = ThreesideDiffChangeBase.compareContents(fragment, documents, policy, ThreeSide.LEFT, ThreeSide.RIGHT);
            return new ConflictType(equalModifications ? TextDiffType.INSERTED : TextDiffType.CONFLICT);
        }
        if (isLeftEmpty && isRightEmpty) {
            return new ConflictType(TextDiffType.DELETED);
        }
        boolean unchangedLeft = ThreesideDiffChangeBase.compareContents(fragment, documents, policy, ThreeSide.BASE, ThreeSide.LEFT);
        boolean unchangedRight = ThreesideDiffChangeBase.compareContents(fragment, documents, policy, ThreeSide.BASE, ThreeSide.RIGHT);
        assert (!unchangedLeft || !unchangedRight);
        if (unchangedLeft) {
            return new ConflictType(isRightEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, false, true);
        }
        if (unchangedRight) {
            return new ConflictType(isLeftEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, true, false);
        }
        boolean equalModifications = ThreesideDiffChangeBase.compareContents(fragment, documents, policy, ThreeSide.LEFT, ThreeSide.RIGHT);
        return new ConflictType(equalModifications ? TextDiffType.MODIFIED : TextDiffType.CONFLICT);
    }

    private static boolean compareContents(@NotNull MergeLineFragment fragment, @NotNull List<? extends Document> documents, @NotNull ComparisonPolicy policy, @NotNull ThreeSide side1, @NotNull ThreeSide side2) {
        int start1 = fragment.getStartLine(side1);
        int end1 = fragment.getEndLine(side1);
        int start2 = fragment.getStartLine(side2);
        int end2 = fragment.getEndLine(side2);
        if (end2 - start2 != end1 - start1) {
            return false;
        }
        Document document1 = (Document)side1.select(documents);
        Document document2 = (Document)side2.select(documents);
        for (int i = 0; i < end1 - start1; ++i) {
            int line1 = start1 + i;
            int line2 = start2 + i;
            CharSequence content1 = DiffUtil.getLinesContent(document1, line1, line1 + 1);
            CharSequence content2 = DiffUtil.getLinesContent(document2, line2, line2 + 1);
            if (ComparisonManager.getInstance().isEquals(content1, content2, policy)) continue;
            return false;
        }
        return true;
    }

    private static boolean isIntervalEmpty(@NotNull MergeLineFragment fragment, @NotNull ThreeSide side) {
        return fragment.getStartLine(side) == fragment.getEndLine(side);
    }

    public static class ConflictType {
        @NotNull
        private final TextDiffType myType;
        private final boolean myLeftChange;
        private final boolean myRightChange;

        public ConflictType(@NotNull TextDiffType type) {
            this(type, true, true);
        }

        public ConflictType(@NotNull TextDiffType type, boolean leftChange, boolean rightChange) {
            this.myType = type;
            this.myLeftChange = leftChange;
            this.myRightChange = rightChange;
        }

        @NotNull
        public TextDiffType getDiffType() {
            return this.myType;
        }

        public boolean isLeftChange() {
            return this.myLeftChange;
        }

        public boolean isRightChange() {
            return this.myRightChange;
        }

        public boolean isChange(@NotNull Side side) {
            return side.isLeft() ? this.myLeftChange : this.myRightChange;
        }
    }
}

