/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SimpleThreesideDiffChange
extends ThreesideDiffChangeBase {
    @NotNull
    private final List<? extends EditorEx> myEditors;
    @NotNull
    private final MergeLineFragment myFragment;
    @NotNull
    private final List<RangeHighlighter> myHighlighters = new ArrayList<RangeHighlighter>();
    private int[] myLineStartShifts = new int[3];
    private int[] myLineEndShifts = new int[3];

    public SimpleThreesideDiffChange(@NotNull MergeLineFragment fragment, @NotNull List<? extends EditorEx> editors, @NotNull ComparisonPolicy policy) {
        super(fragment, editors, policy);
        this.myEditors = editors;
        this.myFragment = fragment;
        this.installHighlighter();
    }

    public void installHighlighter() {
        assert (this.myHighlighters.isEmpty());
        this.createHighlighter(ThreeSide.BASE);
        if (this.getType().isLeftChange()) {
            this.createHighlighter(ThreeSide.LEFT);
        }
        if (this.getType().isRightChange()) {
            this.createHighlighter(ThreeSide.RIGHT);
        }
    }

    public void destroyHighlighter() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
    }

    private void createHighlighter(@NotNull ThreeSide side) {
        Editor editor = (Editor)side.select(this.myEditors);
        TextDiffType type = this.getDiffType();
        int startLine = this.myFragment.getStartLine(side);
        int endLine = this.myFragment.getEndLine(side);
        boolean hasInner = this.myFragment.getInnerFragments() != null;
        int start = DiffUtil.getLinesRange(editor.getDocument(), startLine, endLine).getStartOffset();
        this.myHighlighters.addAll(DiffDrawUtil.createHighlighter(editor, startLine, endLine, type, hasInner));
        this.myHighlighters.addAll(DiffDrawUtil.createLineMarker(editor, startLine, endLine, type, false));
        if (hasInner) {
            for (MergeWordFragment innerFragment : this.myFragment.getInnerFragments()) {
                int startOffset = innerFragment.getStartOffset(side);
                int endOffset = innerFragment.getEndOffset(side);
                this.myHighlighters.addAll(DiffDrawUtil.createInlineHighlighter(editor, start + startOffset, start + endOffset, type));
            }
        }
    }

    @Override
    public int getStartLine(@NotNull ThreeSide side) {
        return this.myFragment.getStartLine(side) + side.select(this.myLineStartShifts);
    }

    @Override
    public int getEndLine(@NotNull ThreeSide side) {
        return this.myFragment.getEndLine(side) + side.select(this.myLineEndShifts);
    }

    public boolean processChange(int oldLine1, int oldLine2, int shift, @NotNull ThreeSide side) {
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        int sideIndex = side.getIndex();
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(line1, line2, oldLine1, oldLine2, shift);
        int n = sideIndex;
        this.myLineStartShifts[n] = this.myLineStartShifts[n] + (newRange.startLine - line1);
        int n2 = sideIndex;
        this.myLineEndShifts[n2] = this.myLineEndShifts[n2] + (newRange.endLine - line2);
        return newRange.damaged;
    }
}

