/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.holders;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorHolder
extends EditorHolder {
    @NotNull
    protected final EditorEx myEditor;

    public TextEditorHolder(@NotNull EditorEx editor) {
        this.myEditor = editor;
    }

    @NotNull
    public EditorEx getEditor() {
        return this.myEditor;
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myEditor.getComponent();
    }

    @Override
    public void installFocusListener(@NotNull FocusListener listener2) {
        this.myEditor.getContentComponent().addFocusListener(listener2);
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getContentComponent();
    }

    public static class TextEditorHolderFactory
    extends EditorHolderFactory<TextEditorHolder> {
        public static TextEditorHolderFactory INSTANCE = new TextEditorHolderFactory();

        @Override
        @NotNull
        public TextEditorHolder create(@NotNull DiffContent content, @NotNull DiffContext context) {
            if (!(content instanceof DocumentContent)) {
                throw new IllegalArgumentException(content.toString());
            }
            Project project2 = context.getProject();
            DocumentContent documentContent = (DocumentContent)content;
            EditorEx editor = DiffUtil.createEditor(documentContent.getDocument(), project2, false, true);
            DiffUtil.configureEditor(editor, documentContent, project2);
            return new TextEditorHolder(editor);
        }

        @Override
        public boolean canShowContent(@NotNull DiffContent content, @NotNull DiffContext context) {
            return content instanceof DocumentContent;
        }

        @Override
        public boolean wantShowContent(@NotNull DiffContent content, @NotNull DiffContext context) {
            return content instanceof DocumentContent;
        }
    }
}

