/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.fragmented.ChangedBlock;
import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class UnifiedFragmentBuilder {
    @NotNull
    private final List<LineFragment> myFragments;
    @NotNull
    private final Document myDocument1;
    @NotNull
    private final Document myDocument2;
    @NotNull
    private final Side myMasterSide;
    @NotNull
    private final StringBuilder myBuilder = new StringBuilder();
    @NotNull
    private final List<ChangedBlock> myBlocks = new ArrayList<ChangedBlock>();
    @NotNull
    private final List<HighlightRange> myRanges = new ArrayList<HighlightRange>();
    @NotNull
    private final LineNumberConvertor.Builder myConvertor = new LineNumberConvertor.Builder();
    @NotNull
    private final List<LineRange> myChangedLines = new ArrayList<LineRange>();
    private boolean myEqual = false;
    private int lastProcessedLine1 = -1;
    private int lastProcessedLine2 = -1;
    private int totalLines = 0;

    public UnifiedFragmentBuilder(@NotNull List<LineFragment> fragments, @NotNull Document document1, @NotNull Document document2, @NotNull Side masterSide) {
        this.myFragments = fragments;
        this.myDocument1 = document1;
        this.myDocument2 = document2;
        this.myMasterSide = masterSide;
    }

    public void exec() {
        if (this.myFragments.isEmpty()) {
            this.myEqual = true;
            this.appendTextMaster(0, 0, UnifiedFragmentBuilder.getLineCount(this.myDocument1) - 1, UnifiedFragmentBuilder.getLineCount(this.myDocument2) - 1);
            return;
        }
        for (LineFragment fragment : this.myFragments) {
            this.processEquals(fragment.getStartLine1() - 1, fragment.getStartLine2() - 1);
            this.processChanged(fragment);
        }
        this.processEquals(UnifiedFragmentBuilder.getLineCount(this.myDocument1) - 1, UnifiedFragmentBuilder.getLineCount(this.myDocument2) - 1);
    }

    private void processEquals(int endLine1, int endLine2) {
        int startLine1 = this.lastProcessedLine1 + 1;
        int startLine2 = this.lastProcessedLine2 + 1;
        this.appendTextMaster(startLine1, startLine2, endLine1, endLine2);
    }

    private void processChanged(@NotNull LineFragment fragment) {
        int startLine1 = fragment.getStartLine1();
        int endLine1 = fragment.getEndLine1() - 1;
        int lines1 = endLine1 - startLine1;
        int startLine2 = fragment.getStartLine2();
        int endLine2 = fragment.getEndLine2() - 1;
        int lines2 = endLine2 - startLine2;
        int linesBefore = this.totalLines;
        if (lines1 >= 0) {
            int startOffset = this.myDocument1.getLineStartOffset(startLine1);
            int endOffset = this.myDocument1.getLineEndOffset(endLine1);
            this.appendTextSide(Side.LEFT, startOffset, endOffset, lines1, startLine1, -1);
        }
        int linesBetween = this.totalLines;
        if (lines2 >= 0) {
            int startOffset = this.myDocument2.getLineStartOffset(startLine2);
            int endOffset = this.myDocument2.getLineEndOffset(endLine2);
            this.appendTextSide(Side.RIGHT, startOffset, endOffset, lines2, -1, startLine2);
        }
        int linesAfter = this.totalLines;
        int blockStartLine1 = linesBefore;
        int blockEndLine1 = linesBetween;
        int blockStartLine2 = linesBetween;
        int blockEndLine2 = linesAfter;
        this.myBlocks.add(new ChangedBlock(linesBefore, linesAfter, new LineRange(blockStartLine1, blockEndLine1), new LineRange(blockStartLine2, blockEndLine2), fragment));
        this.lastProcessedLine1 = endLine1;
        this.lastProcessedLine2 = endLine2;
    }

    private void appendTextMaster(int startLine1, int startLine2, int endLine1, int endLine2) {
        int lines;
        int n = lines = this.myMasterSide.isLeft() ? endLine1 - startLine1 : endLine2 - startLine2;
        if (lines >= 0) {
            int startOffset = this.myMasterSide.isLeft() ? this.myDocument1.getLineStartOffset(startLine1) : this.myDocument2.getLineStartOffset(startLine2);
            int endOffset = this.myMasterSide.isLeft() ? this.myDocument1.getLineEndOffset(endLine1) : this.myDocument2.getLineEndOffset(endLine2);
            this.appendText(this.myMasterSide, startOffset, endOffset, lines, startLine1, startLine2);
        }
    }

    private void appendTextSide(@NotNull Side side, int offset1, int offset2, int lines, int startLine1, int startLine2) {
        int linesBefore = this.totalLines;
        this.appendText(side, offset1, offset2, lines, startLine1, startLine2);
        int linesAfter = this.totalLines;
        this.myChangedLines.add(new LineRange(linesBefore, linesAfter));
    }

    private void appendText(@NotNull Side side, int offset1, int offset2, int lines, int startLine1, int startLine2) {
        Document document = (Document)side.select((Object)this.myDocument1, (Object)this.myDocument2);
        int newline = document.getTextLength() > offset2 + 1 ? 1 : 0;
        TextRange base = new TextRange(this.myBuilder.length(), this.myBuilder.length() + offset2 - offset1 + newline);
        TextRange changed = new TextRange(offset1, offset2 + newline);
        this.myRanges.add(new HighlightRange(side, base, changed));
        this.myBuilder.append(document.getCharsSequence().subSequence(offset1, offset2));
        this.myBuilder.append('\n');
        if (startLine1 != -1) {
            this.myConvertor.put1(this.totalLines, startLine1, lines + 1);
        }
        if (startLine2 != -1) {
            this.myConvertor.put2(this.totalLines, startLine2, lines + 1);
        }
        this.totalLines += lines + 1;
    }

    private static int getLineCount(@NotNull Document document) {
        return Math.max(document.getLineCount(), 1);
    }

    public boolean isEqual() {
        return this.myEqual;
    }

    @NotNull
    public CharSequence getText() {
        return this.myBuilder;
    }

    @NotNull
    public List<ChangedBlock> getBlocks() {
        return this.myBlocks;
    }

    @NotNull
    public List<HighlightRange> getRanges() {
        return this.myRanges;
    }

    @NotNull
    public LineNumberConvertor getConvertor() {
        return this.myConvertor.build();
    }

    @NotNull
    public List<LineRange> getChangedLines() {
        return this.myChangedLines;
    }
}

