/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.BufferedLineIterator;
import com.intellij.diff.actions.NavigationContextChecker;
import com.intellij.diff.actions.impl.OpenInEditorWithMouseAction;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.fragmented.ChangedBlock;
import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.fragmented.UnifiedContentPanel;
import com.intellij.diff.tools.fragmented.UnifiedDiffChange;
import com.intellij.diff.tools.fragmented.UnifiedDiffPanel;
import com.intellij.diff.tools.fragmented.UnifiedEditorHighlighter;
import com.intellij.diff.tools.fragmented.UnifiedEditorRangeHighlighter;
import com.intellij.diff.tools.fragmented.UnifiedFragmentBuilder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.InitialScrollPositionSupport;
import com.intellij.diff.tools.util.base.ListenerDiffViewerBase;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.TwosideTextDiffViewer;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineCol;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntFunction;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedDiffViewer
extends ListenerDiffViewerBase {
    public static final Logger LOG = Logger.getInstance(UnifiedDiffViewer.class);
    @NotNull
    protected final EditorEx myEditor;
    @NotNull
    protected final Document myDocument;
    @NotNull
    private final UnifiedDiffPanel myPanel;
    @NotNull
    private final SetEditorSettingsAction myEditorSettingsAction;
    @NotNull
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final MyStatusPanel myStatusPanel;
    @NotNull
    private final MyInitialScrollHelper myInitialScrollHelper = new MyInitialScrollHelper();
    @NotNull
    private final MyFoldingModel myFoldingModel;
    @NotNull
    protected Side myMasterSide = Side.RIGHT;
    @Nullable
    private ChangedBlockData myChangedBlockData;
    private final boolean[] myForceReadOnlyFlags;
    private boolean myReadOnlyLockSet = false;
    private boolean myDuringOnesideDocumentModification;
    private boolean myDuringTwosideDocumentModification;
    private boolean myStateIsOutOfDate;
    private boolean mySuppressEditorTyping;

    public UnifiedDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        super(context, (ContentDiffRequest)request);
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myStatusPanel = new MyStatusPanel();
        this.myForceReadOnlyFlags = TextDiffViewerUtil.checkForceReadOnly(this.myContext, this.myRequest);
        boolean leftEditable = this.isEditable(Side.LEFT, false);
        boolean rightEditable = this.isEditable(Side.RIGHT, false);
        if (leftEditable && !rightEditable) {
            this.myMasterSide = Side.LEFT;
        }
        if (!leftEditable && rightEditable) {
            this.myMasterSide = Side.RIGHT;
        }
        this.myDocument = EditorFactory.getInstance().createDocument((CharSequence)"");
        this.myEditor = DiffUtil.createEditor(this.myDocument, this.myProject, true, true);
        List<JComponent> titles = DiffUtil.createTextTitles(this.myRequest, ContainerUtil.list((Object[])new EditorEx[]{this.myEditor, this.myEditor}));
        UnifiedContentPanel contentPanel = new UnifiedContentPanel(titles, this.myEditor);
        this.myPanel = new UnifiedDiffPanel(this.myProject, contentPanel, this, this.myContext);
        this.myFoldingModel = new MyFoldingModel(this.myEditor, (Disposable)this);
        this.myEditorSettingsAction = new SetEditorSettingsAction(this.getTextSettings(), this.getEditors());
        this.myEditorSettingsAction.applyDefaults();
        new MyOpenInEditorWithMouseAction().register(this.getEditors());
        TextDiffViewerUtil.checkDifferentDocuments(this.myRequest);
        DiffUtil.registerAction(new ReplaceSelectedChangesAction(Side.LEFT, true), this.myPanel);
        DiffUtil.registerAction(new AppendSelectedChangesAction(Side.LEFT, true), this.myPanel);
        DiffUtil.registerAction(new ReplaceSelectedChangesAction(Side.RIGHT, true), this.myPanel);
        DiffUtil.registerAction(new AppendSelectedChangesAction(Side.RIGHT, true), this.myPanel);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.installEditorListeners();
        this.installTypingSupport();
        this.myPanel.setLoadingContent();
        this.myPanel.setPersistentNotifications(DiffUtil.getCustomNotifications(this.myContext, (DiffRequest)this.myRequest));
    }

    @Override
    protected void onDispose() {
        super.onDispose();
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        Side side = (Side)DiffUtil.getUserData((UserDataHolder)this.myRequest, (UserDataHolder)this.myContext, DiffUserDataKeys.MASTER_SIDE);
        if (side != null) {
            this.myMasterSide = side;
        }
        this.myInitialScrollHelper.processContext((DiffRequest)this.myRequest);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myInitialScrollHelper.updateContext((DiffRequest)this.myRequest);
        this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
    }

    protected void updateEditorCanBeTyped() {
        this.myEditor.setViewer(this.mySuppressEditorTyping || !this.isEditable(this.myMasterSide, true));
    }

    private void installTypingSupport() {
        if (!this.isEditable(this.myMasterSide, false)) {
            return;
        }
        this.updateEditorCanBeTyped();
        this.myEditor.getColorsScheme().setColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR, null);
        EditorActionManager.getInstance().setReadonlyFragmentModificationHandler(this.myDocument, (ReadonlyFragmentModificationHandler)new MyReadonlyFragmentModificationHandler());
        this.myDocument.putUserData(UndoManager.ORIGINAL_DOCUMENT, (Object)this.getDocument(this.myMasterSide));
        this.myDocument.addDocumentListener((DocumentListener)new MyOnesideDocumentListener());
    }

    @Override
    @NotNull
    public List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)new MyIgnorePolicySettingAction());
        group.add((AnAction)new MyHighlightPolicySettingAction());
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        group.add((AnAction)new MyReadOnlyLockAction());
        group.add((AnAction)this.myEditorSettingsAction);
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createToolbarActions());
        return group;
    }

    @Override
    @NotNull
    public List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new MyIgnorePolicySettingAction().getPopupGroup());
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new MyHighlightPolicySettingAction().getPopupGroup());
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createPopupActions());
        return group;
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        if (this.isEditable(Side.RIGHT, false)) {
            group.add(new ReplaceSelectedChangesAction(Side.LEFT, false));
            group.add(new ReplaceSelectedChangesAction(Side.RIGHT, false));
        }
        group.add((AnAction)Separator.getInstance());
        group.addAll(TextDiffViewerUtil.createEditorPopupActions());
        return group;
    }

    protected void installEditorListeners() {
        new TextDiffViewerUtil.EditorActionsPopup(this.createEditorPopupActions()).install(this.getEditors());
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
    }

    @Override
    @NotNull
    protected Runnable performRediff(final @NotNull ProgressIndicator indicator) {
        try {
            indicator.checkCanceled();
            final Document document1 = this.getContent1().getDocument();
            final Document document2 = this.getContent2().getDocument();
            final CharSequence[] texts = (CharSequence[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<CharSequence[]>(){

                public CharSequence[] compute() {
                    return new CharSequence[]{document1.getImmutableCharSequence(), document2.getImmutableCharSequence()};
                }
            });
            final List<LineFragment> fragments = DiffUtil.compare((DiffRequest)this.myRequest, texts[0], texts[1], this.getDiffConfig(), indicator);
            final DocumentContent content1 = this.getContent1();
            final DocumentContent content2 = this.getContent2();
            indicator.checkCanceled();
            TwosideDocumentData data = (TwosideDocumentData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<TwosideDocumentData>(){

                public TwosideDocumentData compute() {
                    indicator.checkCanceled();
                    UnifiedFragmentBuilder builder = new UnifiedFragmentBuilder(fragments, document1, document2, UnifiedDiffViewer.this.myMasterSide);
                    builder.exec();
                    indicator.checkCanceled();
                    EditorHighlighter highlighter = UnifiedDiffViewer.this.buildHighlighter(UnifiedDiffViewer.this.myProject, content1, content2, texts[0], texts[1], builder.getRanges(), builder.getText().length());
                    UnifiedEditorRangeHighlighter rangeHighlighter = new UnifiedEditorRangeHighlighter(UnifiedDiffViewer.this.myProject, document1, document2, builder.getRanges());
                    return new TwosideDocumentData(builder, highlighter, rangeHighlighter);
                }
            });
            UnifiedFragmentBuilder builder = data.getBuilder();
            FileType fileType = content2.getContentType() == null ? content1.getContentType() : content2.getContentType();
            LineNumberConvertor convertor = builder.getConvertor();
            List<LineRange> changedLines = builder.getChangedLines();
            boolean isContentsEqual = builder.isEqual();
            CombinedEditorData editorData = new CombinedEditorData(builder.getText(), data.getHighlighter(), data.getRangeHighlighter(), fileType, convertor.createConvertor1(), convertor.createConvertor2());
            return this.apply(editorData, builder.getBlocks(), convertor, changedLines, isContentsEqual);
        }
        catch (DiffTooBigException e) {
            return new Runnable(){

                @Override
                public void run() {
                    UnifiedDiffViewer.this.clearDiffPresentation();
                    UnifiedDiffViewer.this.myPanel.setTooBigContent();
                }
            };
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return new Runnable(){

                @Override
                public void run() {
                    UnifiedDiffViewer.this.clearDiffPresentation();
                    UnifiedDiffViewer.this.myPanel.setErrorContent();
                }
            };
        }
    }

    private void clearDiffPresentation() {
        this.myPanel.resetNotifications();
        this.myStatusPanel.setBusy(false);
        this.destroyChangedBlockData();
        this.myStateIsOutOfDate = false;
        this.mySuppressEditorTyping = false;
        this.updateEditorCanBeTyped();
    }

    protected void markSuppressEditorTyping() {
        this.mySuppressEditorTyping = true;
        this.updateEditorCanBeTyped();
    }

    protected void markStateIsOutOfDate() {
        this.myStateIsOutOfDate = true;
        if (this.myChangedBlockData != null) {
            for (UnifiedDiffChange diffChange : this.myChangedBlockData.getDiffChanges()) {
                diffChange.updateGutterActions();
            }
        }
    }

    @Nullable
    private EditorHighlighter buildHighlighter(@Nullable Project project2, @NotNull DocumentContent content1, @NotNull DocumentContent content2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<HighlightRange> ranges, int textLength) {
        EditorHighlighter highlighter1 = DiffUtil.initEditorHighlighter(project2, content1, text1);
        EditorHighlighter highlighter2 = DiffUtil.initEditorHighlighter(project2, content2, text2);
        if (highlighter1 == null && highlighter2 == null) {
            return null;
        }
        if (highlighter1 == null) {
            highlighter1 = DiffUtil.initEmptyEditorHighlighter(text1);
        }
        if (highlighter2 == null) {
            highlighter2 = DiffUtil.initEmptyEditorHighlighter(text2);
        }
        return new UnifiedEditorHighlighter(this.myDocument, highlighter1, highlighter2, ranges, textLength);
    }

    @NotNull
    private Runnable apply(final @NotNull CombinedEditorData data, final @NotNull List<ChangedBlock> blocks, final @NotNull LineNumberConvertor convertor, final @NotNull List<LineRange> changedLines, final boolean isContentsEqual) {
        return new Runnable(){

            @Override
            public void run() {
                UnifiedDiffViewer.this.myFoldingModel.updateContext((UserDataHolder)UnifiedDiffViewer.this.myRequest, UnifiedDiffViewer.this.getFoldingModelSettings());
                UnifiedDiffViewer.this.clearDiffPresentation();
                if (isContentsEqual) {
                    UnifiedDiffViewer.this.myPanel.addNotification(DiffNotifications.createEqualContents());
                }
                TIntFunction separatorLines = UnifiedDiffViewer.this.myFoldingModel.getLineNumberConvertor();
                UnifiedDiffViewer.this.myEditor.getGutterComponentEx().setLineNumberConvertor(UnifiedDiffViewer.mergeConverters(data.getLineConvertor1(), separatorLines), UnifiedDiffViewer.mergeConverters(data.getLineConvertor2(), separatorLines));
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        UnifiedDiffViewer.this.myDuringOnesideDocumentModification = true;
                        try {
                            UnifiedDiffViewer.this.myDocument.setText(data.getText());
                        }
                        finally {
                            UnifiedDiffViewer.this.myDuringOnesideDocumentModification = false;
                        }
                    }
                });
                if (data.getHighlighter() != null) {
                    UnifiedDiffViewer.this.myEditor.setHighlighter(data.getHighlighter());
                }
                DiffUtil.setEditorCodeStyle(UnifiedDiffViewer.this.myProject, UnifiedDiffViewer.this.myEditor, data.getFileType());
                if (data.getRangeHighlighter() != null) {
                    data.getRangeHighlighter().apply(UnifiedDiffViewer.this.myProject, UnifiedDiffViewer.this.myDocument);
                }
                ArrayList<UnifiedDiffChange> diffChanges = new ArrayList<UnifiedDiffChange>(blocks.size());
                for (Object block : blocks) {
                    diffChanges.add(new UnifiedDiffChange(UnifiedDiffViewer.this, (ChangedBlock)block));
                }
                ArrayList<RangeMarker> guarderRangeBlocks = new ArrayList<RangeMarker>();
                if (!UnifiedDiffViewer.this.myEditor.isViewer()) {
                    for (ChangedBlock block : blocks) {
                        LineRange range = (LineRange)UnifiedDiffViewer.this.myMasterSide.select((Object)block.getRange2(), (Object)block.getRange1());
                        TextRange textRange = DiffUtil.getLinesRange(UnifiedDiffViewer.this.myDocument, range.start, range.end);
                        if (textRange.isEmpty()) continue;
                        guarderRangeBlocks.add(UnifiedDiffViewer.this.createGuardedBlock(textRange.getStartOffset(), textRange.getEndOffset()));
                    }
                    int textLength = UnifiedDiffViewer.this.myDocument.getTextLength();
                    guarderRangeBlocks.add(UnifiedDiffViewer.this.createGuardedBlock(textLength, textLength));
                }
                UnifiedDiffViewer.this.myChangedBlockData = new ChangedBlockData(diffChanges, guarderRangeBlocks, convertor, isContentsEqual);
                UnifiedDiffViewer.this.myFoldingModel.install(changedLines, (UserDataHolder)UnifiedDiffViewer.this.myRequest, UnifiedDiffViewer.this.getFoldingModelSettings());
                UnifiedDiffViewer.this.myInitialScrollHelper.onRediff();
                UnifiedDiffViewer.this.myStatusPanel.update();
                UnifiedDiffViewer.this.myPanel.setGoodContent();
            }
        };
    }

    @NotNull
    private RangeMarker createGuardedBlock(int start, int end) {
        RangeMarker block = this.myDocument.createGuardedBlock(start, end);
        block.setGreedyToLeft(true);
        block.setGreedyToRight(true);
        return block;
    }

    @Contract(value="!null, _ -> !null")
    private static TIntFunction mergeConverters(final @NotNull TIntFunction convertor, final @NotNull TIntFunction separatorLines) {
        return new TIntFunction(){

            public int execute(int value) {
                return convertor.execute(separatorLines.execute(value));
            }
        };
    }

    public int transferLineToOnesideStrict(@NotNull Side side, int line) {
        if (this.myChangedBlockData == null) {
            return -1;
        }
        LineNumberConvertor lineConvertor = this.myChangedBlockData.getLineNumberConvertor();
        return side.isLeft() ? lineConvertor.convertInv1(line) : lineConvertor.convertInv2(line);
    }

    public int transferLineFromOnesideStrict(@NotNull Side side, int line) {
        if (this.myChangedBlockData == null) {
            return -1;
        }
        LineNumberConvertor lineConvertor = this.myChangedBlockData.getLineNumberConvertor();
        return side.isLeft() ? lineConvertor.convert1(line) : lineConvertor.convert2(line);
    }

    public int transferLineToOneside(@NotNull Side side, int line) {
        if (this.myChangedBlockData == null) {
            return line;
        }
        LineNumberConvertor lineConvertor = this.myChangedBlockData.getLineNumberConvertor();
        return side.isLeft() ? lineConvertor.convertApproximateInv1(line) : lineConvertor.convertApproximateInv2(line);
    }

    @NotNull
    public Pair<int[], Side> transferLineFromOneside(int line) {
        int[] lines = new int[2];
        if (this.myChangedBlockData == null) {
            lines[0] = line;
            lines[1] = line;
            return Pair.create((Object)lines, (Object)this.myMasterSide);
        }
        LineNumberConvertor lineConvertor = this.myChangedBlockData.getLineNumberConvertor();
        Side side = this.myMasterSide;
        lines[0] = lineConvertor.convert1(line);
        lines[1] = lineConvertor.convert2(line);
        if (lines[0] == -1 && lines[1] == -1) {
            lines[0] = lineConvertor.convertApproximate1(line);
            lines[1] = lineConvertor.convertApproximate2(line);
        } else if (lines[0] == -1) {
            lines[0] = lineConvertor.convertApproximate1(line);
            side = Side.RIGHT;
        } else if (lines[1] == -1) {
            lines[1] = lineConvertor.convertApproximate2(line);
            side = Side.LEFT;
        }
        return Pair.create((Object)lines, (Object)side);
    }

    private void destroyChangedBlockData() {
        if (this.myChangedBlockData == null) {
            return;
        }
        for (UnifiedDiffChange change : this.myChangedBlockData.getDiffChanges()) {
            change.destroyHighlighter();
        }
        for (RangeMarker block : this.myChangedBlockData.getGuardedRangeBlocks()) {
            this.myDocument.removeGuardedBlock(block);
        }
        this.myChangedBlockData = null;
        UnifiedEditorRangeHighlighter.erase(this.myProject, this.myDocument);
        this.myFoldingModel.destroy();
        this.myStatusPanel.update();
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent e) {
        if (this.myDuringTwosideDocumentModification) {
            return;
        }
        this.markStateIsOutOfDate();
        this.markSuppressEditorTyping();
        this.myFoldingModel.onDocumentChanged(e);
        this.scheduleRediff();
    }

    public void replaceChange(@NotNull UnifiedDiffChange change, @NotNull Side sourceSide) {
        Side outputSide = sourceSide.other();
        Document document1 = this.getDocument(Side.LEFT);
        Document document2 = this.getDocument(Side.RIGHT);
        LineFragment lineFragment = change.getLineFragment();
        DiffUtil.applyModification((Document)outputSide.select((Object)document1, (Object)document2), outputSide.getStartLine(lineFragment), outputSide.getEndLine(lineFragment), (Document)sourceSide.select((Object)document1, (Object)document2), sourceSide.getStartLine(lineFragment), sourceSide.getEndLine(lineFragment));
    }

    public void appendChange(@NotNull UnifiedDiffChange change, @NotNull Side sourceSide) {
        Side outputSide = sourceSide.other();
        Document document1 = this.getDocument(Side.LEFT);
        Document document2 = this.getDocument(Side.RIGHT);
        LineFragment lineFragment = change.getLineFragment();
        if (sourceSide.getStartLine(lineFragment) == sourceSide.getEndLine(lineFragment)) {
            return;
        }
        DiffUtil.applyModification((Document)outputSide.select((Object)document1, (Object)document2), outputSide.getEndLine(lineFragment), outputSide.getEndLine(lineFragment), (Document)sourceSide.select((Object)document1, (Object)document2), sourceSide.getStartLine(lineFragment), sourceSide.getEndLine(lineFragment));
    }

    @NotNull
    public TextDiffSettingsHolder.TextDiffSettings getTextSettings() {
        return TextDiffViewerUtil.getTextSettings(this.myContext);
    }

    @NotNull
    public FoldingModelSupport.Settings getFoldingModelSettings() {
        return TextDiffViewerUtil.getFoldingModelSettings(this.myContext);
    }

    @NotNull
    private DiffUtil.DiffConfig getDiffConfig() {
        return new DiffUtil.DiffConfig(this.getIgnorePolicy(), this.getHighlightPolicy());
    }

    @NotNull
    private HighlightPolicy getHighlightPolicy() {
        HighlightPolicy policy = this.getTextSettings().getHighlightPolicy();
        if (policy == HighlightPolicy.DO_NOT_HIGHLIGHT) {
            return HighlightPolicy.BY_LINE;
        }
        return policy;
    }

    @NotNull
    private IgnorePolicy getIgnorePolicy() {
        IgnorePolicy policy = this.getTextSettings().getIgnorePolicy();
        if (policy == IgnorePolicy.IGNORE_WHITESPACES_CHUNKS) {
            return IgnorePolicy.IGNORE_WHITESPACES;
        }
        return policy;
    }

    @NotNull
    public Side getMasterSide() {
        return this.myMasterSide;
    }

    @NotNull
    public EditorEx getEditor() {
        return this.myEditor;
    }

    @NotNull
    protected List<? extends EditorEx> getEditors() {
        return Collections.singletonList(this.myEditor);
    }

    @NotNull
    protected List<? extends DocumentContent> getContents() {
        return this.myRequest.getContents();
    }

    @NotNull
    protected DocumentContent getContent(@NotNull Side side) {
        return (DocumentContent)side.select(this.getContents());
    }

    @NotNull
    protected DocumentContent getContent1() {
        return this.getContent(Side.LEFT);
    }

    @NotNull
    protected DocumentContent getContent2() {
        return this.getContent(Side.RIGHT);
    }

    @Nullable
    protected List<UnifiedDiffChange> getDiffChanges() {
        return this.myChangedBlockData == null ? null : this.myChangedBlockData.getDiffChanges();
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (!this.myPanel.isGoodContent()) {
            return null;
        }
        return this.myEditor.getContentComponent();
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        return this.myStatusPanel;
    }

    public boolean isEditable(@NotNull Side side, boolean respectReadOnlyLock) {
        if (this.myReadOnlyLockSet && respectReadOnlyLock) {
            return false;
        }
        if (side.select(this.myForceReadOnlyFlags)) {
            return false;
        }
        return DiffUtil.canMakeWritable(this.getDocument(side));
    }

    @NotNull
    public Document getDocument(@NotNull Side side) {
        return this.getContent(side).getDocument();
    }

    protected boolean isStateIsOutOfDate() {
        return this.myStateIsOutOfDate;
    }

    @Override
    @Nullable
    protected OpenFileDescriptor getOpenFileDescriptor() {
        return this.getOpenFileDescriptor(this.myEditor.getCaretModel().getOffset());
    }

    @Nullable
    protected UnifiedDiffChange getCurrentChange() {
        if (this.myChangedBlockData == null) {
            return null;
        }
        int caretLine = this.myEditor.getCaretModel().getLogicalPosition().line;
        for (UnifiedDiffChange change : this.myChangedBlockData.getDiffChanges()) {
            if (!DiffUtil.isSelectedByLine(caretLine, change.getLine1(), change.getLine2())) continue;
            return change;
        }
        return null;
    }

    @NotNull
    private List<UnifiedDiffChange> getSelectedChanges() {
        if (this.myChangedBlockData == null) {
            return Collections.emptyList();
        }
        BitSet lines = DiffUtil.getSelectedLines(this.myEditor);
        List<UnifiedDiffChange> changes = this.myChangedBlockData.getDiffChanges();
        ArrayList<UnifiedDiffChange> affectedChanges = new ArrayList<UnifiedDiffChange>();
        for (int i = changes.size() - 1; i >= 0; --i) {
            int line2;
            UnifiedDiffChange change = changes.get(i);
            int line1 = change.getLine1();
            if (!DiffUtil.isSelectedByLine(lines, line1, line2 = change.getLine2())) continue;
            affectedChanges.add(change);
        }
        return affectedChanges;
    }

    @Nullable
    protected OpenFileDescriptor getOpenFileDescriptor(int offset) {
        LogicalPosition position = this.myEditor.offsetToLogicalPosition(offset);
        Pair<int[], Side> pair = this.transferLineFromOneside(position.line);
        int offset1 = DiffUtil.getOffset(this.getContent1().getDocument(), ((int[])pair.first)[0], position.column);
        int offset2 = DiffUtil.getOffset(this.getContent2().getDocument(), ((int[])pair.first)[1], position.column);
        OpenFileDescriptor descriptor1 = this.getContent1().getOpenFileDescriptor(offset1);
        OpenFileDescriptor descriptor2 = this.getContent2().getOpenFileDescriptor(offset2);
        if (descriptor1 == null) {
            return descriptor2;
        }
        if (descriptor2 == null) {
            return descriptor1;
        }
        return (OpenFileDescriptor)((Side)pair.second).select((Object)descriptor1, (Object)descriptor2);
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        return TwosideTextDiffViewer.canShowRequest(context, request);
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        UnifiedDiffChange change;
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return DiffUtil.getVirtualFile(this.myRequest, this.myMasterSide);
        }
        if (DiffDataKeys.CURRENT_EDITOR.is(dataId)) {
            return this.myEditor;
        }
        if (DiffDataKeys.CURRENT_CHANGE_RANGE.is(dataId) && (change = this.getCurrentChange()) != null) {
            return new LineRange(change.getLine1(), change.getLine2());
        }
        return super.getData(dataId);
    }

    private static class MyReadonlyFragmentModificationHandler
    implements ReadonlyFragmentModificationHandler {
        private MyReadonlyFragmentModificationHandler() {
        }

        public void handle(ReadOnlyFragmentModificationException e) {
        }
    }

    private static class MyFoldingModel
    extends FoldingModelSupport {
        public MyFoldingModel(@NotNull EditorEx editor, @NotNull Disposable disposable) {
            super(new EditorEx[]{editor}, disposable);
        }

        public void install(@Nullable List<LineRange> changedLines, @NotNull UserDataHolder context, @NotNull FoldingModelSupport.Settings settings) {
            Iterator<int[]> it = MyFoldingModel.map(changedLines, new Function<LineRange, int[]>(){

                public int[] fun(LineRange line) {
                    return new int[]{line.start, line.end};
                }
            });
            this.install(it, context, settings);
        }

        @NotNull
        public TIntFunction getLineNumberConvertor() {
            return this.getLineConvertor(0);
        }
    }

    private class MyInitialScrollHelper
    extends InitialScrollPositionSupport.TwosideInitialScrollHelper {
        private MyInitialScrollHelper() {
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            return UnifiedDiffViewer.this.getEditors();
        }

        @Override
        protected void disableSyncScroll(boolean value) {
        }

        @Override
        public void onSlowRediff() {
        }

        @Override
        @Nullable
        protected LogicalPosition[] getCaretPositions() {
            LogicalPosition position = UnifiedDiffViewer.this.myEditor.getCaretModel().getLogicalPosition();
            Pair<int[], Side> pair = UnifiedDiffViewer.this.transferLineFromOneside(position.line);
            LogicalPosition[] carets = new LogicalPosition[]{this.getPosition(((int[])pair.first)[0], position.column), this.getPosition(((int[])pair.first)[1], position.column)};
            return carets;
        }

        @Override
        protected boolean doScrollToPosition() {
            if (this.myCaretPosition == null) {
                return false;
            }
            LogicalPosition twosidePosition = (LogicalPosition)UnifiedDiffViewer.this.myMasterSide.selectNotNull((Object[])this.myCaretPosition);
            int onesideLine = UnifiedDiffViewer.this.transferLineToOneside(UnifiedDiffViewer.this.myMasterSide, twosidePosition.line);
            LogicalPosition position = new LogicalPosition(onesideLine, twosidePosition.column);
            UnifiedDiffViewer.this.myEditor.getCaretModel().moveToLogicalPosition(position);
            if (this.myEditorsPosition != null && this.myEditorsPosition.isSame(position)) {
                DiffUtil.scrollToPoint(UnifiedDiffViewer.this.myEditor, this.myEditorsPosition.myPoints[0], false);
            } else {
                DiffUtil.scrollToCaret(UnifiedDiffViewer.this.myEditor, false);
            }
            return true;
        }

        @NotNull
        private LogicalPosition getPosition(int line, int column) {
            if (line == -1) {
                return new LogicalPosition(0, 0);
            }
            return new LogicalPosition(line, column);
        }

        private void doScrollToLine(@NotNull Side side, @NotNull LogicalPosition position) {
            int onesideLine = UnifiedDiffViewer.this.transferLineToOneside(side, position.line);
            DiffUtil.scrollEditor(UnifiedDiffViewer.this.myEditor, onesideLine, position.column, false);
        }

        @Override
        protected boolean doScrollToLine() {
            if (this.myScrollToLine == null) {
                return false;
            }
            this.doScrollToLine((Side)this.myScrollToLine.first, new LogicalPosition(((Integer)this.myScrollToLine.second).intValue(), 0));
            return true;
        }

        private boolean doScrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                return false;
            }
            List<UnifiedDiffChange> changes = UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges();
            UnifiedDiffChange targetChange = scrollToChangePolicy.select(changes);
            if (targetChange == null) {
                return false;
            }
            DiffUtil.scrollEditor(UnifiedDiffViewer.this.myEditor, targetChange.getLine1(), false);
            return true;
        }

        @Override
        protected boolean doScrollToChange() {
            if (this.myScrollToChange == null) {
                return false;
            }
            return this.doScrollToChange(this.myScrollToChange);
        }

        @Override
        protected boolean doScrollToFirstChange() {
            return this.doScrollToChange(DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
        }

        @Override
        protected boolean doScrollToContext() {
            if (this.myNavigationContext == null) {
                return false;
            }
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                return false;
            }
            ChangedLinesIterator changedLinesIterator = new ChangedLinesIterator(Side.RIGHT, UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges());
            NavigationContextChecker checker = new NavigationContextChecker(changedLinesIterator, this.myNavigationContext);
            int line = checker.contextMatchCheck();
            if (line == -1) {
                AllLinesIterator allLinesIterator = new AllLinesIterator(Side.RIGHT);
                NavigationContextChecker checker2 = new NavigationContextChecker(allLinesIterator, this.myNavigationContext);
                line = checker2.contextMatchCheck();
            }
            if (line == -1) {
                return false;
            }
            this.doScrollToLine(Side.RIGHT, new LogicalPosition(line, 0));
            return true;
        }
    }

    private static class CombinedEditorData {
        @NotNull
        private final CharSequence myText;
        @Nullable
        private final EditorHighlighter myHighlighter;
        @Nullable
        private final UnifiedEditorRangeHighlighter myRangeHighlighter;
        @Nullable
        private final FileType myFileType;
        @NotNull
        private final TIntFunction myLineConvertor1;
        @NotNull
        private final TIntFunction myLineConvertor2;

        public CombinedEditorData(@NotNull CharSequence text, @Nullable EditorHighlighter highlighter, @Nullable UnifiedEditorRangeHighlighter rangeHighlighter, @Nullable FileType fileType, @NotNull TIntFunction convertor1, @NotNull TIntFunction convertor2) {
            this.myText = text;
            this.myHighlighter = highlighter;
            this.myRangeHighlighter = rangeHighlighter;
            this.myFileType = fileType;
            this.myLineConvertor1 = convertor1;
            this.myLineConvertor2 = convertor2;
        }

        @NotNull
        public CharSequence getText() {
            return this.myText;
        }

        @Nullable
        public EditorHighlighter getHighlighter() {
            return this.myHighlighter;
        }

        @Nullable
        public UnifiedEditorRangeHighlighter getRangeHighlighter() {
            return this.myRangeHighlighter;
        }

        @Nullable
        public FileType getFileType() {
            return this.myFileType;
        }

        @NotNull
        public TIntFunction getLineConvertor1() {
            return this.myLineConvertor1;
        }

        @NotNull
        public TIntFunction getLineConvertor2() {
            return this.myLineConvertor2;
        }
    }

    private static class ChangedBlockData {
        @NotNull
        private final List<UnifiedDiffChange> myDiffChanges;
        @NotNull
        private final List<RangeMarker> myGuardedRangeBlocks;
        @NotNull
        private final LineNumberConvertor myLineNumberConvertor;
        private final boolean myIsContentsEqual;

        public ChangedBlockData(@NotNull List<UnifiedDiffChange> diffChanges, @NotNull List<RangeMarker> guarderRangeBlocks, @NotNull LineNumberConvertor lineNumberConvertor, boolean isContentsEqual) {
            this.myDiffChanges = diffChanges;
            this.myGuardedRangeBlocks = guarderRangeBlocks;
            this.myLineNumberConvertor = lineNumberConvertor;
            this.myIsContentsEqual = isContentsEqual;
        }

        @NotNull
        public List<UnifiedDiffChange> getDiffChanges() {
            return this.myDiffChanges;
        }

        @NotNull
        public List<RangeMarker> getGuardedRangeBlocks() {
            return this.myGuardedRangeBlocks;
        }

        @NotNull
        public LineNumberConvertor getLineNumberConvertor() {
            return this.myLineNumberConvertor;
        }

        public boolean isContentsEqual() {
            return this.myIsContentsEqual;
        }
    }

    private static class TwosideDocumentData {
        @NotNull
        private final UnifiedFragmentBuilder myBuilder;
        @Nullable
        private final EditorHighlighter myHighlighter;
        @Nullable
        private final UnifiedEditorRangeHighlighter myRangeHighlighter;

        public TwosideDocumentData(@NotNull UnifiedFragmentBuilder builder, @Nullable EditorHighlighter highlighter, @Nullable UnifiedEditorRangeHighlighter rangeHighlighter) {
            this.myBuilder = builder;
            this.myHighlighter = highlighter;
            this.myRangeHighlighter = rangeHighlighter;
        }

        @NotNull
        public UnifiedFragmentBuilder getBuilder() {
            return this.myBuilder;
        }

        @Nullable
        public EditorHighlighter getHighlighter() {
            return this.myHighlighter;
        }

        @Nullable
        public UnifiedEditorRangeHighlighter getRangeHighlighter() {
            return this.myRangeHighlighter;
        }
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        @Nullable
        protected String getMessage() {
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                return null;
            }
            int changesCount = UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges().size();
            if (changesCount == 0 && !UnifiedDiffViewer.this.myChangedBlockData.isContentsEqual()) {
                return DiffBundle.message((String)"diff.all.differences.ignored.text", (Object[])new Object[0]);
            }
            return DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{changesCount});
        }
    }

    private class ChangedLinesIterator
    extends BufferedLineIterator {
        @NotNull
        private final Side mySide;
        @NotNull
        private final List<UnifiedDiffChange> myChanges;
        private int myIndex = 0;

        private ChangedLinesIterator(@NotNull Side side, List<UnifiedDiffChange> changes) {
            this.mySide = side;
            this.myChanges = changes;
            this.init();
        }

        @Override
        public boolean hasNextBlock() {
            return this.myIndex < this.myChanges.size();
        }

        @Override
        public void loadNextBlock() {
            LOG.assertTrue(!UnifiedDiffViewer.this.myStateIsOutOfDate);
            UnifiedDiffChange change = this.myChanges.get(this.myIndex);
            ++this.myIndex;
            LineFragment lineFragment = change.getLineFragment();
            Document document = UnifiedDiffViewer.this.getContent(this.mySide).getDocument();
            CharSequence insertedText = DiffUtil.getLinesContent(document, lineFragment.getStartLine2(), lineFragment.getEndLine2());
            int lineNumber = lineFragment.getStartLine2();
            LineTokenizer tokenizer = new LineTokenizer(insertedText.toString());
            for (String line : tokenizer.execute()) {
                this.addLine(lineNumber, line);
                ++lineNumber;
            }
        }
    }

    private class AllLinesIterator
    implements Iterator<Pair<Integer, CharSequence>> {
        @NotNull
        private final Side mySide;
        @NotNull
        private final Document myDocument;
        private int myLine = 0;

        private AllLinesIterator(Side side) {
            this.mySide = side;
            this.myDocument = UnifiedDiffViewer.this.getContent(this.mySide).getDocument();
        }

        @Override
        public boolean hasNext() {
            return this.myLine < DiffUtil.getLineCount(this.myDocument);
        }

        @Override
        public Pair<Integer, CharSequence> next() {
            int offset1 = this.myDocument.getLineStartOffset(this.myLine);
            int offset2 = this.myDocument.getLineEndOffset(this.myLine);
            CharSequence text = this.myDocument.getImmutableCharSequence().subSequence(offset1, offset2);
            Pair pair = new Pair((Object)this.myLine, (Object)text);
            ++this.myLine;
            return pair;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class MyReadOnlyLockAction
    extends TextDiffViewerUtil.ReadOnlyLockAction {
        public MyReadOnlyLockAction() {
            super(UnifiedDiffViewer.this.getContext());
            this.applyDefaults();
        }

        @Override
        protected void doApply(boolean readOnly) {
            UnifiedDiffViewer.this.myReadOnlyLockSet = readOnly;
            if (UnifiedDiffViewer.this.myChangedBlockData != null) {
                for (UnifiedDiffChange unifiedDiffChange : UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges()) {
                    unifiedDiffChange.updateGutterActions();
                }
            }
            UnifiedDiffViewer.this.updateEditorCanBeTyped();
        }

        @Override
        protected boolean canEdit() {
            return !UnifiedDiffViewer.this.myForceReadOnlyFlags[0] && DiffUtil.canMakeWritable(UnifiedDiffViewer.this.getContent1().getDocument()) || !UnifiedDiffViewer.this.myForceReadOnlyFlags[1] && DiffUtil.canMakeWritable(UnifiedDiffViewer.this.getContent2().getDocument());
        }
    }

    private class MyIgnorePolicySettingAction
    extends TextDiffViewerUtil.IgnorePolicySettingAction {
        public MyIgnorePolicySettingAction() {
            super(UnifiedDiffViewer.this.getTextSettings());
        }

        @Override
        @NotNull
        protected IgnorePolicy getCurrentSetting() {
            return UnifiedDiffViewer.this.getIgnorePolicy();
        }

        @Override
        @NotNull
        protected List<IgnorePolicy> getAvailableSettings() {
            ArrayList settings = ContainerUtil.newArrayList((Object[])IgnorePolicy.values());
            settings.remove((Object)IgnorePolicy.IGNORE_WHITESPACES_CHUNKS);
            return settings;
        }

        @Override
        protected void onSettingsChanged() {
            UnifiedDiffViewer.this.rediff();
        }
    }

    private class MyHighlightPolicySettingAction
    extends TextDiffViewerUtil.HighlightPolicySettingAction {
        public MyHighlightPolicySettingAction() {
            super(UnifiedDiffViewer.this.getTextSettings());
        }

        @Override
        @NotNull
        protected HighlightPolicy getCurrentSetting() {
            return UnifiedDiffViewer.this.getHighlightPolicy();
        }

        @Override
        @NotNull
        protected List<HighlightPolicy> getAvailableSettings() {
            ArrayList settings = ContainerUtil.newArrayList((Object[])HighlightPolicy.values());
            settings.remove((Object)HighlightPolicy.DO_NOT_HIGHLIGHT);
            return settings;
        }

        @Override
        protected void onSettingsChanged() {
            UnifiedDiffViewer.this.rediff();
        }
    }

    private class MyToggleExpandByDefaultAction
    extends TextDiffViewerUtil.ToggleExpandByDefaultAction {
        public MyToggleExpandByDefaultAction() {
            super(UnifiedDiffViewer.this.getTextSettings());
        }

        @Override
        protected void expandAll(boolean expand) {
            UnifiedDiffViewer.this.myFoldingModel.expandAll(expand);
        }
    }

    private class MyOpenInEditorWithMouseAction
    extends OpenInEditorWithMouseAction {
        private MyOpenInEditorWithMouseAction() {
        }

        @Override
        protected OpenFileDescriptor getDescriptor(@NotNull Editor editor, int line) {
            if (editor != UnifiedDiffViewer.this.myEditor) {
                return null;
            }
            return UnifiedDiffViewer.this.getOpenFileDescriptor(UnifiedDiffViewer.this.myEditor.logicalPositionToOffset(new LogicalPosition(line, 0)));
        }
    }

    private class MyPrevNextDifferenceIterable
    extends PrevNextDifferenceIterableBase<UnifiedDiffChange> {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        @NotNull
        protected List<UnifiedDiffChange> getChanges() {
            return ContainerUtil.notNullize(UnifiedDiffViewer.this.getDiffChanges());
        }

        @Override
        @NotNull
        protected EditorEx getEditor() {
            return UnifiedDiffViewer.this.myEditor;
        }

        @Override
        protected int getStartLine(@NotNull UnifiedDiffChange change) {
            return change.getLine1();
        }

        @Override
        protected int getEndLine(@NotNull UnifiedDiffChange change) {
            return change.getLine2();
        }

        @Override
        protected void scrollToChange(@NotNull UnifiedDiffChange change) {
            DiffUtil.scrollEditor(UnifiedDiffViewer.this.myEditor, change.getLine1(), true);
        }
    }

    private class AppendSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        public AppendSelectedChangesAction(Side focusedSide, boolean shortcut) {
            super(focusedSide.other(), shortcut);
            this.setShortcutSet(ActionManager.getInstance().getAction((String)focusedSide.select((Object)"Diff.AppendLeftSide", (Object)"Diff.AppendRightSide")).getShortcutSet());
            this.getTemplatePresentation().setText("Append");
            this.getTemplatePresentation().setIcon(DiffUtil.getArrowDownIcon(focusedSide));
        }

        @Override
        protected void apply(@NotNull List<UnifiedDiffChange> changes) {
            for (UnifiedDiffChange change : changes) {
                UnifiedDiffViewer.this.appendChange(change, this.myModifiedSide.other());
            }
        }
    }

    private class ReplaceSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        public ReplaceSelectedChangesAction(Side focusedSide, boolean shortcut) {
            super(focusedSide.other(), shortcut);
            this.setShortcutSet(ActionManager.getInstance().getAction((String)focusedSide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")).getShortcutSet());
            this.getTemplatePresentation().setText((String)focusedSide.select((Object)"Revert", (Object)"Accept"));
            this.getTemplatePresentation().setIcon((Icon)focusedSide.select((Object)AllIcons.Diff.Remove, (Object)AllIcons.Actions.Checked));
        }

        @Override
        protected void apply(@NotNull List<UnifiedDiffChange> changes) {
            for (UnifiedDiffChange change : changes) {
                UnifiedDiffViewer.this.replaceChange(change, this.myModifiedSide.other());
            }
        }
    }

    private abstract class ApplySelectedChangesActionBase
    extends AnAction
    implements DumbAware {
        @NotNull
        protected final Side myModifiedSide;
        protected final boolean myShortcut;

        public ApplySelectedChangesActionBase(Side modifiedSide, boolean shortcut) {
            this.myModifiedSide = modifiedSide;
            this.myShortcut = shortcut;
        }

        public void update(@NotNull AnActionEvent e) {
            if (this.myShortcut) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor != UnifiedDiffViewer.this.getEditor()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            if (!UnifiedDiffViewer.this.isEditable(this.myModifiedSide, true) || UnifiedDiffViewer.this.isStateIsOutOfDate()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(this.isSomeChangeSelected());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            final List selectedChanges = UnifiedDiffViewer.this.getSelectedChanges();
            if (selectedChanges.isEmpty()) {
                return;
            }
            if (!UnifiedDiffViewer.this.isEditable(this.myModifiedSide, true)) {
                return;
            }
            if (UnifiedDiffViewer.this.isStateIsOutOfDate()) {
                return;
            }
            String title = e.getPresentation().getText() + " selected changes";
            DiffUtil.executeWriteCommand(UnifiedDiffViewer.this.getDocument(this.myModifiedSide), e.getProject(), title, new Runnable(){

                @Override
                public void run() {
                    ApplySelectedChangesActionBase.this.apply(selectedChanges);
                    UnifiedDiffViewer.this.scheduleRediff();
                }
            });
        }

        protected boolean isSomeChangeSelected() {
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                return false;
            }
            List<UnifiedDiffChange> changes = UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges();
            if (changes.isEmpty()) {
                return false;
            }
            List carets = UnifiedDiffViewer.this.getEditor().getCaretModel().getAllCarets();
            if (carets.size() != 1) {
                return true;
            }
            Caret caret = (Caret)carets.get(0);
            if (caret.hasSelection()) {
                return true;
            }
            int line = UnifiedDiffViewer.this.getEditor().getDocument().getLineNumber(UnifiedDiffViewer.this.getEditor().getExpectedCaretOffset());
            for (UnifiedDiffChange change : changes) {
                if (!DiffUtil.isSelectedByLine(line, change.getLine1(), change.getLine2())) continue;
                return true;
            }
            return false;
        }

        protected abstract void apply(@NotNull List<UnifiedDiffChange> var1);
    }

    private class MyOnesideDocumentListener
    extends DocumentAdapter {
        private MyOnesideDocumentListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeDocumentChange(DocumentEvent e) {
            if (UnifiedDiffViewer.this.myDuringOnesideDocumentModification) {
                return;
            }
            if (UnifiedDiffViewer.this.myChangedBlockData == null) {
                LOG.warn("oneside beforeDocumentChange - myChangedBlockData == null");
                return;
            }
            try {
                UnifiedDiffViewer.this.myDuringTwosideDocumentModification = true;
                Document twosideDocument = UnifiedDiffViewer.this.getDocument(UnifiedDiffViewer.this.myMasterSide);
                LineCol onesideStartPosition = LineCol.fromOffset((Document)UnifiedDiffViewer.this.myDocument, (int)e.getOffset());
                LineCol onesideEndPosition = LineCol.fromOffset((Document)UnifiedDiffViewer.this.myDocument, (int)(e.getOffset() + e.getOldLength()));
                int line1 = onesideStartPosition.line;
                int line2 = onesideEndPosition.line + 1;
                int shift = DiffUtil.countLinesShift(e);
                int twosideStartLine = UnifiedDiffViewer.this.transferLineFromOnesideStrict(UnifiedDiffViewer.this.myMasterSide, onesideStartPosition.line);
                int twosideEndLine = UnifiedDiffViewer.this.transferLineFromOnesideStrict(UnifiedDiffViewer.this.myMasterSide, onesideEndPosition.line);
                if (twosideStartLine == -1 || twosideEndLine == -1) {
                    this.logDebugInfo(e, onesideStartPosition, onesideEndPosition, twosideStartLine, twosideEndLine);
                    UnifiedDiffViewer.this.markSuppressEditorTyping();
                    return;
                }
                int twosideStartOffset = twosideDocument.getLineStartOffset(twosideStartLine) + onesideStartPosition.column;
                int twosideEndOffset = twosideDocument.getLineStartOffset(twosideEndLine) + onesideEndPosition.column;
                twosideDocument.replaceString(twosideStartOffset, twosideEndOffset, e.getNewFragment());
                for (UnifiedDiffChange change : UnifiedDiffViewer.this.myChangedBlockData.getDiffChanges()) {
                    change.processChange(line1, line2, shift);
                }
                LineNumberConvertor lineNumberConvertor = UnifiedDiffViewer.this.myChangedBlockData.getLineNumberConvertor();
                lineNumberConvertor.handleOnesideChange(line1, line2, shift, UnifiedDiffViewer.this.myMasterSide);
            }
            finally {
                UnifiedDiffViewer.this.markStateIsOutOfDate();
                UnifiedDiffViewer.this.myFoldingModel.onDocumentChanged(e);
                UnifiedDiffViewer.this.scheduleRediff();
                UnifiedDiffViewer.this.myDuringTwosideDocumentModification = false;
            }
        }

        private void logDebugInfo(DocumentEvent e, LineCol onesideStartPosition, LineCol onesideEndPosition, int twosideStartLine, int twosideEndLine) {
            StringBuilder info = new StringBuilder();
            Document document1 = UnifiedDiffViewer.this.getDocument(Side.LEFT);
            Document document2 = UnifiedDiffViewer.this.getDocument(Side.RIGHT);
            info.append("==== UnifiedDiffViewer Debug Info ====");
            info.append("myMasterSide - ").append(UnifiedDiffViewer.this.myMasterSide).append('\n');
            info.append("myLeftDocument.length() - ").append(document1.getTextLength()).append('\n');
            info.append("myRightDocument.length() - ").append(document2.getTextLength()).append('\n');
            info.append("myDocument.length() - ").append(UnifiedDiffViewer.this.myDocument.getTextLength()).append('\n');
            info.append("e.getOffset() - ").append(e.getOffset()).append('\n');
            info.append("e.getNewLength() - ").append(e.getNewLength()).append('\n');
            info.append("e.getOldLength() - ").append(e.getOldLength()).append('\n');
            info.append("onesideStartPosition - ").append(onesideStartPosition).append('\n');
            info.append("onesideEndPosition - ").append(onesideEndPosition).append('\n');
            info.append("twosideStartLine - ").append(twosideStartLine).append('\n');
            info.append("twosideEndLine - ").append(twosideEndLine).append('\n');
            Pair<int[], Side> pair1 = UnifiedDiffViewer.this.transferLineFromOneside(onesideStartPosition.line);
            Pair<int[], Side> pair2 = UnifiedDiffViewer.this.transferLineFromOneside(onesideEndPosition.line);
            info.append("non-strict transferStartLine - ").append(((int[])pair1.first)[0]).append("-").append(((int[])pair1.first)[1]).append(":").append(pair1.second).append('\n');
            info.append("non-strict transferEndLine - ").append(((int[])pair2.first)[0]).append("-").append(((int[])pair2.first)[1]).append(":").append(pair2.second).append('\n');
            info.append("---- UnifiedDiffViewer Debug Info ----");
            LOG.warn(info.toString());
        }
    }
}

