/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathUtil;
import com.intellij.util.TimeoutUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalDiffToolUtil {
    public static boolean canCreateFile(@NotNull DiffContent content) {
        if (content instanceof EmptyContent) {
            return true;
        }
        if (content instanceof DocumentContent) {
            return true;
        }
        if (content instanceof FileContent) {
            return true;
        }
        if (content instanceof DirectoryContent) {
            return ((DirectoryContent)content).getFile().isInLocalFileSystem();
        }
        return false;
    }

    @NotNull
    private static InputFile createFile(@NotNull DiffContent content, @Nullable String title, @Nullable String windowTitle) throws IOException {
        if (content instanceof EmptyContent) {
            return new TempInputFile(ExternalDiffToolUtil.createFile(new byte[0], "empty"));
        }
        if (content instanceof FileContent) {
            VirtualFile file2 = ((FileContent)content).getFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            if (file2.isInLocalFileSystem()) {
                return new LocalInputFile(file2);
            }
            String tempFileName = ExternalDiffToolUtil.getFileName(title, windowTitle, content.getContentType());
            return new TempInputFile(ExternalDiffToolUtil.createTempFile(file2, tempFileName));
        }
        if (content instanceof DocumentContent) {
            String tempFileName = ExternalDiffToolUtil.getFileName(title, windowTitle, content.getContentType());
            return new TempInputFile(ExternalDiffToolUtil.createTempFile((DocumentContent)content, tempFileName));
        }
        if (content instanceof DirectoryContent) {
            VirtualFile file3 = ((DirectoryContent)content).getFile();
            if (file3.isInLocalFileSystem()) {
                return new LocalInputFile(file3);
            }
            throw new IllegalArgumentException(content.toString());
        }
        throw new IllegalArgumentException(content.toString());
    }

    @NotNull
    private static File createTempFile(final @NotNull DocumentContent content, @NotNull String tempFileName) throws IOException {
        Charset charset;
        FileDocumentManager.getInstance().saveDocument(content.getDocument());
        LineSeparator separator = content.getLineSeparator();
        if (separator == null) {
            separator = LineSeparator.getSystemLineSeparator();
        }
        if ((charset = content.getCharset()) == null) {
            charset = Charset.defaultCharset();
        }
        String contentData = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return content.getDocument().getText();
            }
        });
        if (separator != LineSeparator.LF) {
            contentData = StringUtil.convertLineSeparators((String)contentData, (String)separator.getSeparatorString());
        }
        byte[] bytes = contentData.getBytes(charset);
        return ExternalDiffToolUtil.createFile(bytes, tempFileName);
    }

    @NotNull
    private static File createTempFile(@NotNull VirtualFile file2, @NotNull String tempFileName) throws IOException {
        byte[] bytes = file2.contentsToByteArray();
        return ExternalDiffToolUtil.createFile(bytes, tempFileName);
    }

    @NotNull
    private static OutputFile createOutputFile(@NotNull DiffContent content, @Nullable String windowTitle) throws IOException {
        if (content instanceof FileContent) {
            VirtualFile file2 = ((FileContent)content).getFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            if (file2.isInLocalFileSystem()) {
                return new LocalOutputFile(file2);
            }
            String tempFileName = ExternalDiffToolUtil.getFileName(null, windowTitle, content.getContentType());
            File tempFile2 = ExternalDiffToolUtil.createTempFile(file2, tempFileName);
            return new NonLocalOutputFile(file2, tempFile2);
        }
        if (content instanceof DocumentContent) {
            String tempFileName = ExternalDiffToolUtil.getFileName(null, windowTitle, content.getContentType());
            File tempFile3 = ExternalDiffToolUtil.createTempFile((DocumentContent)content, tempFileName);
            return new DocumentOutputFile(((DocumentContent)content).getDocument(), ((DocumentContent)content).getCharset(), tempFile3);
        }
        throw new IllegalArgumentException(content.toString());
    }

    @NotNull
    private static String getFileName(@Nullable String title, @Nullable String windowTitle, @Nullable FileType fileType) {
        String ext;
        String prefix = "";
        if (title != null && windowTitle != null) {
            prefix = title + "_" + windowTitle;
        } else if (title != null || windowTitle != null) {
            prefix = title != null ? title : windowTitle;
        }
        String string = ext = fileType != null ? fileType.getDefaultExtension() : "tmp";
        if (prefix.length() > 50) {
            prefix = prefix.substring(0, 50);
        }
        return PathUtil.suggestFileName((String)(prefix + "." + ext), (boolean)true, (boolean)false);
    }

    @NotNull
    private static File createFile(@NotNull byte[] bytes, @NotNull String name) throws IOException {
        File tempFile2 = FileUtil.createTempFile((String)"tmp_", (String)("_" + name), (boolean)true);
        FileUtil.writeToFile((File)tempFile2, (byte[])bytes);
        return tempFile2;
    }

    public static void execute(@NotNull ExternalDiffSettings settings, @NotNull List<? extends DiffContent> contents, @NotNull List<String> titles, @Nullable String windowTitle) throws IOException, ExecutionException {
        assert (contents.size() == 2 || contents.size() == 3);
        assert (titles.size() == contents.size());
        ArrayList<InputFile> files = new ArrayList<InputFile>();
        for (int i = 0; i < contents.size(); ++i) {
            files.add(ExternalDiffToolUtil.createFile(contents.get(i), titles.get(i), windowTitle));
        }
        CommandLineTokenizer parameterTokenizer = new CommandLineTokenizer(settings.getDiffParameters(), true);
        ArrayList<String> args = new ArrayList<String>();
        while (parameterTokenizer.hasMoreTokens()) {
            String arg = parameterTokenizer.nextToken();
            if ("%1".equals(arg)) {
                args.add(((InputFile)files.get(0)).getPath());
                continue;
            }
            if ("%2".equals(arg)) {
                if (files.size() == 3) {
                    args.add(((InputFile)files.get(2)).getPath());
                    continue;
                }
                args.add(((InputFile)files.get(1)).getPath());
                continue;
            }
            if ("%3".equals(arg)) {
                if (files.size() != 3) continue;
                args.add(((InputFile)files.get(1)).getPath());
                continue;
            }
            args.add(arg);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(settings.getDiffExePath());
        commandLine.addParameters(args);
        commandLine.createProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeMerge(@Nullable Project project2, @NotNull ExternalDiffSettings settings, @NotNull ThreesideMergeRequest request) throws IOException, ExecutionException {
        boolean success = false;
        InputFile outputFile = null;
        ArrayList<InputFile> inputFiles = new ArrayList<InputFile>();
        try {
            DiffContent outputContent = request.getOutputContent();
            List contents = request.getContents();
            List titles = request.getContentTitles();
            String windowTitle = request.getTitle();
            assert (contents.size() == 3);
            assert (titles.size() == contents.size());
            for (int i = 0; i < contents.size(); ++i) {
                inputFiles.add(ExternalDiffToolUtil.createFile((DiffContent)contents.get(i), (String)titles.get(i), windowTitle));
            }
            outputFile = ExternalDiffToolUtil.createOutputFile(outputContent, windowTitle);
            CommandLineTokenizer parameterTokenizer = new CommandLineTokenizer(settings.getMergeParameters(), true);
            ArrayList<String> args = new ArrayList<String>();
            while (parameterTokenizer.hasMoreTokens()) {
                String arg = parameterTokenizer.nextToken();
                if ("%1".equals(arg)) {
                    args.add(((InputFile)inputFiles.get(0)).getPath());
                    continue;
                }
                if ("%2".equals(arg)) {
                    args.add(((InputFile)inputFiles.get(2)).getPath());
                    continue;
                }
                if ("%3".equals(arg)) {
                    args.add(((InputFile)inputFiles.get(1)).getPath());
                    continue;
                }
                if ("%4".equals(arg)) {
                    args.add(outputFile.getPath());
                    continue;
                }
                args.add(arg);
            }
            GeneralCommandLine commandLine = new GeneralCommandLine();
            commandLine.setExePath(settings.getMergeExePath());
            commandLine.addParameters(args);
            final Process process = commandLine.createProcess();
            if (settings.isMergeTrustExitCode()) {
                final Ref resultRef = new Ref();
                ProgressManager.getInstance().run((Task)new Task.Modal(project2, "Waiting for external tool", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(@NotNull ProgressIndicator indicator) {
                        final Semaphore semaphore = new Semaphore(0);
                        Thread waiter = new Thread("external process waiter"){

                            @Override
                            public void run() {
                                try {
                                    resultRef.set((Object)(process.waitFor() == 0 ? 1 : 0));
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                finally {
                                    semaphore.release();
                                }
                            }
                        };
                        waiter.start();
                        try {
                            do {
                                indicator.checkCanceled();
                            } while (!semaphore.tryAcquire(200L, TimeUnit.MILLISECONDS));
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            waiter.interrupt();
                        }
                    }
                });
                success = resultRef.get() == Boolean.TRUE;
            } else {
                ProgressManager.getInstance().run((Task)new Task.Modal(project2, "Launching external tool", false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        indicator.setIndeterminate(true);
                        TimeoutUtil.sleep((long)1000L);
                    }
                });
                boolean bl = success = Messages.showYesNoDialog((Project)project2, (String)"Press \"Mark as Resolved\" when you finish resolving conflicts in the external tool", (String)"Merge In External Tool", (String)"Mark as Resolved", (String)"Revert", null) == 0;
            }
            if (success) {
                outputFile.apply();
            }
            request.applyResult(success ? MergeResult.RESOLVED : MergeResult.CANCEL);
        }
        catch (Throwable throwable) {
            request.applyResult(success ? MergeResult.RESOLVED : MergeResult.CANCEL);
            if (outputFile != null) {
                outputFile.cleanup();
            }
            for (InputFile file2 : inputFiles) {
                file2.cleanup();
            }
            throw throwable;
        }
        if (outputFile != null) {
            outputFile.cleanup();
        }
        for (InputFile file3 : inputFiles) {
            file3.cleanup();
        }
    }

    private static class TempInputFile
    implements InputFile {
        @NotNull
        protected final File myLocalFile;

        public TempInputFile(@NotNull File localFile) {
            this.myLocalFile = localFile;
        }

        @Override
        @NotNull
        public String getPath() {
            return this.myLocalFile.getPath();
        }

        @Override
        public void cleanup() {
            this.myLocalFile.delete();
        }
    }

    private static class LocalInputFile
    implements InputFile {
        @NotNull
        protected final VirtualFile myFile;

        public LocalInputFile(@NotNull VirtualFile file2) {
            this.myFile = file2;
        }

        @Override
        @NotNull
        public String getPath() {
            return this.myFile.getPath();
        }

        @Override
        public void cleanup() {
        }
    }

    private static class DocumentOutputFile
    extends TempInputFile
    implements OutputFile {
        @NotNull
        private final Document myDocument;
        @NotNull
        private final Charset myCharset;

        public DocumentOutputFile(@NotNull Document document, @Nullable Charset charset, @NotNull File localFile) {
            super(localFile);
            this.myDocument = document;
            this.myCharset = charset != null ? charset : Charset.defaultCharset();
        }

        @Override
        public void apply() throws IOException {
            final String content = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)this.myLocalFile, (Charset)this.myCharset));
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    myDocument.setText((CharSequence)content);
                }
            });
        }
    }

    private static class NonLocalOutputFile
    extends TempInputFile
    implements OutputFile {
        @NotNull
        private final VirtualFile myFile;

        public NonLocalOutputFile(@NotNull VirtualFile file2, @NotNull File localFile) {
            super(localFile);
            this.myFile = file2;
        }

        @Override
        public void apply() throws IOException {
            this.myFile.setBinaryContent(FileUtil.loadFileBytes((File)this.myLocalFile));
        }
    }

    private static class LocalOutputFile
    extends LocalInputFile
    implements OutputFile {
        public LocalOutputFile(@NotNull VirtualFile file2) {
            super(file2);
        }

        @Override
        public void apply() {
            this.myFile.refresh(false, false);
        }
    }

    private static interface OutputFile
    extends InputFile {
        public void apply() throws IOException;
    }

    private static interface InputFile {
        @NotNull
        public String getPath();

        public void cleanup();
    }
}

