/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.binary;

import com.intellij.diff.DiffContext;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.BinaryEditorHolder;
import com.intellij.diff.tools.util.TransferableFileEditorStateSupport;
import com.intellij.diff.tools.util.side.ThreesideDiffViewer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.EmptyRunnable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ThreesideBinaryDiffViewer
extends ThreesideDiffViewer<BinaryEditorHolder> {
    private final TransferableFileEditorStateSupport myTransferableStateSupport;

    public ThreesideBinaryDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        super(context, (ContentDiffRequest)request, BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE);
        this.myTransferableStateSupport = new TransferableFileEditorStateSupport(DiffUtil.getDiffSettings(context), this.getEditorHolders(), (Disposable)this);
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myTransferableStateSupport.processContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myTransferableStateSupport.updateContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @Override
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add(this.myTransferableStateSupport.createToggleAction());
        group.addAll(super.createToolbarActions());
        return group;
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        return EmptyRunnable.INSTANCE;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        return ThreesideDiffViewer.canShowRequest(context, request, BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE);
    }
}

