/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.binary;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.binary.OnesideBinaryDiffViewer;
import com.intellij.diff.tools.binary.ThreesideBinaryDiffViewer;
import com.intellij.diff.tools.binary.TwosideBinaryDiffViewer;
import org.jetbrains.annotations.NotNull;

public class BinaryDiffTool
implements FrameDiffTool {
    public static final BinaryDiffTool INSTANCE = new BinaryDiffTool();

    @NotNull
    public FrameDiffTool.DiffViewer createComponent(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (OnesideBinaryDiffViewer.canShowRequest(context, request)) {
            return new OnesideBinaryDiffViewer(context, request);
        }
        if (TwosideBinaryDiffViewer.canShowRequest(context, request)) {
            return new TwosideBinaryDiffViewer(context, request);
        }
        if (ThreesideBinaryDiffViewer.canShowRequest(context, request)) {
            return new ThreesideBinaryDiffViewer(context, request);
        }
        throw new IllegalArgumentException(request.toString());
    }

    public boolean canShow(@NotNull DiffContext context, @NotNull DiffRequest request) {
        return OnesideBinaryDiffViewer.canShowRequest(context, request) || TwosideBinaryDiffViewer.canShowRequest(context, request) || ThreesideBinaryDiffViewer.canShowRequest(context, request);
    }

    @NotNull
    public String getName() {
        return "Binary file viewer";
    }
}

