/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.requests.ComponentDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownFileTypeDiffRequest
extends ComponentDiffRequest {
    @Nullable
    private final String myFileName;
    @Nullable
    private final String myTitle;

    public UnknownFileTypeDiffRequest(@NotNull VirtualFile file2, @Nullable String title) {
        this(file2.getName(), title);
    }

    public UnknownFileTypeDiffRequest(@NotNull String fileName, @Nullable String title) {
        boolean knownFileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName) != UnknownFileType.INSTANCE;
        this.myFileName = knownFileType ? null : fileName;
        this.myTitle = title;
    }

    @NotNull
    public JComponent getComponent(final @NotNull DiffContext context) {
        SimpleColoredComponent label = new SimpleColoredComponent();
        label.setTextAlign(0);
        label.append("Can't show diff for unknown file type. ", new SimpleTextAttributes(0, UIUtil.getInactiveTextColor()));
        if (this.myFileName != null) {
            label.append("Associate", SimpleTextAttributes.LINK_ATTRIBUTES, (Object)new Runnable(){

                @Override
                public void run() {
                    DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            FileType type = FileTypeChooser.associateFileType(UnknownFileTypeDiffRequest.this.myFileName);
                            if (type != null) {
                                UnknownFileTypeDiffRequest.this.onSuccess(context);
                            }
                        }
                    });
                }
            });
            LinkMouseListenerBase.installSingleTagOn(label);
        }
        return new DiffUtil.CenteredPanel((JComponent)label, JBUI.Borders.empty((int)5));
    }

    @Nullable
    public String getFileName() {
        return this.myFileName;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    protected void onSuccess(@NotNull DiffContext context) {
        if (context instanceof DiffContextEx) {
            ((DiffContextEx)context).reloadDiffRequest();
        }
    }
}

