/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextMergeRequestImpl
extends TextMergeRequest {
    @Nullable
    private final Project myProject;
    @NotNull
    private final DocumentContent myOutput;
    @NotNull
    private final List<DocumentContent> myContents;
    @NotNull
    private final CharSequence myOriginalContent;
    @Nullable
    private final String myTitle;
    @NotNull
    private final List<String> myTitles;
    @Nullable
    private final Consumer<MergeResult> myApplyCallback;

    public TextMergeRequestImpl(@Nullable Project project2, @NotNull DocumentContent output, @NotNull CharSequence originalContent, @NotNull List<DocumentContent> contents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<MergeResult> applyCallback) {
        assert (contents.size() == 3);
        assert (contentTitles.size() == 3);
        this.myProject = project2;
        this.myOutput = output;
        this.myOriginalContent = originalContent;
        this.myContents = contents;
        this.myTitles = contentTitles;
        this.myTitle = title;
        this.myApplyCallback = applyCallback;
    }

    @NotNull
    public DocumentContent getOutputContent() {
        return this.myOutput;
    }

    @NotNull
    public List<DocumentContent> getContents() {
        return this.myContents;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public List<String> getContentTitles() {
        return this.myTitles;
    }

    public void applyResult(@NotNull MergeResult result) {
        CharSequence applyContent;
        switch (result) {
            case CANCEL: {
                applyContent = this.myOriginalContent;
                break;
            }
            case LEFT: {
                CharSequence leftContent = ((DocumentContent)ThreeSide.LEFT.select(this.getContents())).getDocument().getImmutableCharSequence();
                applyContent = StringUtil.convertLineSeparators((String)leftContent.toString());
                break;
            }
            case RIGHT: {
                CharSequence rightContent = ((DocumentContent)ThreeSide.RIGHT.select(this.getContents())).getDocument().getImmutableCharSequence();
                applyContent = StringUtil.convertLineSeparators((String)rightContent.toString());
                break;
            }
            case RESOLVED: {
                applyContent = null;
                break;
            }
            default: {
                throw new IllegalArgumentException(result.toString());
            }
        }
        if (applyContent != null) {
            DiffUtil.executeWriteCommand(this.myOutput.getDocument(), this.myProject, null, new Runnable(){

                @Override
                public void run() {
                    TextMergeRequestImpl.this.myOutput.getDocument().setText(applyContent);
                }
            });
        }
        if (this.myApplyCallback != null) {
            this.myApplyCallback.consume((Object)result);
        }
    }
}

