/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeRequestProcessor;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeWindow {
    @Nullable
    private final Project myProject;
    @NotNull
    private final MergeRequest myMergeRequest;
    private MyDialog myWrapper;

    public MergeWindow(@Nullable Project project2, @NotNull MergeRequest mergeRequest) {
        this.myProject = project2;
        this.myMergeRequest = mergeRequest;
    }

    protected void init() {
        MergeRequestProcessor processor2 = new MergeRequestProcessor(this.myProject, this.myMergeRequest){

            @Override
            public void closeDialog() {
                MergeWindow.this.myWrapper.doCancelAction();
            }

            @Override
            protected void setWindowTitle(@NotNull String title) {
                MergeWindow.this.myWrapper.setTitle(title);
            }

            @Override
            protected void rebuildSouthPanel() {
                MergeWindow.this.myWrapper.rebuildSouthPanel();
            }
        };
        this.myWrapper = new MyDialog(processor2);
        this.myWrapper.init();
    }

    public void show() {
        this.init();
        this.myWrapper.show();
    }

    private static class MyPanel
    extends JPanel {
        public MyPanel(@NotNull JComponent content) {
            super(new BorderLayout());
            this.add((Component)content, "Center");
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension windowSize = DiffUtil.getDefaultDiffWindowSize();
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(windowSize.width, size.width), Math.max(windowSize.height, size.height));
        }
    }

    private static class MyDialog
    extends DialogWrapper {
        @NotNull
        private final MergeRequestProcessor myProcessor;
        @NotNull
        private final Wrapper mySouthPanel = new Wrapper();

        public MyDialog(@NotNull MergeRequestProcessor processor2) {
            super(processor2.getProject(), true);
            this.myProcessor = processor2;
        }

        public void init() {
            super.init();
            Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myProcessor);
            this.getWindow().addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    myProcessor.init();
                }
            });
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return new MyPanel(this.myProcessor.getComponent());
        }

        @Nullable
        protected JComponent createSouthPanel() {
            this.rebuildSouthPanel();
            return this.mySouthPanel;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myProcessor.getPreferredFocusedComponent();
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return StringUtil.notNullize((String)((String)this.myProcessor.getContextUserData(DiffUserDataKeys.DIALOG_GROUP_KEY)), (String)"MergeDialog");
        }

        @NotNull
        protected Action[] createActions() {
            MergeRequestProcessor.BottomActions bottomActions = this.myProcessor.getBottomActions();
            List actions = ContainerUtil.skipNulls((Collection)ContainerUtil.list((Object[])new Action[]{bottomActions.resolveAction, bottomActions.cancelAction}));
            if (bottomActions.resolveAction != null) {
                bottomActions.resolveAction.putValue("DefaultAction", true);
            }
            return actions.toArray(new Action[actions.size()]);
        }

        @NotNull
        protected Action[] createLeftSideActions() {
            MergeRequestProcessor.BottomActions bottomActions = this.myProcessor.getBottomActions();
            List actions = ContainerUtil.skipNulls((Collection)ContainerUtil.list((Object[])new Action[]{bottomActions.applyLeft, bottomActions.applyRight}));
            return actions.toArray(new Action[actions.size()]);
        }

        @NotNull
        protected Action getOKAction() {
            MergeRequestProcessor.BottomActions bottomActions = this.myProcessor.getBottomActions();
            if (bottomActions.resolveAction != null) {
                return bottomActions.resolveAction;
            }
            return super.getOKAction();
        }

        @NotNull
        protected Action getCancelAction() {
            MergeRequestProcessor.BottomActions bottomActions = this.myProcessor.getBottomActions();
            if (bottomActions.cancelAction != null) {
                return bottomActions.cancelAction;
            }
            return super.getCancelAction();
        }

        @Nullable
        protected String getHelpId() {
            return this.myProcessor.getHelpId();
        }

        public void doCancelAction() {
            if (!this.myProcessor.checkCloseAction()) {
                return;
            }
            super.doCancelAction();
        }

        public void rebuildSouthPanel() {
            this.mySouthPanel.setContent(super.createSouthPanel());
        }
    }
}

