/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.binary.ThreesideBinaryDiffViewer;
import com.intellij.diff.tools.holders.BinaryEditorHolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryMergeTool
implements MergeTool {
    public static final BinaryMergeTool INSTANCE = new BinaryMergeTool();

    @NotNull
    public MergeTool.MergeViewer createComponent(@NotNull MergeContext context, @NotNull MergeRequest request) {
        return new BinaryMergeViewer(context, (ThreesideMergeRequest)request);
    }

    public boolean canShow(@NotNull MergeContext context, @NotNull MergeRequest request) {
        if (!(request instanceof ThreesideMergeRequest)) {
            return false;
        }
        MergeUtil.ProxyDiffContext diffContext = new MergeUtil.ProxyDiffContext(context);
        for (DiffContent diffContent : ((ThreesideMergeRequest)request).getContents()) {
            if (BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE.canShowContent(diffContent, diffContext)) continue;
            return false;
        }
        return true;
    }

    public static class BinaryMergeViewer
    implements MergeTool.MergeViewer {
        @NotNull
        private final MergeContext myMergeContext;
        @NotNull
        private final ThreesideMergeRequest myMergeRequest;
        @NotNull
        private final DiffContext myDiffContext;
        @NotNull
        private final ContentDiffRequest myDiffRequest;
        @NotNull
        private final MyThreesideViewer myViewer;

        public BinaryMergeViewer(@NotNull MergeContext context, @NotNull ThreesideMergeRequest request) {
            this.myMergeContext = context;
            this.myMergeRequest = request;
            this.myDiffContext = new MergeUtil.ProxyDiffContext(this.myMergeContext);
            this.myDiffRequest = new SimpleDiffRequest(this.myMergeRequest.getTitle(), BinaryMergeViewer.getDiffContents(this.myMergeRequest), BinaryMergeViewer.getDiffContentTitles(this.myMergeRequest));
            this.myViewer = new MyThreesideViewer(this.myDiffContext, (DiffRequest)this.myDiffRequest);
        }

        @NotNull
        private static List<DiffContent> getDiffContents(@NotNull ThreesideMergeRequest mergeRequest) {
            return ContainerUtil.newArrayList((Iterable)mergeRequest.getContents());
        }

        @NotNull
        private static List<String> getDiffContentTitles(@NotNull ThreesideMergeRequest mergeRequest) {
            return MergeUtil.notNullizeContentTitles(mergeRequest.getContentTitles());
        }

        @NotNull
        public JComponent getComponent() {
            return this.myViewer.getComponent();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myViewer.getPreferredFocusedComponent();
        }

        @NotNull
        public MergeTool.ToolbarComponents init() {
            MergeTool.ToolbarComponents components = new MergeTool.ToolbarComponents();
            FrameDiffTool.ToolbarComponents init = this.myViewer.init();
            components.statusPanel = init.statusPanel;
            components.toolbarActions = init.toolbarActions;
            components.closeHandler = new BooleanGetter(){

                public boolean get() {
                    return MergeUtil.showExitWithoutApplyingChangesDialog(this, (MergeRequest)myMergeRequest, myMergeContext);
                }
            };
            return components;
        }

        @Nullable
        public Action getResolveAction(final @NotNull MergeResult result) {
            if (result == MergeResult.RESOLVED) {
                return null;
            }
            String caption = MergeUtil.getResolveActionTitle(result, (MergeRequest)this.myMergeRequest, this.myMergeContext);
            return new AbstractAction(caption){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (result == MergeResult.CANCEL && !MergeUtil.showExitWithoutApplyingChangesDialog(this, (MergeRequest)myMergeRequest, myMergeContext)) {
                        return;
                    }
                    myMergeContext.finishMerge(result);
                }
            };
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myViewer);
        }

        @NotNull
        public MyThreesideViewer getViewer() {
            return this.myViewer;
        }

        private static class MyThreesideViewer
        extends ThreesideBinaryDiffViewer {
            public MyThreesideViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
                super(context, request);
            }

            @Override
            public void rediff(boolean trySync) {
            }
        }
    }
}

