/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="DiffSettings", storages={@Storage(value="diff.xml")})
public class DiffSettingsHolder
implements PersistentStateComponent<State> {
    public static final Key<DiffSettings> KEY = Key.create((String)"DiffSettings");
    private State myState = new State();

    @NotNull
    public DiffSettings getSettings(@Nullable String place) {
        PlaceSettings placeSettings;
        if (place == null) {
            place = "Default";
        }
        if ((placeSettings = this.myState.PLACES_MAP.get(place)) == null) {
            placeSettings = new PlaceSettings();
            this.myState.PLACES_MAP.put(place, placeSettings);
        }
        return new DiffSettings(this.myState.SHARED_SETTINGS, placeSettings);
    }

    @NotNull
    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public static DiffSettingsHolder getInstance() {
        return (DiffSettingsHolder)ServiceManager.getService(DiffSettingsHolder.class);
    }

    public static class State {
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false)
        public Map<String, PlaceSettings> PLACES_MAP = new HashMap();
        public SharedSettings SHARED_SETTINGS = new SharedSettings();
    }

    public static class DiffSettings {
        @NotNull
        public SharedSettings SHARED_SETTINGS = new SharedSettings();
        @NotNull
        public PlaceSettings PLACE_SETTINGS = new PlaceSettings();

        public DiffSettings() {
        }

        public DiffSettings(@NotNull SharedSettings SHARED_SETTINGS, @NotNull PlaceSettings PLACE_SETTINGS) {
            this.SHARED_SETTINGS = SHARED_SETTINGS;
            this.PLACE_SETTINGS = PLACE_SETTINGS;
        }

        @NotNull
        public List<String> getDiffToolsOrder() {
            return this.PLACE_SETTINGS.DIFF_TOOLS_ORDER;
        }

        public void setDiffToolsOrder(@NotNull List<String> order) {
            this.PLACE_SETTINGS.DIFF_TOOLS_ORDER = order;
        }

        public boolean isGoToNextFileOnNextDifference() {
            return this.SHARED_SETTINGS.GO_TO_NEXT_FILE_ON_NEXT_DIFFERENCE;
        }

        public void setGoToNextFileOnNextDifference(boolean value) {
            this.SHARED_SETTINGS.GO_TO_NEXT_FILE_ON_NEXT_DIFFERENCE = value;
        }

        public boolean isSyncBinaryEditorSettings() {
            return this.PLACE_SETTINGS.SYNC_BINARY_EDITOR_SETTINGS;
        }

        public void setSyncBinaryEditorSettings(boolean value) {
            this.PLACE_SETTINGS.SYNC_BINARY_EDITOR_SETTINGS = value;
        }

        @NotNull
        public static DiffSettings getSettings() {
            return DiffSettings.getSettings(null);
        }

        @NotNull
        public static DiffSettings getSettings(@Nullable String place) {
            return DiffSettingsHolder.getInstance().getSettings(place);
        }
    }

    private static class PlaceSettings {
        @NotNull
        public List<String> DIFF_TOOLS_ORDER = new ArrayList<String>();
        public boolean SYNC_BINARY_EDITOR_SETTINGS = true;

        private PlaceSettings() {
        }
    }

    private static class SharedSettings {
        public boolean GO_TO_NEXT_FILE_ON_NEXT_DIFFERENCE = true;

        private SharedSettings() {
        }
    }
}

