/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.Convertor;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleContentBuilder {
    @NotNull
    private final String myText;
    @Nullable
    private FileType myFileType;
    @Nullable
    private VirtualFile myHighlightFile;
    @Nullable
    private LineSeparator mySeparator;
    @Nullable
    private Charset myCharset;
    @Nullable
    private Convertor<Integer, OpenFileDescriptor> myOpenFileDescriptor;
    private boolean myReadOnly;

    public SimpleContentBuilder(@NotNull String text) {
        this.myText = text;
    }

    @NotNull
    public SimpleContentBuilder setFileType(@Nullable FileType type) {
        this.myFileType = type;
        return this;
    }

    @NotNull
    public SimpleContentBuilder setHighlightFile(@Nullable VirtualFile highlightFile) {
        this.myHighlightFile = highlightFile;
        return this;
    }

    @NotNull
    public SimpleContentBuilder setSeparator(@Nullable LineSeparator separator) {
        this.mySeparator = separator;
        return this;
    }

    @NotNull
    public SimpleContentBuilder setCharset(@Nullable Charset charset) {
        this.myCharset = charset;
        return this;
    }

    @NotNull
    public SimpleContentBuilder setOpenFileDescriptor(@Nullable Convertor<Integer, OpenFileDescriptor> openFileDescriptor) {
        this.myOpenFileDescriptor = openFileDescriptor;
        return this;
    }

    @NotNull
    public SimpleContentBuilder setReadOnly(boolean readOnly) {
        this.myReadOnly = readOnly;
        return this;
    }

    @NotNull
    public DocumentContent build() {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)this.myText);
        if (this.myReadOnly) {
            document.setReadOnly(true);
        }
        return new DocumentContentImpl(document, this.myFileType, this.myHighlightFile, this.mySeparator, this.myCharset){

            @Override
            @Nullable
            public OpenFileDescriptor getOpenFileDescriptor(int offset) {
                if (SimpleContentBuilder.this.myOpenFileDescriptor == null) {
                    return null;
                }
                return (OpenFileDescriptor)SimpleContentBuilder.this.myOpenFileDescriptor.convert((Object)offset);
            }
        };
    }
}

