/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.contents.FileContent;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContentImpl
extends DiffContentBase
implements FileContent {
    @NotNull
    private final VirtualFile myFile;
    @Nullable
    private final Project myProject;
    @NotNull
    private final FileType myType;

    public FileContentImpl(@Nullable Project project2, @NotNull VirtualFile file2) {
        assert (file2.isValid() && !file2.isDirectory());
        this.myProject = project2;
        this.myFile = file2;
        this.myType = file2.getFileType();
    }

    @Nullable
    public OpenFileDescriptor getOpenFileDescriptor() {
        if (this.myProject == null || this.myProject.isDefault() || !this.myFile.isValid()) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, this.myFile);
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public FileType getContentType() {
        return this.myType;
    }

    @NotNull
    public String getFilePath() {
        return this.myFile.getPath();
    }
}

