/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LightColors;
import com.intellij.util.LineSeparator;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileAwareDocumentContent
extends DocumentContentImpl {
    @Nullable
    private final Project myProject;

    public FileAwareDocumentContent(@Nullable Project project2, @NotNull Document document, @Nullable FileType fileType, @Nullable VirtualFile highlightFile, @Nullable LineSeparator separator, @Nullable Charset charset) {
        super(document, fileType, highlightFile, separator, charset);
        this.myProject = project2;
    }

    @Override
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        if (this.myProject == null || this.getHighlightFile() == null || !this.getHighlightFile().isValid()) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, this.getHighlightFile(), offset);
    }

    @NotNull
    public static FileAwareDocumentContent create(@Nullable Project project2, @NotNull String content, @NotNull FilePath path) {
        return new Builder(project2).init(path).create(content).build();
    }

    @NotNull
    public static FileAwareDocumentContent create(@Nullable Project project2, @NotNull String content, @NotNull VirtualFile highlightFile) {
        return new Builder(project2).init(highlightFile).create(content).build();
    }

    @NotNull
    public static FileAwareDocumentContent create(@Nullable Project project2, @NotNull byte[] content, @NotNull FilePath path) {
        return new Builder(project2).init(path).create(content).build();
    }

    @NotNull
    public static FileAwareDocumentContent create(@Nullable Project project2, @NotNull byte[] content, @NotNull VirtualFile highlightFile) {
        return new Builder(project2).init(highlightFile).create(content).build();
    }

    private static class Builder {
        private final Project myProject;
        private Document myDocument;
        private FileType myFileType;
        private VirtualFile myHighlightFile;
        private LineSeparator mySeparator;
        private Charset myCharset;
        private Charset mySuggestedCharset;
        private boolean myMalformedContent;

        public Builder(@Nullable Project project2) {
            this.myProject = project2;
        }

        @NotNull
        private Builder init(@NotNull FilePath path) {
            this.myHighlightFile = path.getVirtualFile();
            this.myFileType = path.getFileType();
            this.mySuggestedCharset = path.getCharset(this.myProject);
            return this;
        }

        @NotNull
        private Builder init(@NotNull VirtualFile highlightFile) {
            this.myHighlightFile = highlightFile;
            this.myFileType = highlightFile.getFileType();
            this.mySuggestedCharset = highlightFile.getCharset();
            return this;
        }

        @NotNull
        private Builder create(@NotNull String content) {
            this.mySeparator = StringUtil.detectSeparators((CharSequence)content);
            this.myDocument = EditorFactory.getInstance().createDocument((CharSequence)StringUtil.convertLineSeparators((String)content));
            this.myDocument.setReadOnly(true);
            return this;
        }

        @NotNull
        private Builder create(@NotNull byte[] content) {
            assert (this.mySuggestedCharset != null);
            this.myCharset = this.mySuggestedCharset;
            try {
                String text = CharsetToolkit.tryDecodeString((byte[])content, (Charset)this.mySuggestedCharset);
                return this.create(text);
            }
            catch (CharacterCodingException e) {
                String text = CharsetToolkit.decodeString((byte[])content, (Charset)this.mySuggestedCharset);
                this.myMalformedContent = true;
                return this.create(text);
            }
        }

        @Nullable
        private List<JComponent> createNotifications() {
            if (!this.myMalformedContent) {
                return null;
            }
            assert (this.mySuggestedCharset != null);
            String text = "Content was decoded with errors (using '" + this.mySuggestedCharset.name() + "' charset)";
            JPanel notification = DiffNotifications.createNotification(text, LightColors.RED);
            return Collections.singletonList(notification);
        }

        @NotNull
        public FileAwareDocumentContent build() {
            if (FileTypes.UNKNOWN.equals(this.myFileType)) {
                this.myFileType = PlainTextFileType.INSTANCE;
            }
            FileAwareDocumentContent content = new FileAwareDocumentContent(this.myProject, this.myDocument, this.myFileType, this.myHighlightFile, this.mySeparator, this.myCharset);
            content.putUserData(DiffUserDataKeys.NOTIFICATIONS, this.createNotifications());
            return content;
        }
    }
}

