/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.comparison.iterables.ChangeDiffIterableBase;
import com.intellij.diff.util.Range;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class RangesDiffIterable
extends ChangeDiffIterableBase {
    @NotNull
    private final List<? extends Range> myRanges;

    public RangesDiffIterable(@NotNull List<? extends Range> ranges, int length1, int length2) {
        super(length1, length2);
        this.myRanges = ranges;
    }

    @Override
    @NotNull
    protected ChangeDiffIterableBase.ChangeIterable createChangeIterable() {
        return new RangesChangeIterable();
    }

    private class RangesChangeIterable
    implements ChangeDiffIterableBase.ChangeIterable {
        private int myIndex = 0;

        private RangesChangeIterable() {
        }

        @Override
        public boolean valid() {
            return this.myIndex != RangesDiffIterable.this.myRanges.size();
        }

        @Override
        public void next() {
            ++this.myIndex;
        }

        @Override
        public int getStart1() {
            return ((Range)((RangesDiffIterable)RangesDiffIterable.this).myRanges.get((int)this.myIndex)).start1;
        }

        @Override
        public int getStart2() {
            return ((Range)((RangesDiffIterable)RangesDiffIterable.this).myRanges.get((int)this.myIndex)).start2;
        }

        @Override
        public int getEnd1() {
            return ((Range)((RangesDiffIterable)RangesDiffIterable.this).myRanges.get((int)this.myIndex)).end1;
        }

        @Override
        public int getEnd2() {
            return ((Range)((RangesDiffIterable)RangesDiffIterable.this).myRanges.get((int)this.myIndex)).end2;
        }
    }
}

