/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.util.IntPair;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TrimUtil {
    public static boolean isPunctuation(char c) {
        if (c == '_') {
            return false;
        }
        boolean isPunctuation = false;
        isPunctuation |= c >= '!' & c <= '/';
        isPunctuation |= c >= ':' & c <= '@';
        isPunctuation |= c >= '[' & c <= '`';
        return isPunctuation |= c >= '{' & c <= '~';
    }

    public static boolean isAlpha(char c) {
        return !StringUtil.isWhiteSpace((char)c) && !TrimUtil.isPunctuation(c);
    }

    @NotNull
    public static Range trim(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        start1 = TrimUtil.trimStart(text1, start1, end1);
        end1 = TrimUtil.trimEnd(text1, start1, end1);
        start2 = TrimUtil.trimStart(text2, start2, end2);
        end2 = TrimUtil.trimEnd(text2, start2, end2);
        return new Range(start1, end1, start2, end2);
    }

    @NotNull
    public static MergeRange trim(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, int start1, int start2, int start3, int end1, int end2, int end3) {
        start1 = TrimUtil.trimStart(text1, start1, end1);
        end1 = TrimUtil.trimEnd(text1, start1, end1);
        start2 = TrimUtil.trimStart(text2, start2, end2);
        end2 = TrimUtil.trimEnd(text2, start2, end2);
        start3 = TrimUtil.trimStart(text3, start3, end3);
        end3 = TrimUtil.trimEnd(text3, start3, end3);
        return new MergeRange(start1, end1, start2, end2, start3, end3);
    }

    @NotNull
    public static IntPair trim(@NotNull CharSequence text, int start, int end) {
        start = TrimUtil.trimStart(text, start, end);
        end = TrimUtil.trimEnd(text, start, end);
        return new IntPair(start, end);
    }

    public static int trimStart(@NotNull CharSequence text, int start, int end) {
        char c;
        while (start < end && StringUtil.isWhiteSpace((char)(c = text.charAt(start)))) {
            ++start;
        }
        return start;
    }

    public static int trimEnd(@NotNull CharSequence text, int start, int end) {
        char c;
        while (start < end && StringUtil.isWhiteSpace((char)(c = text.charAt(end - 1)))) {
            --end;
        }
        return end;
    }

    @NotNull
    public static Range expand(@NotNull List<?> text1, @NotNull List<?> text2, int start1, int start2, int end1, int end2) {
        int count1 = TrimUtil.expandForward(text1, text2, start1, start2, end1, end2);
        int count2 = TrimUtil.expandBackward(text1, text2, start1 += count1, start2 += count1, end1, end2);
        return new Range(start1, end1 -= count2, start2, end2 -= count2);
    }

    @NotNull
    public static Range expand(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        int count1 = TrimUtil.expandForward(text1, text2, start1, start2, end1, end2);
        int count2 = TrimUtil.expandBackward(text1, text2, start1 += count1, start2 += count1, end1, end2);
        return new Range(start1, end1 -= count2, start2, end2 -= count2);
    }

    @NotNull
    public static Range expandW(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        int count1 = TrimUtil.expandForwardW(text1, text2, start1, start2, end1, end2);
        int count2 = TrimUtil.expandBackwardW(text1, text2, start1 += count1, start2 += count1, end1, end2);
        return new Range(start1, end1 -= count2, start2, end2 -= count2);
    }

    public static int expandForward(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        char c2;
        char c1;
        int oldStart1 = start1;
        while (start1 < end1 && start2 < end2 && (c1 = text1.charAt(start1)) == (c2 = text2.charAt(start2))) {
            ++start1;
            ++start2;
        }
        return start1 - oldStart1;
    }

    public static int expandForward(@NotNull List<?> text1, @NotNull List<?> text2, int start1, int start2, int end1, int end2) {
        Object c2;
        Object c1;
        int oldStart1 = start1;
        while (start1 < end1 && start2 < end2 && (c1 = text1.get(start1)).equals(c2 = text2.get(start2))) {
            ++start1;
            ++start2;
        }
        return start1 - oldStart1;
    }

    public static int expandForwardW(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        char c2;
        char c1;
        int oldStart1 = start1;
        while (start1 < end1 && start2 < end2 && (c1 = text1.charAt(start1)) == (c2 = text2.charAt(start2)) && StringUtil.isWhiteSpace((char)c1)) {
            ++start1;
            ++start2;
        }
        return start1 - oldStart1;
    }

    public static int expandBackward(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        char c2;
        char c1;
        int oldEnd1 = end1;
        while (start1 < end1 && start2 < end2 && (c1 = text1.charAt(end1 - 1)) == (c2 = text2.charAt(end2 - 1))) {
            --end1;
            --end2;
        }
        return oldEnd1 - end1;
    }

    public static int expandBackward(@NotNull List<?> text1, @NotNull List<?> text2, int start1, int start2, int end1, int end2) {
        Object c2;
        Object c1;
        int oldEnd1 = end1;
        while (start1 < end1 && start2 < end2 && (c1 = text1.get(end1 - 1)).equals(c2 = text2.get(end2 - 1))) {
            --end1;
            --end2;
        }
        return oldEnd1 - end1;
    }

    public static int expandBackwardW(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        char c2;
        char c1;
        int oldEnd1 = end1;
        while (start1 < end1 && start2 < end2 && (c1 = text1.charAt(end1 - 1)) == (c2 = text2.charAt(end2 - 1)) && StringUtil.isWhiteSpace((char)c1)) {
            --end1;
            --end2;
        }
        return oldEnd1 - end1;
    }

    public static int expandForwardW(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, int start1, int start2, int start3, int end1, int end2, int end3) {
        int oldStart1 = start1;
        while (start1 < end1 && start2 < end2 && start3 < end3) {
            char c1 = text1.charAt(start1);
            char c2 = text2.charAt(start2);
            char c3 = text3.charAt(start3);
            if (c1 != c2 || c1 != c3 || !StringUtil.isWhiteSpace((char)c1)) break;
            ++start1;
            ++start2;
            ++start3;
        }
        return start1 - oldStart1;
    }

    public static int expandBackwardW(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, int start1, int start2, int start3, int end1, int end2, int end3) {
        int oldEnd1 = end1;
        while (start1 < end1 && start2 < end2 && start3 < end3) {
            char c1 = text1.charAt(end1 - 1);
            char c2 = text2.charAt(end2 - 1);
            char c3 = text3.charAt(end3 - 1);
            if (c1 != c2 || c1 != c3 || !StringUtil.isWhiteSpace((char)c1)) break;
            --end1;
            --end2;
            --end3;
        }
        return oldEnd1 - end1;
    }

    @NotNull
    public static IntPair expandForwardIW(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        while (start1 < end1 && start2 < end2) {
            char c2;
            char c1 = text1.charAt(start1);
            if (c1 == (c2 = text2.charAt(start2))) {
                ++start1;
                ++start2;
                continue;
            }
            boolean skipped = false;
            if (StringUtil.isWhiteSpace((char)c1)) {
                skipped = true;
                ++start1;
            }
            if (StringUtil.isWhiteSpace((char)c2)) {
                skipped = true;
                ++start2;
            }
            if (skipped) continue;
            break;
        }
        start1 = TrimUtil.trimStart(text1, start1, end1);
        start2 = TrimUtil.trimStart(text2, start2, end2);
        return new IntPair(start1, start2);
    }

    @NotNull
    public static IntPair expandBackwardIW(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        while (start1 < end1 && start2 < end2) {
            char c2;
            char c1 = text1.charAt(end1 - 1);
            if (c1 == (c2 = text2.charAt(end2 - 1))) {
                --end1;
                --end2;
                continue;
            }
            boolean skipped = false;
            if (StringUtil.isWhiteSpace((char)c1)) {
                skipped = true;
                --end1;
            }
            if (StringUtil.isWhiteSpace((char)c2)) {
                skipped = true;
                --end2;
            }
            if (skipped) continue;
            break;
        }
        end1 = TrimUtil.trimEnd(text1, start1, end1);
        end2 = TrimUtil.trimEnd(text2, start2, end2);
        return new IntPair(end1, end2);
    }

    @NotNull
    public static Range expandIW(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        IntPair start = TrimUtil.expandForwardIW(text1, text2, start1, start2, end1, end2);
        start1 = start.val1;
        start2 = start.val2;
        IntPair end = TrimUtil.expandBackwardIW(text1, text2, start1, start2, end1, end2);
        end1 = end.val1;
        end2 = end.val2;
        return new Range(start1, end1, start2, end2);
    }

    @NotNull
    public static Range expand(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull Range range) {
        return TrimUtil.expand(text1, text2, range.start1, range.start2, range.end1, range.end2);
    }

    @NotNull
    public static Range trim(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull Range range) {
        return TrimUtil.trim(text1, text2, range.start1, range.start2, range.end1, range.end2);
    }

    @NotNull
    public static MergeRange trim(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull MergeRange range) {
        return TrimUtil.trim(text1, text2, text3, range.start1, range.start2, range.start3, range.end1, range.end2, range.end3);
    }

    @NotNull
    public static Range expandIW(@NotNull CharSequence text1, @NotNull CharSequence text2) {
        return TrimUtil.expandIW(text1, text2, 0, 0, text1.length(), text2.length());
    }
}

