/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByChar;
import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.DiffFragmentImpl;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.util.Range;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ComparisonManagerImpl
extends ComparisonManager {
    public static final Logger LOG = Logger.getInstance(ComparisonManagerImpl.class);

    @NotNull
    public List<LineFragment> compareLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            return ByLine.compare(text1, text2, policy, indicator);
        }
        return ByLine.compareTwoStep(text1, text2, policy, indicator);
    }

    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        List<LineFragment> lineFragments = this.compareLines(text1, text2, policy, indicator);
        ArrayList<LineFragment> fineFragments = new ArrayList<LineFragment>(lineFragments.size());
        int tooBigChunksCount = 0;
        for (LineFragment fragment : lineFragments) {
            CharSequence subSequence1 = text1.subSequence(fragment.getStartOffset1(), fragment.getEndOffset1());
            CharSequence subSequence2 = text2.subSequence(fragment.getStartOffset2(), fragment.getEndOffset2());
            if (fragment.getStartLine1() == fragment.getEndLine1() || fragment.getStartLine2() == fragment.getEndLine2()) {
                if (this.isEquals(subSequence1, subSequence2, policy)) {
                    fineFragments.add((LineFragment)new LineFragmentImpl(fragment, Collections.emptyList()));
                    continue;
                }
                fineFragments.add((LineFragment)new LineFragmentImpl(fragment, null));
                continue;
            }
            if (tooBigChunksCount >= FilesTooBigForDiffException.MAX_BAD_LINES) {
                fineFragments.add((LineFragment)new LineFragmentImpl(fragment, null));
                continue;
            }
            try {
                List<ByWord.LineBlock> lineBlocks = ByWord.compareAndSplit(subSequence1, subSequence2, policy, indicator);
                assert (lineBlocks.size() != 0);
                int startOffset1 = fragment.getStartOffset1();
                int startOffset2 = fragment.getStartOffset2();
                int currentStartLine1 = fragment.getStartLine1();
                int currentStartLine2 = fragment.getStartLine2();
                for (int i = 0; i < lineBlocks.size(); ++i) {
                    ByWord.LineBlock block = lineBlocks.get(i);
                    Range offsets = block.offsets;
                    int currentEndLine1 = i != lineBlocks.size() - 1 ? currentStartLine1 + block.newlines1 : fragment.getEndLine1();
                    int currentEndLine2 = i != lineBlocks.size() - 1 ? currentStartLine2 + block.newlines2 : fragment.getEndLine2();
                    fineFragments.add((LineFragment)new LineFragmentImpl(currentStartLine1, currentEndLine1, currentStartLine2, currentEndLine2, offsets.start1 + startOffset1, offsets.end1 + startOffset1, offsets.start2 + startOffset2, offsets.end2 + startOffset2, block.fragments));
                    currentStartLine1 = currentEndLine1;
                    currentStartLine2 = currentEndLine2;
                }
            }
            catch (DiffTooBigException e) {
                fineFragments.add((LineFragment)new LineFragmentImpl(fragment, null));
                ++tooBigChunksCount;
            }
        }
        return fineFragments;
    }

    @Deprecated
    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<LineFragment> lineFragments, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        return this.compareLinesInner(text1, text2, policy, indicator);
    }

    @NotNull
    public List<DiffFragment> compareWords(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        return ByWord.compare(text1, text2, policy, indicator);
    }

    @NotNull
    public List<DiffFragment> compareChars(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            return DiffIterableUtil.convertIntoFragments(ByChar.compareIgnoreWhitespaces(text1, text2, indicator));
        }
        if (policy == ComparisonPolicy.DEFAULT) {
            return DiffIterableUtil.convertIntoFragments(ByChar.compareTwoStep(text1, text2, indicator));
        }
        LOG.warn(policy.toString() + " is not supported by ByChar comparison");
        return DiffIterableUtil.convertIntoFragments(ByChar.compareTwoStep(text1, text2, indicator));
    }

    public boolean isEquals(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
        switch (policy) {
            case DEFAULT: {
                return StringUtil.equals((CharSequence)text1, (CharSequence)text2);
            }
            case TRIM_WHITESPACES: {
                return ComparisonManagerImpl.equalsTrimWhitespaces(text1, text2);
            }
            case IGNORE_WHITESPACES: {
                return StringUtil.equalsIgnoreWhitespaces((CharSequence)text1, (CharSequence)text2);
            }
        }
        throw new IllegalArgumentException(policy.name());
    }

    @Contract(pure=true)
    private static boolean equalsTrimWhitespaces(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        boolean lastLine1;
        int index1 = 0;
        int index2 = 0;
        do {
            CharSequence line2;
            lastLine1 = false;
            boolean lastLine2 = false;
            int end1 = StringUtil.indexOf((CharSequence)s1, (char)'\n', (int)index1) + 1;
            int end2 = StringUtil.indexOf((CharSequence)s2, (char)'\n', (int)index2) + 1;
            if (end1 == 0) {
                end1 = s1.length();
                lastLine1 = true;
            }
            if (end2 == 0) {
                end2 = s2.length();
                lastLine2 = true;
            }
            if (lastLine1 ^ lastLine2) {
                return false;
            }
            CharSequence line1 = s1.subSequence(index1, end1);
            if (!StringUtil.equalsTrimWhitespaces((CharSequence)line1, (CharSequence)(line2 = s2.subSequence(index2, end2)))) {
                return false;
            }
            index1 = end1;
            index2 = end2;
        } while (!lastLine1);
        return true;
    }

    @NotNull
    public List<LineFragment> squash(@NotNull List<LineFragment> oldFragments) {
        if (oldFragments.isEmpty()) {
            return oldFragments;
        }
        final ArrayList<LineFragment> newFragments = new ArrayList<LineFragment>();
        ComparisonManagerImpl.processAdjoining(oldFragments, new Consumer<List<LineFragment>>(){

            public void consume(List<LineFragment> fragments) {
                newFragments.add(ComparisonManagerImpl.doSquash(fragments));
            }
        });
        return newFragments;
    }

    @NotNull
    public List<LineFragment> processBlocks(@NotNull List<LineFragment> oldFragments, final @NotNull CharSequence text1, final @NotNull CharSequence text2, final @NotNull ComparisonPolicy policy, final boolean squash, final boolean trim) {
        if (!squash && !trim) {
            return oldFragments;
        }
        if (oldFragments.isEmpty()) {
            return oldFragments;
        }
        final ArrayList<LineFragment> newFragments = new ArrayList<LineFragment>();
        ComparisonManagerImpl.processAdjoining(oldFragments, new Consumer<List<LineFragment>>(){

            public void consume(List<LineFragment> fragments) {
                newFragments.addAll(ComparisonManagerImpl.processAdjoining(fragments, text1, text2, policy, squash, trim));
            }
        });
        return newFragments;
    }

    private static void processAdjoining(@NotNull List<LineFragment> oldFragments, @NotNull Consumer<List<LineFragment>> consumer) {
        int startIndex = 0;
        for (int i = 1; i < oldFragments.size(); ++i) {
            if (ComparisonManagerImpl.isAdjoining(oldFragments.get(i - 1), oldFragments.get(i))) continue;
            consumer.consume(oldFragments.subList(startIndex, i));
            startIndex = i;
        }
        if (startIndex < oldFragments.size()) {
            consumer.consume(oldFragments.subList(startIndex, oldFragments.size()));
        }
    }

    @NotNull
    private static List<LineFragment> processAdjoining(@NotNull List<LineFragment> fragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, boolean squash, boolean trim) {
        int start;
        int end = fragments.size();
        if (trim && policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            CharSequenceSubSequence sequence2;
            CharSequenceSubSequence sequence1;
            LineFragment fragment;
            for (start = 0; start < end; ++start) {
                fragment = fragments.get(start);
                sequence1 = new CharSequenceSubSequence(text1, fragment.getStartOffset1(), fragment.getEndOffset1());
                sequence2 = new CharSequenceSubSequence(text2, fragment.getStartOffset2(), fragment.getEndOffset2());
                if ((fragment.getInnerFragments() == null || !fragment.getInnerFragments().isEmpty()) && !StringUtil.equalsIgnoreWhitespaces((CharSequence)sequence1, (CharSequence)sequence2)) break;
            }
            while (start < end) {
                fragment = fragments.get(end - 1);
                sequence1 = new CharSequenceSubSequence(text1, fragment.getStartOffset1(), fragment.getEndOffset1());
                sequence2 = new CharSequenceSubSequence(text2, fragment.getStartOffset2(), fragment.getEndOffset2());
                if ((fragment.getInnerFragments() == null || !fragment.getInnerFragments().isEmpty()) && !StringUtil.equalsIgnoreWhitespaces((CharSequence)sequence1, (CharSequence)sequence2)) break;
                --end;
            }
        }
        if (start == end) {
            return Collections.emptyList();
        }
        if (squash) {
            return Collections.singletonList(ComparisonManagerImpl.doSquash(fragments.subList(start, end)));
        }
        return fragments.subList(start, end);
    }

    @NotNull
    private static LineFragment doSquash(@NotNull List<LineFragment> oldFragments) {
        assert (!oldFragments.isEmpty());
        if (oldFragments.size() == 1) {
            return oldFragments.get(0);
        }
        LineFragment firstFragment = oldFragments.get(0);
        LineFragment lastFragment = oldFragments.get(oldFragments.size() - 1);
        ArrayList<DiffFragmentImpl> newInnerFragments = new ArrayList<DiffFragmentImpl>();
        for (LineFragment fragment : oldFragments) {
            for (DiffFragment diffFragment : ComparisonManagerImpl.extractInnerFragments(fragment)) {
                int shift1 = fragment.getStartOffset1() - firstFragment.getStartOffset1();
                int shift2 = fragment.getStartOffset2() - firstFragment.getStartOffset2();
                DiffFragment previousFragment = (DiffFragment)ContainerUtil.getLastItem(newInnerFragments);
                if (previousFragment == null || !ComparisonManagerImpl.isAdjoiningInner(previousFragment, diffFragment, shift1, shift2)) {
                    newInnerFragments.add(new DiffFragmentImpl(diffFragment.getStartOffset1() + shift1, diffFragment.getEndOffset1() + shift1, diffFragment.getStartOffset2() + shift2, diffFragment.getEndOffset2() + shift2));
                    continue;
                }
                newInnerFragments.remove(newInnerFragments.size() - 1);
                newInnerFragments.add(new DiffFragmentImpl(previousFragment.getStartOffset1(), diffFragment.getEndOffset1() + shift1, previousFragment.getStartOffset2(), diffFragment.getEndOffset2() + shift2));
            }
        }
        return new LineFragmentImpl(firstFragment.getStartLine1(), lastFragment.getEndLine1(), firstFragment.getStartLine2(), lastFragment.getEndLine2(), firstFragment.getStartOffset1(), lastFragment.getEndOffset1(), firstFragment.getStartOffset2(), lastFragment.getEndOffset2(), newInnerFragments);
    }

    private static boolean isAdjoining(@NotNull LineFragment beforeFragment, @NotNull LineFragment afterFragment) {
        return beforeFragment.getEndLine1() == afterFragment.getStartLine1() && beforeFragment.getEndLine2() == afterFragment.getStartLine2() && beforeFragment.getEndOffset1() == afterFragment.getStartOffset1() && beforeFragment.getEndOffset2() == afterFragment.getStartOffset2();
    }

    private static boolean isAdjoiningInner(@NotNull DiffFragment beforeFragment, @NotNull DiffFragment afterFragment, int shift1, int shift2) {
        return beforeFragment.getEndOffset1() == afterFragment.getStartOffset1() + shift1 && beforeFragment.getEndOffset2() == afterFragment.getStartOffset2() + shift2;
    }

    @NotNull
    private static List<? extends DiffFragment> extractInnerFragments(@NotNull LineFragment lineFragment) {
        if (lineFragment.getInnerFragments() != null) {
            return lineFragment.getInnerFragments();
        }
        int length1 = lineFragment.getEndOffset1() - lineFragment.getStartOffset1();
        int length2 = lineFragment.getEndOffset2() - lineFragment.getStartOffset2();
        return Collections.singletonList(new DiffFragmentImpl(0, length1, 0, length2));
    }
}

