/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByChar;
import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import gnu.trove.TIntArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

abstract class ChangeCorrector {
    private final int myLength1;
    private final int myLength2;
    @NotNull
    private final FairDiffIterable myChanges;
    @NotNull
    protected final ProgressIndicator myIndicator;
    @NotNull
    protected final DiffIterableUtil.ChangeBuilder myBuilder;

    public ChangeCorrector(int length1, int length2, @NotNull FairDiffIterable changes, @NotNull ProgressIndicator indicator) {
        this.myLength1 = length1;
        this.myLength2 = length2;
        this.myChanges = changes;
        this.myIndicator = indicator;
        this.myBuilder = new DiffIterableUtil.ChangeBuilder(length1, length2);
    }

    @NotNull
    public FairDiffIterable build() {
        this.execute();
        return DiffIterableUtil.fair(this.myBuilder.finish());
    }

    protected void execute() {
        int last1 = 0;
        int last2 = 0;
        for (Range ch : this.myChanges.iterateUnchanged()) {
            int count = ch.end1 - ch.start1;
            for (int i = 0; i < count; ++i) {
                int index1 = this.getOriginalIndex1(ch.start1 + i);
                int index2 = this.getOriginalIndex2(ch.start2 + i);
                this.matchGap(last1, index1, last2, index2);
                this.myBuilder.markEqual(index1, index2);
                last1 = index1 + 1;
                last2 = index2 + 1;
            }
        }
        this.matchGap(last1, this.myLength1, last2, this.myLength2);
    }

    protected abstract void matchGap(int var1, int var2, int var3, int var4);

    protected abstract int getOriginalIndex1(int var1);

    protected abstract int getOriginalIndex2(int var1);

    public static class SmartLineChangeCorrector
    extends ChangeCorrector {
        @NotNull
        private final TIntArrayList myIndexes1;
        @NotNull
        private final TIntArrayList myIndexes2;
        @NotNull
        private final List<ByLine.Line> myLines1;
        @NotNull
        private final List<ByLine.Line> myLines2;

        public SmartLineChangeCorrector(@NotNull TIntArrayList indexes1, @NotNull TIntArrayList indexes2, @NotNull List<ByLine.Line> lines1, @NotNull List<ByLine.Line> lines2, @NotNull FairDiffIterable changes, @NotNull ProgressIndicator indicator) {
            super(lines1.size(), lines2.size(), changes, indicator);
            this.myIndexes1 = indexes1;
            this.myIndexes2 = indexes2;
            this.myLines1 = lines1;
            this.myLines2 = lines2;
        }

        @Override
        protected void matchGap(int start1, int end1, int start2, int end2) {
            Range expand = TrimUtil.expand(this.myLines1, this.myLines2, start1, start2, end1, end2);
            List<ByLine.Line> inner1 = this.myLines1.subList(expand.start1, expand.end1);
            List<ByLine.Line> inner2 = this.myLines2.subList(expand.start2, expand.end2);
            FairDiffIterable innerChanges = DiffIterableUtil.diff(inner1, inner2, this.myIndicator);
            this.myBuilder.markEqual(start1, start2, expand.start1, expand.start2);
            for (Range chunk : innerChanges.iterateUnchanged()) {
                this.myBuilder.markEqual(expand.start1 + chunk.start1, expand.start2 + chunk.start2, chunk.end1 - chunk.start1);
            }
            this.myBuilder.markEqual(expand.end1, expand.end2, end1, end2);
        }

        @Override
        protected int getOriginalIndex1(int index) {
            return this.myIndexes1.get(index);
        }

        @Override
        protected int getOriginalIndex2(int index) {
            return this.myIndexes2.get(index);
        }
    }

    public static class DefaultCharChangeCorrector
    extends ChangeCorrector {
        @NotNull
        private final ByChar.CharOffsets myChars1;
        @NotNull
        private final ByChar.CharOffsets myChars2;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;

        public DefaultCharChangeCorrector(@NotNull ByChar.CharOffsets chars1, @NotNull ByChar.CharOffsets chars2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes, @NotNull ProgressIndicator indicator) {
            super(text1.length(), text2.length(), changes, indicator);
            this.myChars1 = chars1;
            this.myChars2 = chars2;
            this.myText1 = text1;
            this.myText2 = text2;
        }

        @Override
        protected void matchGap(int start1, int end1, int start2, int end2) {
            Range expand = TrimUtil.expand(this.myText1, this.myText2, start1, start2, end1, end2);
            CharSequence inner1 = this.myText1.subSequence(expand.start1, expand.end1);
            CharSequence inner2 = this.myText2.subSequence(expand.start2, expand.end2);
            FairDiffIterable innerChanges = ByChar.compare(inner1, inner2, this.myIndicator);
            this.myBuilder.markEqual(start1, start2, expand.start1, expand.start2);
            for (Range chunk : innerChanges.iterateUnchanged()) {
                this.myBuilder.markEqual(expand.start1 + chunk.start1, expand.start2 + chunk.start2, chunk.end1 - chunk.start1);
            }
            this.myBuilder.markEqual(expand.end1, expand.end2, end1, end2);
        }

        @Override
        protected int getOriginalIndex1(int index) {
            return this.myChars1.offsets[index];
        }

        @Override
        protected int getOriginalIndex2(int index) {
            return this.myChars2.offsets[index];
        }
    }
}

