/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByChar;
import com.intellij.diff.comparison.ChunkOptimizer;
import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.LineFragmentSplitter;
import com.intellij.diff.comparison.TextChunk;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.fragments.MergeWordFragmentImpl;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.MergingCharSequence;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ByWord {
    @NotNull
    public static List<DiffFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        indicator.checkCanceled();
        List<InlineChunk> words1 = ByWord.getInlineChunks(text1);
        List<InlineChunk> words2 = ByWord.getInlineChunks(text2);
        return ByWord.compare(text1, words1, text2, words2, policy, indicator);
    }

    @NotNull
    public static List<DiffFragment> compare(@NotNull CharSequence text1, @NotNull List<InlineChunk> words1, @NotNull CharSequence text2, @NotNull List<InlineChunk> words2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        FairDiffIterable wordChanges = DiffIterableUtil.diff(words1, words2, indicator);
        wordChanges = ByWord.optimizeWordChunks(text1, text2, words1, words2, wordChanges, indicator);
        FairDiffIterable delimitersIterable = ByWord.matchAdjustmentDelimiters(text1, text2, words1, words2, wordChanges, indicator);
        DiffIterable iterable = ByWord.matchAdjustmentWhitespaces(text1, text2, delimitersIterable, policy, indicator);
        return ByWord.convertIntoFragments(iterable);
    }

    @NotNull
    public static List<MergeWordFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        indicator.checkCanceled();
        List<InlineChunk> words1 = ByWord.getInlineChunks(text1);
        List<InlineChunk> words2 = ByWord.getInlineChunks(text2);
        List<InlineChunk> words3 = ByWord.getInlineChunks(text3);
        FairDiffIterable wordChanges1 = DiffIterableUtil.diff(words2, words1, indicator);
        wordChanges1 = ByWord.optimizeWordChunks(text2, text1, words2, words1, wordChanges1, indicator);
        FairDiffIterable iterable1 = ByWord.matchAdjustmentDelimiters(text2, text1, words2, words1, wordChanges1, indicator);
        FairDiffIterable wordChanges2 = DiffIterableUtil.diff(words2, words3, indicator);
        wordChanges2 = ByWord.optimizeWordChunks(text2, text3, words2, words3, wordChanges2, indicator);
        FairDiffIterable iterable2 = ByWord.matchAdjustmentDelimiters(text2, text3, words2, words3, wordChanges2, indicator);
        List<MergeRange> wordConflicts = ComparisonMergeUtil.buildFair(iterable1, iterable2, indicator);
        List<MergeRange> result = ByWord.matchAdjustmentWhitespaces(text1, text2, text3, wordConflicts, policy, indicator);
        return ByWord.convertIntoFragments(result);
    }

    @NotNull
    public static List<LineBlock> compareAndSplit(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        indicator.checkCanceled();
        List<InlineChunk> words1 = ByWord.getInlineChunks(text1);
        List<InlineChunk> words2 = ByWord.getInlineChunks(text2);
        FairDiffIterable wordChanges = DiffIterableUtil.diff(words1, words2, indicator);
        wordChanges = ByWord.optimizeWordChunks(text1, text2, words1, words2, wordChanges, indicator);
        List<LineFragmentSplitter.WordBlock> wordBlocks = new LineFragmentSplitter(text1, text2, words1, words2, wordChanges, indicator).run();
        ArrayList<LineBlock> lineBlocks = new ArrayList<LineBlock>(wordBlocks.size());
        for (LineFragmentSplitter.WordBlock block : wordBlocks) {
            Range offsets = block.offsets;
            Range words = block.words;
            CharSequence subtext1 = text1.subSequence(offsets.start1, offsets.end1);
            CharSequence subtext2 = text2.subSequence(offsets.start2, offsets.end2);
            List<InlineChunk> subwords1 = words1.subList(words.start1, words.end1);
            List<InlineChunk> subwords2 = words2.subList(words.start2, words.end2);
            FairDiffIterable subiterable = DiffIterableUtil.fair(DiffIterableUtil.trim(wordChanges, words.start1, words.end1, words.start2, words.end2));
            FairDiffIterable delimitersIterable = ByWord.matchAdjustmentDelimiters(subtext1, subtext2, subwords1, subwords2, subiterable, offsets.start1, offsets.start2, indicator);
            DiffIterable iterable = ByWord.matchAdjustmentWhitespaces(subtext1, subtext2, delimitersIterable, policy, indicator);
            List<DiffFragment> fragments = ByWord.convertIntoFragments(iterable);
            int newlines1 = ByWord.countNewlines(subwords1);
            int newlines2 = ByWord.countNewlines(subwords2);
            lineBlocks.add(new LineBlock(fragments, offsets, newlines1, newlines2));
        }
        return lineBlocks;
    }

    @NotNull
    private static List<MergeWordFragment> convertIntoFragments(@NotNull List<MergeRange> conflicts) {
        return ContainerUtil.map(conflicts, (Function)new Function<MergeRange, MergeWordFragment>(){

            public MergeWordFragment fun(MergeRange ch) {
                return new MergeWordFragmentImpl(ch);
            }
        });
    }

    @NotNull
    private static List<DiffFragment> convertIntoFragments(@NotNull DiffIterable iterable) {
        return DiffIterableUtil.convertIntoFragments(iterable);
    }

    @NotNull
    private static FairDiffIterable optimizeWordChunks(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<InlineChunk> words1, @NotNull List<InlineChunk> words2, @NotNull FairDiffIterable iterable, @NotNull ProgressIndicator indicator) {
        return new ChunkOptimizer.WordChunkOptimizer(words1, words2, text1, text2, iterable, indicator).build();
    }

    @NotNull
    private static FairDiffIterable matchAdjustmentDelimiters(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<InlineChunk> words1, @NotNull List<InlineChunk> words2, @NotNull FairDiffIterable changes, @NotNull ProgressIndicator indicator) {
        return ByWord.matchAdjustmentDelimiters(text1, text2, words1, words2, changes, 0, 0, indicator);
    }

    @NotNull
    private static FairDiffIterable matchAdjustmentDelimiters(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<InlineChunk> words1, @NotNull List<InlineChunk> words2, @NotNull FairDiffIterable changes, int startShift1, int startShift2, @NotNull ProgressIndicator indicator) {
        return new AdjustmentPunctuationMatcher(text1, text2, words1, words2, startShift1, startShift2, changes, indicator).build();
    }

    @NotNull
    private static DiffIterable matchAdjustmentWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable iterable, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        switch (policy) {
            case DEFAULT: {
                return new DefaultCorrector(iterable, text1, text2, indicator).build();
            }
            case TRIM_WHITESPACES: {
                DiffIterable defaultIterable = new DefaultCorrector(iterable, text1, text2, indicator).build();
                return new TrimSpacesCorrector(defaultIterable, text1, text2, indicator).build();
            }
            case IGNORE_WHITESPACES: {
                return new IgnoreSpacesCorrector(iterable, text1, text2, indicator).build();
            }
        }
        throw new IllegalArgumentException(policy.name());
    }

    @NotNull
    private static List<MergeRange> matchAdjustmentWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull List<MergeRange> conflicts, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        switch (policy) {
            case DEFAULT: {
                return new MergeDefaultCorrector(conflicts, text1, text2, text3, indicator).build();
            }
            case TRIM_WHITESPACES: {
                List<MergeRange> defaultConflicts = new MergeDefaultCorrector(conflicts, text1, text2, text3, indicator).build();
                return new MergeTrimSpacesCorrector(defaultConflicts, text1, text2, text3, indicator).build();
            }
            case IGNORE_WHITESPACES: {
                return new MergeIgnoreSpacesCorrector(conflicts, text1, text2, text3, indicator).build();
            }
        }
        throw new IllegalArgumentException(policy.name());
    }

    @NotNull
    private static Couple<FairDiffIterable> comparePunctuation2Side(@NotNull CharSequence text1, @NotNull CharSequence text21, @NotNull CharSequence text22, @NotNull ProgressIndicator indicator) {
        MergingCharSequence text2 = new MergingCharSequence(text21, text22);
        FairDiffIterable changes = ByChar.comparePunctuation(text1, (CharSequence)text2, indicator);
        Couple<List<Range>> ranges = ByWord.splitIterable2Side(changes, text21.length());
        FairDiffIterable iterable1 = DiffIterableUtil.fair(DiffIterableUtil.createUnchanged((List)ranges.first, text1.length(), text21.length()));
        FairDiffIterable iterable2 = DiffIterableUtil.fair(DiffIterableUtil.createUnchanged((List)ranges.second, text1.length(), text22.length()));
        return Couple.of((Object)iterable1, (Object)iterable2);
    }

    @NotNull
    private static Couple<List<Range>> splitIterable2Side(@NotNull FairDiffIterable changes, int offset) {
        ArrayList<Range> ranges1 = new ArrayList<Range>();
        ArrayList<Range> ranges2 = new ArrayList<Range>();
        for (Range ch : changes.iterateUnchanged()) {
            if (ch.end2 <= offset) {
                ranges1.add(new Range(ch.start1, ch.end1, ch.start2, ch.end2));
                continue;
            }
            if (ch.start2 >= offset) {
                ranges2.add(new Range(ch.start1, ch.end1, ch.start2 - offset, ch.end2 - offset));
                continue;
            }
            int len2 = offset - ch.start2;
            ranges1.add(new Range(ch.start1, ch.start1 + len2, ch.start2, offset));
            ranges2.add(new Range(ch.start1 + len2, ch.end1, 0, ch.end2 - offset));
        }
        return Couple.of(ranges1, ranges2);
    }

    private static boolean isLeadingTrailingSpace(@NotNull CharSequence text, int start) {
        return ByWord.isLeadingSpace(text, start) || ByWord.isTrailingSpace(text, start);
    }

    private static boolean isLeadingSpace(@NotNull CharSequence text, int start) {
        if (start < 0) {
            return false;
        }
        if (start == text.length()) {
            return false;
        }
        if (!StringUtil.isWhiteSpace((char)text.charAt(start))) {
            return false;
        }
        --start;
        while (start >= 0) {
            char c = text.charAt(start);
            if (c == '\n') {
                return true;
            }
            if (!StringUtil.isWhiteSpace((char)c)) {
                return false;
            }
            --start;
        }
        return true;
    }

    private static boolean isTrailingSpace(@NotNull CharSequence text, int end) {
        if (end < 0) {
            return false;
        }
        if (end == text.length()) {
            return false;
        }
        if (!StringUtil.isWhiteSpace((char)text.charAt(end))) {
            return false;
        }
        while (end < text.length()) {
            char c = text.charAt(end);
            if (c == '\n') {
                return true;
            }
            if (!StringUtil.isWhiteSpace((char)c)) {
                return false;
            }
            ++end;
        }
        return true;
    }

    private static int countNewlines(@NotNull List<InlineChunk> words) {
        int count = 0;
        for (InlineChunk word : words) {
            if (!(word instanceof NewlineChunk)) continue;
            ++count;
        }
        return count;
    }

    @NotNull
    public static List<InlineChunk> getInlineChunks(@NotNull CharSequence text) {
        ArrayList<InlineChunk> chunks = new ArrayList<InlineChunk>();
        int len = text.length();
        int offset = 0;
        while (offset < len) {
            char c;
            char ch = text.charAt(offset);
            if (TrimUtil.isAlpha(ch)) {
                char c2;
                int startOffset = offset;
                int h = 0;
                while (offset < len && TrimUtil.isAlpha(c2 = text.charAt(offset))) {
                    h = 31 * h + c2;
                    ++offset;
                }
                chunks.add(new WordChunk(text, startOffset, offset, h));
                continue;
            }
            while (offset < len && !TrimUtil.isAlpha(c = text.charAt(offset))) {
                if (c == '\n') {
                    chunks.add(new NewlineChunk(offset));
                }
                ++offset;
            }
        }
        return chunks;
    }

    public static class LineBlock {
        @NotNull
        public final List<DiffFragment> fragments;
        @NotNull
        public final Range offsets;
        public final int newlines1;
        public final int newlines2;

        public LineBlock(@NotNull List<DiffFragment> fragments, @NotNull Range offsets, int newlines1, int newlines2) {
            this.fragments = fragments;
            this.offsets = offsets;
            this.newlines1 = newlines1;
            this.newlines2 = newlines2;
        }
    }

    static class NewlineChunk
    implements InlineChunk {
        private final int myOffset;

        public NewlineChunk(int offset) {
            this.myOffset = offset;
        }

        @Override
        public int getOffset1() {
            return this.myOffset;
        }

        @Override
        public int getOffset2() {
            return this.myOffset + 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    static class WordChunk
    extends TextChunk
    implements InlineChunk {
        private final int myHash;

        public WordChunk(@NotNull CharSequence text, int offset1, int offset2, int hash) {
            super(text, offset1, offset2);
            this.myHash = hash;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WordChunk word = (WordChunk)o;
            if (this.myHash != word.myHash) {
                return false;
            }
            return StringUtil.equals((CharSequence)this.getContent(), (CharSequence)word.getContent());
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }
    }

    public static interface InlineChunk {
        public int getOffset1();

        public int getOffset2();
    }

    private static class MergeTrimSpacesCorrector {
        @NotNull
        private final List<MergeRange> myIterable;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final CharSequence myText3;
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private final List<MergeRange> myChanges;

        public MergeTrimSpacesCorrector(@NotNull List<MergeRange> iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ProgressIndicator indicator) {
            this.myIterable = iterable;
            this.myText1 = text1;
            this.myText2 = text2;
            this.myText3 = text3;
            this.myIndicator = indicator;
            this.myChanges = new ArrayList<MergeRange>();
        }

        @NotNull
        public List<MergeRange> build() {
            for (MergeRange range : this.myIterable) {
                MergeRange trimmed;
                int start1 = range.start1;
                int start2 = range.start2;
                int start3 = range.start3;
                int end1 = range.end1;
                int end2 = range.end2;
                int end3 = range.end3;
                if (ByWord.isLeadingTrailingSpace(this.myText1, start1)) {
                    start1 = TrimUtil.trimStart(this.myText1, start1, end1);
                }
                if (ByWord.isLeadingTrailingSpace(this.myText1, end1 - 1)) {
                    end1 = TrimUtil.trimEnd(this.myText1, start1, end1);
                }
                if (ByWord.isLeadingTrailingSpace(this.myText2, start2)) {
                    start2 = TrimUtil.trimStart(this.myText2, start2, end2);
                }
                if (ByWord.isLeadingTrailingSpace(this.myText2, end2 - 1)) {
                    end2 = TrimUtil.trimEnd(this.myText2, start2, end2);
                }
                if (ByWord.isLeadingTrailingSpace(this.myText3, start3)) {
                    start3 = TrimUtil.trimStart(this.myText3, start3, end3);
                }
                if (ByWord.isLeadingTrailingSpace(this.myText3, end3 - 1)) {
                    end3 = TrimUtil.trimEnd(this.myText3, start3, end3);
                }
                if ((trimmed = new MergeRange(start1, end1, start2, end2, start3, end3)).isEmpty()) continue;
                this.myChanges.add(trimmed);
            }
            return this.myChanges;
        }
    }

    private static class TrimSpacesCorrector {
        @NotNull
        private final DiffIterable myIterable;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private final List<Range> myChanges;

        public TrimSpacesCorrector(@NotNull DiffIterable iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
            this.myIterable = iterable;
            this.myText1 = text1;
            this.myText2 = text2;
            this.myIndicator = indicator;
            this.myChanges = new ArrayList<Range>();
        }

        @NotNull
        public DiffIterable build() {
            for (Range range : this.myIterable.iterateChanges()) {
                Range trimmed;
                int start1 = range.start1;
                int start2 = range.start2;
                int end1 = range.end1;
                int end2 = range.end2;
                if (ByWord.isLeadingTrailingSpace(this.myText1, start1)) {
                    start1 = TrimUtil.trimStart(this.myText1, start1, end1);
                }
                if (ByWord.isLeadingTrailingSpace(this.myText1, end1 - 1)) {
                    end1 = TrimUtil.trimEnd(this.myText1, start1, end1);
                }
                if (ByWord.isLeadingTrailingSpace(this.myText2, start2)) {
                    start2 = TrimUtil.trimStart(this.myText2, start2, end2);
                }
                if (ByWord.isLeadingTrailingSpace(this.myText2, end2 - 1)) {
                    end2 = TrimUtil.trimEnd(this.myText2, start2, end2);
                }
                if ((trimmed = new Range(start1, end1, start2, end2)).isEmpty()) continue;
                this.myChanges.add(trimmed);
            }
            return DiffIterableUtil.create(this.myChanges, this.myText1.length(), this.myText2.length());
        }
    }

    private static class MergeIgnoreSpacesCorrector {
        @NotNull
        private final List<MergeRange> myIterable;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final CharSequence myText3;
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private final List<MergeRange> myChanges;

        public MergeIgnoreSpacesCorrector(@NotNull List<MergeRange> iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ProgressIndicator indicator) {
            this.myIterable = iterable;
            this.myText1 = text1;
            this.myText2 = text2;
            this.myText3 = text3;
            this.myIndicator = indicator;
            this.myChanges = new ArrayList<MergeRange>();
        }

        @NotNull
        public List<MergeRange> build() {
            for (MergeRange range : this.myIterable) {
                MergeRange trimmed = TrimUtil.trim(this.myText1, this.myText2, this.myText3, range);
                if (trimmed.isEmpty()) continue;
                this.myChanges.add(trimmed);
            }
            return this.myChanges;
        }
    }

    private static class IgnoreSpacesCorrector {
        @NotNull
        private final DiffIterable myIterable;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private final List<Range> myChanges;

        public IgnoreSpacesCorrector(@NotNull DiffIterable iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
            this.myIterable = iterable;
            this.myText1 = text1;
            this.myText2 = text2;
            this.myIndicator = indicator;
            this.myChanges = new ArrayList<Range>();
        }

        @NotNull
        public DiffIterable build() {
            for (Range range : this.myIterable.iterateChanges()) {
                Range trimmed = TrimUtil.trim(this.myText1, this.myText2, range);
                if (trimmed.isEmpty()) continue;
                this.myChanges.add(trimmed);
            }
            return DiffIterableUtil.create(this.myChanges, this.myText1.length(), this.myText2.length());
        }
    }

    private static class MergeDefaultCorrector {
        @NotNull
        private final List<MergeRange> myIterable;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final CharSequence myText3;
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private final List<MergeRange> myChanges;

        public MergeDefaultCorrector(@NotNull List<MergeRange> iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ProgressIndicator indicator) {
            this.myIterable = iterable;
            this.myText1 = text1;
            this.myText2 = text2;
            this.myText3 = text3;
            this.myIndicator = indicator;
            this.myChanges = new ArrayList<MergeRange>();
        }

        @NotNull
        public List<MergeRange> build() {
            for (MergeRange range : this.myIterable) {
                int endCut = TrimUtil.expandBackwardW(this.myText1, this.myText2, this.myText3, range.start1, range.start2, range.start3, range.end1, range.end2, range.end3);
                int startCut = TrimUtil.expandForwardW(this.myText1, this.myText2, this.myText3, range.start1, range.start2, range.start3, range.end1 - endCut, range.end2 - endCut, range.end3 - endCut);
                MergeRange expand = new MergeRange(range.start1 + startCut, range.end1 - endCut, range.start2 + startCut, range.end2 - endCut, range.start3 + startCut, range.end3 - endCut);
                if (expand.isEmpty()) continue;
                this.myChanges.add(expand);
            }
            return this.myChanges;
        }
    }

    private static class DefaultCorrector {
        @NotNull
        private final DiffIterable myIterable;
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private final List<Range> myChanges;

        public DefaultCorrector(@NotNull DiffIterable iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
            this.myIterable = iterable;
            this.myText1 = text1;
            this.myText2 = text2;
            this.myIndicator = indicator;
            this.myChanges = new ArrayList<Range>();
        }

        @NotNull
        public DiffIterable build() {
            for (Range range : this.myIterable.iterateChanges()) {
                int endCut = TrimUtil.expandBackwardW(this.myText1, this.myText2, range.start1, range.start2, range.end1, range.end2);
                int startCut = TrimUtil.expandForwardW(this.myText1, this.myText2, range.start1, range.start2, range.end1 - endCut, range.end2 - endCut);
                Range expand = new Range(range.start1 + startCut, range.end1 - endCut, range.start2 + startCut, range.end2 - endCut);
                if (expand.isEmpty()) continue;
                this.myChanges.add(expand);
            }
            return DiffIterableUtil.create(this.myChanges, this.myText1.length(), this.myText2.length());
        }
    }

    private static class AdjustmentPunctuationMatcher {
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        @NotNull
        private final List<InlineChunk> myWords1;
        @NotNull
        private final List<InlineChunk> myWords2;
        @NotNull
        private final FairDiffIterable myChanges;
        @NotNull
        private final ProgressIndicator myIndicator;
        private final int myStartShift1;
        private final int myStartShift2;
        private final int myLen1;
        private final int myLen2;
        private final DiffIterableUtil.ChangeBuilder myBuilder;
        int lastStart1;
        int lastStart2;
        int lastEnd1;
        int lastEnd2;

        public AdjustmentPunctuationMatcher(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<InlineChunk> words1, @NotNull List<InlineChunk> words2, int startShift1, int startShift2, @NotNull FairDiffIterable changes, @NotNull ProgressIndicator indicator) {
            this.myText1 = text1;
            this.myText2 = text2;
            this.myWords1 = words1;
            this.myWords2 = words2;
            this.myStartShift1 = startShift1;
            this.myStartShift2 = startShift2;
            this.myChanges = changes;
            this.myIndicator = indicator;
            this.myLen1 = text1.length();
            this.myLen2 = text2.length();
            this.myBuilder = new DiffIterableUtil.ChangeBuilder(this.myLen1, this.myLen2);
        }

        @NotNull
        public FairDiffIterable build() {
            this.execute();
            return DiffIterableUtil.fair(this.myBuilder.finish());
        }

        private void execute() {
            this.clearLastRange();
            this.matchForward(-1, -1);
            for (Range ch : this.myChanges.iterateUnchanged()) {
                int count = ch.end1 - ch.start1;
                for (int i = 0; i < count; ++i) {
                    int index1 = ch.start1 + i;
                    int index2 = ch.start2 + i;
                    int start1 = this.getStartOffset1(index1);
                    int start2 = this.getStartOffset2(index2);
                    int end1 = this.getEndOffset1(index1);
                    int end2 = this.getEndOffset2(index2);
                    this.matchBackward(index1, index2);
                    this.myBuilder.markEqual(start1, start2, end1, end2);
                    this.matchForward(index1, index2);
                }
            }
            this.matchBackward(this.myWords1.size(), this.myWords2.size());
        }

        private void clearLastRange() {
            this.lastStart1 = -1;
            this.lastStart2 = -1;
            this.lastEnd1 = -1;
            this.lastEnd2 = -1;
        }

        private void matchBackward(int index1, int index2) {
            int start1 = index1 == 0 ? 0 : this.getEndOffset1(index1 - 1);
            int start2 = index2 == 0 ? 0 : this.getEndOffset2(index2 - 1);
            int end1 = index1 == this.myWords1.size() ? this.myLen1 : this.getStartOffset1(index1);
            int end2 = index2 == this.myWords2.size() ? this.myLen2 : this.getStartOffset2(index2);
            this.matchBackward(start1, start2, end1, end2);
            this.clearLastRange();
        }

        private void matchForward(int index1, int index2) {
            int start1 = index1 == -1 ? 0 : this.getEndOffset1(index1);
            int start2 = index2 == -1 ? 0 : this.getEndOffset2(index2);
            int end1 = index1 + 1 == this.myWords1.size() ? this.myLen1 : this.getStartOffset1(index1 + 1);
            int end2 = index2 + 1 == this.myWords2.size() ? this.myLen2 : this.getStartOffset2(index2 + 1);
            this.matchForward(start1, start2, end1, end2);
        }

        private void matchForward(int start1, int start2, int end1, int end2) {
            assert (this.lastStart1 == -1 && this.lastStart2 == -1 && this.lastEnd1 == -1 && this.lastEnd2 == -1);
            this.lastStart1 = start1;
            this.lastStart2 = start2;
            this.lastEnd1 = end1;
            this.lastEnd2 = end2;
        }

        private void matchBackward(int start1, int start2, int end1, int end2) {
            assert (this.lastStart1 != -1 && this.lastStart2 != -1 && this.lastEnd1 != -1 && this.lastEnd2 != -1);
            if (this.lastStart1 == start1 && this.lastStart2 == start2) {
                assert (this.lastEnd1 == end1 && this.lastEnd2 == end2);
                this.matchRange(start1, start2, end1, end2);
                return;
            }
            if (this.lastStart1 < start1 && this.lastStart2 < start2) {
                assert (this.lastEnd1 <= start1 && this.lastEnd2 <= start2);
                this.matchRange(this.lastStart1, this.lastStart2, this.lastEnd1, this.lastEnd2);
                this.matchRange(start1, start2, end1, end2);
                return;
            }
            this.matchComplexRange(this.lastStart1, this.lastStart2, this.lastEnd1, this.lastEnd2, start1, start2, end1, end2);
        }

        private void matchRange(int start1, int start2, int end1, int end2) {
            if (start1 == end1 && start2 == end2) {
                return;
            }
            CharSequence sequence1 = this.myText1.subSequence(start1, end1);
            CharSequence sequence2 = this.myText2.subSequence(start2, end2);
            FairDiffIterable changes = ByChar.comparePunctuation(sequence1, sequence2, this.myIndicator);
            for (Range ch : changes.iterateUnchanged()) {
                this.myBuilder.markEqual(start1 + ch.start1, start2 + ch.start2, start1 + ch.end1, start2 + ch.end2);
            }
        }

        private void matchComplexRange(int start11, int start12, int end11, int end12, int start21, int start22, int end21, int end22) {
            if (start11 == start21 && end11 == end21) {
                this.matchComplexRangeLeft(start11, end11, start12, end12, start22, end22);
            } else if (start12 == start22 && end12 == end22) {
                this.matchComplexRangeRight(start12, end12, start11, end11, start21, end21);
            } else {
                throw new IllegalStateException();
            }
        }

        private void matchComplexRangeLeft(int start1, int end1, int start12, int end12, int start22, int end22) {
            CharSequence sequence1 = this.myText1.subSequence(start1, end1);
            CharSequence sequence21 = this.myText2.subSequence(start12, end12);
            CharSequence sequence22 = this.myText2.subSequence(start22, end22);
            Couple changes = ByWord.comparePunctuation2Side(sequence1, sequence21, sequence22, this.myIndicator);
            for (Range ch : ((FairDiffIterable)changes.first).iterateUnchanged()) {
                this.myBuilder.markEqual(start1 + ch.start1, start12 + ch.start2, start1 + ch.end1, start12 + ch.end2);
            }
            for (Range ch : ((FairDiffIterable)changes.second).iterateUnchanged()) {
                this.myBuilder.markEqual(start1 + ch.start1, start22 + ch.start2, start1 + ch.end1, start22 + ch.end2);
            }
        }

        private void matchComplexRangeRight(int start2, int end2, int start11, int end11, int start21, int end21) {
            CharSequence sequence11 = this.myText1.subSequence(start11, end11);
            CharSequence sequence12 = this.myText1.subSequence(start21, end21);
            CharSequence sequence2 = this.myText2.subSequence(start2, end2);
            Couple changes = ByWord.comparePunctuation2Side(sequence2, sequence11, sequence12, this.myIndicator);
            for (Range ch : ((FairDiffIterable)changes.first).iterateUnchanged()) {
                this.myBuilder.markEqual(start11 + ch.start2, start2 + ch.start1, start11 + ch.end2, start2 + ch.end1);
            }
            for (Range ch : ((FairDiffIterable)changes.second).iterateUnchanged()) {
                this.myBuilder.markEqual(start21 + ch.start2, start2 + ch.start1, start21 + ch.end2, start2 + ch.end1);
            }
        }

        private int getStartOffset1(int index) {
            return this.myWords1.get(index).getOffset1() - this.myStartShift1;
        }

        private int getStartOffset2(int index) {
            return this.myWords2.get(index).getOffset1() - this.myStartShift2;
        }

        private int getEndOffset1(int index) {
            return this.myWords1.get(index).getOffset2() - this.myStartShift1;
        }

        private int getEndOffset2(int index) {
            return this.myWords2.get(index).getOffset2() - this.myStartShift2;
        }
    }
}

