/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ChangeCorrector;
import com.intellij.diff.comparison.ChunkOptimizer;
import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.TextChunk;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeLineFragmentImpl;
import com.intellij.diff.util.IntPair;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ByLine {
    @NotNull
    public static List<LineFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        indicator.checkCanceled();
        List<Line> lines1 = ByLine.getLines(text1, policy);
        List<Line> lines2 = ByLine.getLines(text2, policy);
        FairDiffIterable changes = ByLine.compareSmart(lines1, lines2, indicator);
        changes = ByLine.optimizeLineChunks(lines1, lines2, changes, indicator);
        changes = ByLine.expandRanges(lines1, lines2, changes, indicator);
        return ByLine.convertIntoFragments(lines1, lines2, changes);
    }

    @NotNull
    public static List<LineFragment> compareTwoStep(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        indicator.checkCanceled();
        List<Line> lines1 = ByLine.getLines(text1, policy);
        List<Line> lines2 = ByLine.getLines(text2, policy);
        List<Line> iwLines1 = ByLine.convertToIgnoreWhitespace(lines1);
        List<Line> iwLines2 = ByLine.convertToIgnoreWhitespace(lines2);
        FairDiffIterable iwChanges = ByLine.compareSmart(iwLines1, iwLines2, indicator);
        iwChanges = ByLine.optimizeLineChunks(lines1, lines2, iwChanges, indicator);
        FairDiffIterable changes = ByLine.correctChangesSecondStep(lines1, lines2, iwChanges);
        return ByLine.convertIntoFragments(lines1, lines2, changes);
    }

    @NotNull
    public static List<MergeLineFragment> compareTwoStep(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        indicator.checkCanceled();
        List<Line> lines1 = ByLine.getLines(text1, policy);
        List<Line> lines2 = ByLine.getLines(text2, policy);
        List<Line> lines3 = ByLine.getLines(text3, policy);
        List<Line> iwLines1 = ByLine.convertToIgnoreWhitespace(lines1);
        List<Line> iwLines2 = ByLine.convertToIgnoreWhitespace(lines2);
        List<Line> iwLines3 = ByLine.convertToIgnoreWhitespace(lines3);
        FairDiffIterable iwChanges1 = ByLine.compareSmart(iwLines2, iwLines1, indicator);
        iwChanges1 = ByLine.optimizeLineChunks(lines2, lines1, iwChanges1, indicator);
        FairDiffIterable iterable1 = ByLine.correctChangesSecondStep(lines2, lines1, iwChanges1);
        FairDiffIterable iwChanges2 = ByLine.compareSmart(iwLines2, iwLines3, indicator);
        iwChanges2 = ByLine.optimizeLineChunks(lines2, lines3, iwChanges2, indicator);
        FairDiffIterable iterable2 = ByLine.correctChangesSecondStep(lines2, lines3, iwChanges2);
        List<MergeRange> conflicts = ComparisonMergeUtil.buildFair(iterable1, iterable2, indicator);
        return ByLine.convertIntoFragments(conflicts);
    }

    @NotNull
    private static FairDiffIterable correctChangesSecondStep(final @NotNull List<Line> lines1, final @NotNull List<Line> lines2, final @NotNull FairDiffIterable changes) {
        final DiffIterableUtil.ExpandChangeBuilder builder = new DiffIterableUtil.ExpandChangeBuilder(lines1, lines2);
        new Object(){
            private CharSequence sample = null;
            private int last1 = -1;
            private int last2 = -1;

            public void run() {
                for (Range range : changes.iterateUnchanged()) {
                    int count = range.end1 - range.start1;
                    for (int i = 0; i < count; ++i) {
                        int index1 = range.start1 + i;
                        int index2 = range.start2 + i;
                        Line line1 = (Line)lines1.get(index1);
                        Line line2 = (Line)lines2.get(index2);
                        if (StringUtil.equalsIgnoreWhitespaces((CharSequence)this.sample, (CharSequence)line1.getContent())) continue;
                        if (line1.equals(line2)) {
                            this.flush(index1, index2);
                            builder.markEqual(index1, index2);
                            continue;
                        }
                        this.flush(index1, index2);
                        this.sample = line1.getContent();
                        this.last1 = index1;
                        this.last2 = index2;
                    }
                }
                this.flush(changes.getLength1(), changes.getLength2());
            }

            private void flush(int line1, int line2) {
                int i;
                if (this.sample == null) {
                    return;
                }
                TIntArrayList subLines1 = new TIntArrayList();
                TIntArrayList subLines2 = new TIntArrayList();
                for (i = this.last1; i < line1; ++i) {
                    if (!StringUtil.equalsIgnoreWhitespaces((CharSequence)this.sample, (CharSequence)((Line)lines1.get(i)).getContent())) continue;
                    subLines1.add(i);
                }
                for (i = this.last2; i < line2; ++i) {
                    if (!StringUtil.equalsIgnoreWhitespaces((CharSequence)this.sample, (CharSequence)((Line)lines2.get(i)).getContent())) continue;
                    subLines2.add(i);
                }
                assert (subLines1.size() > 0 && subLines2.size() > 0);
                this.alignExactMatching(subLines1, subLines2);
                this.sample = null;
                this.last1 = -1;
                this.last2 = -1;
            }

            private void alignExactMatching(TIntArrayList subLines1, TIntArrayList subLines2) {
                if (subLines1.size() == subLines2.size()) {
                    return;
                }
                int n = Math.max(subLines1.size(), subLines2.size());
                if (n > 10) {
                    return;
                }
                if (subLines1.size() < subLines2.size()) {
                    int[] matching = ByLine.getBestMatchingAlignment(subLines1, subLines2, lines1, lines2);
                    for (int i = 0; i < subLines1.size(); ++i) {
                        int index1 = subLines1.get(i);
                        int index2 = subLines2.get(matching[i]);
                        if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                        builder.markEqual(index1, index2);
                    }
                } else {
                    int[] matching = ByLine.getBestMatchingAlignment(subLines2, subLines1, lines2, lines1);
                    for (int i = 0; i < subLines2.size(); ++i) {
                        int index1 = subLines1.get(matching[i]);
                        int index2 = subLines2.get(i);
                        if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                        builder.markEqual(index1, index2);
                    }
                }
            }
        }.run();
        return DiffIterableUtil.fair(builder.finish());
    }

    @NotNull
    private static int[] getBestMatchingAlignment(final @NotNull TIntArrayList subLines1, final @NotNull TIntArrayList subLines2, final @NotNull List<Line> lines1, final @NotNull List<Line> lines2) {
        assert (subLines1.size() < subLines2.size());
        final int size = subLines1.size();
        final int[] comb = new int[size];
        final int[] best = new int[size];
        for (int i = 0; i < size; ++i) {
            best[i] = i;
        }
        new Object(){
            int bestWeight = 0;

            public void run() {
                this.combinations(0, subLines2.size() - 1, 0);
            }

            private void combinations(int start, int n, int k) {
                if (k == size) {
                    this.processCombination();
                    return;
                }
                for (int i = start; i <= n; ++i) {
                    comb[k] = i;
                    this.combinations(i + 1, n, k + 1);
                }
            }

            private void processCombination() {
                int weight = 0;
                for (int i = 0; i < size; ++i) {
                    int index1 = subLines1.get(i);
                    int index2 = subLines2.get(comb[i]);
                    if (!((Line)lines1.get(index1)).equals(lines2.get(index2))) continue;
                    ++weight;
                }
                if (weight > this.bestWeight) {
                    this.bestWeight = weight;
                    System.arraycopy(comb, 0, best, 0, comb.length);
                }
            }
        }.run();
        return best;
    }

    @NotNull
    private static FairDiffIterable optimizeLineChunks(@NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull FairDiffIterable iterable, @NotNull ProgressIndicator indicator) {
        return new ChunkOptimizer.LineChunkOptimizer(lines1, lines2, iterable, indicator).build();
    }

    @NotNull
    private static List<LineFragment> convertIntoFragments(@NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull FairDiffIterable changes) {
        ArrayList<LineFragment> fragments = new ArrayList<LineFragment>();
        for (Range ch : changes.iterateChanges()) {
            IntPair offsets1 = ByLine.getOffsets(lines1, ch.start1, ch.end1);
            IntPair offsets2 = ByLine.getOffsets(lines2, ch.start2, ch.end2);
            fragments.add((LineFragment)new LineFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2, offsets1.val1, offsets1.val2, offsets2.val1, offsets2.val2));
        }
        return fragments;
    }

    @NotNull
    private static List<MergeLineFragment> convertIntoFragments(@NotNull List<MergeRange> conflicts) {
        return ContainerUtil.map(conflicts, (Function)new Function<MergeRange, MergeLineFragment>(){

            public MergeLineFragment fun(MergeRange ch) {
                return new MergeLineFragmentImpl(ch);
            }
        });
    }

    @NotNull
    private static IntPair getOffsets(@NotNull List<Line> lines, int startIndex, int endIndex) {
        if (startIndex == endIndex) {
            int offset = startIndex < lines.size() ? lines.get(startIndex).getOffset1() : lines.get(lines.size() - 1).getOffset2();
            return new IntPair(offset, offset);
        }
        int offset1 = lines.get(startIndex).getOffset1();
        int offset2 = lines.get(endIndex - 1).getOffset2();
        return new IntPair(offset1, offset2);
    }

    @NotNull
    private static FairDiffIterable compareSmart(@NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull ProgressIndicator indicator) {
        int threshold = Registry.intValue((String)"diff.unimportant.line.char.count");
        if (threshold == 0) {
            return DiffIterableUtil.diff(lines1, lines2, indicator);
        }
        Pair<List<Line>, TIntArrayList> bigLines1 = ByLine.getBigLines(lines1, threshold);
        Pair<List<Line>, TIntArrayList> bigLines2 = ByLine.getBigLines(lines2, threshold);
        FairDiffIterable changes = DiffIterableUtil.diff((List)bigLines1.first, (List)bigLines2.first, indicator);
        return new ChangeCorrector.SmartLineChangeCorrector((TIntArrayList)bigLines1.second, (TIntArrayList)bigLines2.second, lines1, lines2, changes, indicator).build();
    }

    @NotNull
    private static Pair<List<Line>, TIntArrayList> getBigLines(@NotNull List<Line> lines, int threshold) {
        ArrayList<Line> bigLines = new ArrayList<Line>(lines.size());
        TIntArrayList indexes = new TIntArrayList(lines.size());
        for (int i = 0; i < lines.size(); ++i) {
            Line line = lines.get(i);
            if (line.getNonSpaceChars() <= threshold) continue;
            bigLines.add(line);
            indexes.add(i);
        }
        return Pair.create(bigLines, (Object)indexes);
    }

    @NotNull
    private static FairDiffIterable expandRanges(@NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull FairDiffIterable iterable, @NotNull ProgressIndicator indicator) {
        ArrayList<Range> changes = new ArrayList<Range>();
        for (Range ch : iterable.iterateChanges()) {
            Range expanded = TrimUtil.expand(lines1, lines2, ch.start1, ch.start2, ch.end1, ch.end2);
            if (expanded.isEmpty()) continue;
            changes.add(expanded);
        }
        return DiffIterableUtil.fair(DiffIterableUtil.create(changes, lines1.size(), lines2.size()));
    }

    @NotNull
    private static List<Line> getLines(@NotNull CharSequence text, @NotNull ComparisonPolicy policy) {
        Line line;
        ArrayList<Line> lines = new ArrayList<Line>();
        int offset = 0;
        do {
            line = ByLine.createLine(text, offset, policy);
            lines.add(line);
            offset = line.getOffset2();
        } while (line.hasNewline());
        return lines;
    }

    @NotNull
    private static Line createLine(@NotNull CharSequence text, int offset, @NotNull ComparisonPolicy policy) {
        switch (policy) {
            case DEFAULT: {
                return Line.createDefault(text, offset);
            }
            case IGNORE_WHITESPACES: {
                return Line.createIgnore(text, offset);
            }
            case TRIM_WHITESPACES: {
                return Line.createTrim(text, offset);
            }
        }
        throw new IllegalArgumentException(policy.name());
    }

    @NotNull
    private static List<Line> convertToIgnoreWhitespace(@NotNull List<Line> original) {
        ArrayList<Line> result = new ArrayList<Line>(original.size());
        for (Line line : original) {
            result.add(Line.createIgnore(line.getOriginalText(), line.getOffset1()));
        }
        return result;
    }

    static class Line
    extends TextChunk {
        @NotNull
        private final Mode myMode;
        private final int myHash;
        private final int myNonSpaceChars;
        private final boolean myNewline;

        public Line(@NotNull CharSequence text, int offset1, int offset2, @NotNull Mode mode, int hash, int nonSpaceChars, boolean newline) {
            super(text, offset1, offset2);
            this.myMode = mode;
            this.myHash = hash;
            this.myNonSpaceChars = nonSpaceChars;
            this.myNewline = newline;
        }

        public boolean hasNewline() {
            return this.myNewline;
        }

        @Override
        @NotNull
        public CharSequence getContent() {
            return this.getOriginalText().subSequence(this.getOffset1(), this.getOffset2() - (this.myNewline ? 1 : 0));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Line line = (Line)o;
            assert (this.myMode == line.myMode);
            if (this.hashCode() != line.hashCode()) {
                return false;
            }
            switch (this.myMode) {
                case DEFAULT: {
                    return StringUtil.equals((CharSequence)this.getContent(), (CharSequence)line.getContent());
                }
                case TRIM: {
                    return StringUtil.equalsTrimWhitespaces((CharSequence)this.getContent(), (CharSequence)line.getContent());
                }
                case IGNORE: {
                    return StringUtil.equalsIgnoreWhitespaces((CharSequence)this.getContent(), (CharSequence)line.getContent());
                }
            }
            throw new IllegalArgumentException(this.myMode.toString());
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }

        public int getNonSpaceChars() {
            return this.myNonSpaceChars;
        }

        public static Line createDefault(@NotNull CharSequence text, int startOffset) {
            int offset;
            int len = text.length();
            int h = 0;
            int nonSpace = 0;
            boolean newline = false;
            for (offset = startOffset; offset < len; ++offset) {
                char c = text.charAt(offset);
                if (c == '\n') {
                    ++offset;
                    newline = true;
                    break;
                }
                if (!StringUtil.isWhiteSpace((char)c)) {
                    ++nonSpace;
                }
                h = 31 * h + c;
            }
            return new Line(text, startOffset, offset, Mode.DEFAULT, h, nonSpace, newline);
        }

        public static Line createIgnore(@NotNull CharSequence text, int startOffset) {
            int offset;
            int len = text.length();
            int h = 0;
            int nonSpace = 0;
            boolean newline = false;
            for (offset = startOffset; offset < len; ++offset) {
                char c = text.charAt(offset);
                if (c == '\n') {
                    ++offset;
                    newline = true;
                    break;
                }
                if (StringUtil.isWhiteSpace((char)c)) continue;
                ++nonSpace;
                h = 31 * h + c;
            }
            return new Line(text, startOffset, offset, Mode.IGNORE, h, nonSpace, newline);
        }

        public static Line createTrim(@NotNull CharSequence text, int startOffset) {
            int offset;
            int len = text.length();
            int nonSpace = 0;
            boolean newline = false;
            for (offset = startOffset; offset < len; ++offset) {
                char c = text.charAt(offset);
                if (c == '\n') {
                    ++offset;
                    newline = true;
                    break;
                }
                if (StringUtil.isWhiteSpace((char)c)) continue;
                ++nonSpace;
            }
            int h = Line.calcTrimHash(text, startOffset, offset);
            return new Line(text, startOffset, offset, Mode.TRIM, h, nonSpace, newline);
        }

        private static int calcTrimHash(@NotNull CharSequence text, int offset1, int offset2) {
            offset1 = TrimUtil.trimStart(text, offset1, offset2);
            offset2 = TrimUtil.trimEnd(text, offset1, offset2);
            return StringUtil.stringHashCode((CharSequence)text, (int)offset1, (int)offset2);
        }

        static enum Mode {
            DEFAULT,
            TRIM,
            IGNORE;

        }
    }
}

