/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ChangeCorrector;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ByChar {
    @NotNull
    public static FairDiffIterable compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        indicator.checkCanceled();
        int[] chars1 = ByChar.getAllChars(text1);
        int[] chars2 = ByChar.getAllChars(text2);
        return DiffIterableUtil.diff(chars1, chars2, indicator);
    }

    @NotNull
    public static FairDiffIterable compareTwoStep(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        indicator.checkCanceled();
        CharOffsets chars1 = ByChar.getNonSpaceChars(text1);
        CharOffsets chars2 = ByChar.getNonSpaceChars(text2);
        FairDiffIterable nonSpaceChanges = DiffIterableUtil.diff(chars1.characters, chars2.characters, indicator);
        return ByChar.matchAdjustmentSpaces(chars1, chars2, text1, text2, nonSpaceChanges, indicator);
    }

    @NotNull
    public static DiffIterable compareIgnoreWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        indicator.checkCanceled();
        CharOffsets chars1 = ByChar.getNonSpaceChars(text1);
        CharOffsets chars2 = ByChar.getNonSpaceChars(text2);
        FairDiffIterable changes = DiffIterableUtil.diff(chars1.characters, chars2.characters, indicator);
        return ByChar.matchAdjustmentSpacesIW(chars1, chars2, text1, text2, changes);
    }

    @NotNull
    public static FairDiffIterable comparePunctuation(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        indicator.checkCanceled();
        CharOffsets chars1 = ByChar.getPunctuationChars(text1);
        CharOffsets chars2 = ByChar.getPunctuationChars(text2);
        FairDiffIterable nonSpaceChanges = DiffIterableUtil.diff(chars1.characters, chars2.characters, indicator);
        return ByChar.transfer(chars1, chars2, text1, text2, nonSpaceChanges, indicator);
    }

    @NotNull
    private static FairDiffIterable transfer(@NotNull CharOffsets chars1, @NotNull CharOffsets chars2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes, @NotNull ProgressIndicator indicator) {
        DiffIterableUtil.ChangeBuilder builder = new DiffIterableUtil.ChangeBuilder(text1.length(), text2.length());
        for (Range range : changes.iterateUnchanged()) {
            int count = range.end1 - range.start1;
            for (int i = 0; i < count; ++i) {
                int offset1 = chars1.offsets[range.start1 + i];
                int offset2 = chars2.offsets[range.start2 + i];
                builder.markEqual(offset1, offset2);
            }
        }
        return DiffIterableUtil.fair(builder.finish());
    }

    @NotNull
    private static FairDiffIterable matchAdjustmentSpaces(@NotNull CharOffsets chars1, @NotNull CharOffsets chars2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes, @NotNull ProgressIndicator indicator) {
        return new ChangeCorrector.DefaultCharChangeCorrector(chars1, chars2, text1, text2, changes, indicator).build();
    }

    @NotNull
    private static DiffIterable matchAdjustmentSpacesIW(@NotNull CharOffsets chars1, @NotNull CharOffsets chars2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Range ch : changes.iterateChanges()) {
            int startOffset2;
            int endOffset2;
            int startOffset1;
            int endOffset1;
            if (ch.start1 == ch.end1) {
                startOffset1 = endOffset1 = ByChar.expandForwardW(chars1, chars2, text1, text2, ch, true);
            } else {
                startOffset1 = chars1.offsets[ch.start1];
                endOffset1 = chars1.offsets[ch.end1 - 1] + 1;
            }
            if (ch.start2 == ch.end2) {
                startOffset2 = endOffset2 = ByChar.expandForwardW(chars1, chars2, text1, text2, ch, false);
            } else {
                startOffset2 = chars2.offsets[ch.start2];
                endOffset2 = chars2.offsets[ch.end2 - 1] + 1;
            }
            ranges.add(new Range(startOffset1, endOffset1, startOffset2, endOffset2));
        }
        return DiffIterableUtil.create(ranges, text1.length(), text2.length());
    }

    private static int expandForwardW(@NotNull CharOffsets chars1, @NotNull CharOffsets chars2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull Range ch, boolean left) {
        int offset1 = ch.start1 == 0 ? 0 : chars1.offsets[ch.start1 - 1] + 1;
        int offset2 = ch.start2 == 0 ? 0 : chars2.offsets[ch.start2 - 1] + 1;
        int start = left ? offset1 : offset2;
        return start + TrimUtil.expandForwardW(text1, text2, offset1, offset2, text1.length(), text2.length());
    }

    @NotNull
    private static int[] getAllChars(@NotNull CharSequence text) {
        int[] chars = new int[text.length()];
        for (int i = 0; i < text.length(); ++i) {
            chars[i] = text.charAt(i);
        }
        return chars;
    }

    @NotNull
    private static CharOffsets getNonSpaceChars(@NotNull CharSequence text) {
        TIntArrayList chars = new TIntArrayList(text.length());
        TIntArrayList offsets = new TIntArrayList(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (StringUtil.isWhiteSpace((char)c)) continue;
            chars.add((int)c);
            offsets.add(i);
        }
        return new CharOffsets(chars.toNativeArray(), offsets.toNativeArray());
    }

    @NotNull
    private static CharOffsets getPunctuationChars(@NotNull CharSequence text) {
        TIntArrayList chars = new TIntArrayList(text.length());
        TIntArrayList offsets = new TIntArrayList(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!TrimUtil.isPunctuation(c)) continue;
            chars.add((int)c);
            offsets.add(i);
        }
        return new CharOffsets(chars.toNativeArray(), offsets.toNativeArray());
    }

    static class CharOffsets {
        public final int[] characters;
        public final int[] offsets;

        public CharOffsets(int[] characters, int[] offsets) {
            this.characters = characters;
            this.offsets = offsets;
        }
    }
}

