/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.applications;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.applications.ApplicationStarterBase;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffApplication
extends ApplicationStarterBase {
    @Override
    protected boolean checkArguments(@NotNull String[] args) {
        return (args.length == 3 || args.length == 4) && "diff".equals(args[0]);
    }

    public String getCommandName() {
        return "diff";
    }

    @Override
    @NotNull
    public String getUsageMessage() {
        String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
        return DiffBundle.message((String)"diff.application.usage.parameters.and.description", (Object[])new Object[]{scriptName});
    }

    @Override
    public void processCommand(@NotNull String[] args, @Nullable String currentDirectory) throws Exception {
        Project project2 = this.getProject();
        List<String> filePaths = Arrays.asList(args).subList(1, args.length);
        List<VirtualFile> files = DiffApplication.findFiles(filePaths, currentDirectory);
        ContentDiffRequest request = files.size() == 3 ? DiffRequestFactory.getInstance().createFromFiles(project2, files.get(0), files.get(2), files.get(1)) : DiffRequestFactory.getInstance().createFromFiles(project2, files.get(0), files.get(1));
        DiffManagerEx.getInstance().showDiffBuiltin(project2, (DiffRequest)request, DiffDialogHints.MODAL);
    }
}

