/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions.impl;

import com.intellij.diff.DiffContext;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInEditorAction
extends EditSourceAction
implements DumbAware {
    public static DataKey<OpenInEditorAction> KEY = DataKey.create((String)"DiffOpenInEditorAction");
    @Nullable
    private final Runnable myAfterRunnable;

    public OpenInEditorAction(@Nullable Runnable afterRunnable) {
        EmptyAction.setupAction((AnAction)this, (String)"EditSource", null);
        this.myAfterRunnable = afterRunnable;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        DiffRequest request = (DiffRequest)e.getData(DiffDataKeys.DIFF_REQUEST);
        DiffContext context = (DiffContext)e.getData(DiffDataKeys.DIFF_CONTEXT);
        if (DiffUtil.isUserDataFlagSet((Key<Boolean>)DiffUserDataKeys.GO_TO_SOURCE_DISABLE, new UserDataHolder[]{request, context})) {
            e.getPresentation().setVisible(false);
            e.getPresentation().setEnabled(false);
        }
        if (e.getProject() == null) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(false);
            return;
        }
        if (OpenInEditorAction.getDescriptor(e.getDataContext()) == null) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2 = e.getProject();
        assert (project2 != null);
        OpenFileDescriptor descriptor = OpenInEditorAction.getDescriptor(e.getDataContext());
        assert (descriptor != null);
        this.openEditor(project2, descriptor);
    }

    public void openEditor(@NotNull Project project2, @NotNull OpenFileDescriptor descriptor) {
        FileEditorManager.getInstance((Project)project2).openTextEditor(descriptor, true);
        if (this.myAfterRunnable != null) {
            this.myAfterRunnable.run();
        }
    }

    @Nullable
    public static OpenFileDescriptor getDescriptor(@NotNull DataContext context) {
        return (OpenFileDescriptor)DiffDataKeys.OPEN_FILE_DESCRIPTOR.getData(context);
    }
}

