/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class NavigationContextChecker {
    @NotNull
    private final Iterator<Pair<Integer, CharSequence>> myChangedLinesIterator;
    @NotNull
    private final DiffNavigationContext myContext;

    public NavigationContextChecker(@NotNull Iterator<Pair<Integer, CharSequence>> changedLinesIterator, @NotNull DiffNavigationContext context) {
        this.myChangedLinesIterator = changedLinesIterator;
        this.myContext = context;
    }

    public int contextMatchCheck() {
        Pair<Integer, CharSequence> pair;
        Iterator iterator = this.myContext.getPreviousLinesIterable().iterator();
        if (iterator.hasNext()) {
            CharSequence contextLine = (CharSequence)iterator.next();
            while (this.myChangedLinesIterator.hasNext()) {
                pair = this.myChangedLinesIterator.next();
                if (!StringUtil.equalsTrimWhitespaces((CharSequence)((CharSequence)pair.getSecond()), (CharSequence)contextLine)) continue;
                if (!iterator.hasNext()) break;
                contextLine = (CharSequence)iterator.next();
            }
        }
        if (iterator.hasNext()) {
            return -1;
        }
        if (!this.myChangedLinesIterator.hasNext()) {
            return -1;
        }
        String targetLine = this.myContext.getTargetString();
        while (this.myChangedLinesIterator.hasNext()) {
            pair = this.myChangedLinesIterator.next();
            if (!StringUtil.equalsTrimWhitespaces((CharSequence)((CharSequence)pair.getSecond()), (CharSequence)targetLine)) continue;
            return (Integer)pair.getFirst();
        }
        return -1;
    }
}

