/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.actions.BaseShowDiffAction;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareFilesAction
extends BaseShowDiffAction {
    public static final DataKey<DiffRequest> DIFF_REQUEST = DataKey.create((String)"CompareFilesAction.DiffRequest");
    public static final String LAST_USED_FILE_KEY = "two.files.diff.last.used.file";
    public static final String LAST_USED_FOLDER_KEY = "two.files.diff.last.used.folder";

    @Override
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        String text = "Compare Files";
        if (files != null && files.length == 1) {
            text = "Compare With...";
        } else if (files != null && files.length == 2) {
            Type type2;
            Type type1 = CompareFilesAction.getType(files[0]);
            if (type1 != (type2 = CompareFilesAction.getType(files[1]))) {
                text = "Compare";
            } else {
                switch (type1) {
                    case FILE: {
                        text = "Compare Files";
                        break;
                    }
                    case DIRECTORY: {
                        text = "Compare Directories";
                        break;
                    }
                    case ARCHIVE: {
                        text = "Compare Archives";
                    }
                }
            }
        }
        e.getPresentation().setText(text);
    }

    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        DiffRequest request = (DiffRequest)e.getData(DIFF_REQUEST);
        if (request != null) {
            return true;
        }
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files == null) {
            return false;
        }
        if (files.length == 1) {
            return files[0].isValid();
        }
        if (files.length == 2) {
            return files[0].isValid() && files[1].isValid();
        }
        return false;
    }

    @Override
    @Nullable
    protected DiffRequest getDiffRequest(@NotNull AnActionEvent e) {
        Project project2 = e.getProject();
        DiffRequest diffRequest = (DiffRequest)e.getData(DIFF_REQUEST);
        if (diffRequest != null) {
            return diffRequest;
        }
        VirtualFile[] data = (VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (data.length == 1) {
            VirtualFile otherFile = CompareFilesAction.getOtherFile(project2, data[0]);
            if (otherFile == null) {
                return null;
            }
            if (!data[0].isValid()) {
                return null;
            }
            return DiffRequestFactory.getInstance().createFromFiles(project2, data[0], otherFile);
        }
        return DiffRequestFactory.getInstance().createFromFiles(project2, data[0], data[1]);
    }

    @Nullable
    private static VirtualFile getOtherFile(@Nullable Project project2, @NotNull VirtualFile file2) {
        String key;
        FileChooserDescriptor descriptor;
        Type type = CompareFilesAction.getType(file2);
        if (type == Type.DIRECTORY || type == Type.ARCHIVE) {
            descriptor = new FileChooserDescriptor(false, true, true, true, true, false);
            key = LAST_USED_FOLDER_KEY;
        } else {
            descriptor = new FileChooserDescriptor(true, false, false, true, true, false);
            key = LAST_USED_FILE_KEY;
        }
        VirtualFile selectedFile = CompareFilesAction.getDefaultSelection(project2, key, file2);
        VirtualFile otherFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project2, (VirtualFile)selectedFile);
        if (otherFile != null) {
            CompareFilesAction.updateDefaultSelection(project2, key, otherFile);
        }
        return otherFile;
    }

    @NotNull
    private static VirtualFile getDefaultSelection(@Nullable Project project2, @NotNull String key, @NotNull VirtualFile file2) {
        if (project2 == null) {
            return file2;
        }
        String path = PropertiesComponent.getInstance((Project)project2).getValue(key);
        if (path == null) {
            return file2;
        }
        VirtualFile lastSelection = LocalFileSystem.getInstance().findFileByPath(path);
        return lastSelection != null ? lastSelection : file2;
    }

    private static void updateDefaultSelection(@Nullable Project project2, @NotNull String key, @NotNull VirtualFile file2) {
        if (project2 == null) {
            return;
        }
        PropertiesComponent.getInstance((Project)project2).setValue(key, file2.getPath());
    }

    @NotNull
    private static Type getType(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return Type.FILE;
        }
        if (file2.isDirectory()) {
            return Type.DIRECTORY;
        }
        if (file2.getFileType() instanceof ArchiveFileType) {
            return Type.ARCHIVE;
        }
        return Type.FILE;
    }

    private static enum Type {
        FILE,
        DIRECTORY,
        ARCHIVE;

    }
}

