/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContentImpl;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileAwareDocumentContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.contents.FileContentImpl;
import com.intellij.diff.contents.FileDocumentContentImpl;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.BinaryLightVirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathUtil;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffContentFactoryImpl
extends DiffContentFactory {
    public static final Logger LOG = Logger.getInstance(DiffContentFactoryImpl.class);

    @NotNull
    public static DiffContentFactoryImpl getInstanceImpl() {
        return (DiffContentFactoryImpl)DiffContentFactory.getInstance();
    }

    @NotNull
    public EmptyContent createEmpty() {
        return new EmptyContent();
    }

    @NotNull
    public DocumentContent create(@NotNull String text) {
        return this.create(text, (FileType)null);
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable FileType type) {
        return this.create(text, type, true);
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable FileType type, boolean respectLineSeparators) {
        return DiffContentFactoryImpl.createImpl(text, type, null, null, respectLineSeparators, true);
    }

    @NotNull
    public DocumentContent create(@NotNull String text, @Nullable VirtualFile highlightFile) {
        return DiffContentFactoryImpl.createImpl(text, highlightFile != null ? highlightFile.getFileType() : null, highlightFile, null, true, true);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull Document document) {
        return this.create(project2, document, (FileType)null);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull Document document, @Nullable FileType fileType) {
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 == null) {
            return new DocumentContentImpl(document, fileType, null, null, null);
        }
        return this.create(project2, document, file2);
    }

    @NotNull
    public DocumentContent create(@Nullable Project project2, @NotNull Document document, @Nullable VirtualFile file2) {
        if (file2 != null) {
            return new FileDocumentContentImpl(project2, document, file2);
        }
        return new DocumentContentImpl(document);
    }

    @NotNull
    public DiffContent create(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2.isDirectory()) {
            return new DirectoryContentImpl(project2, file2);
        }
        DocumentContent content = this.createDocument(project2, file2);
        if (content != null) {
            return content;
        }
        return new FileContentImpl(project2, file2);
    }

    @Nullable
    public DocumentContent createDocument(@Nullable Project project2, final @NotNull VirtualFile file2) {
        if (file2.isDirectory()) {
            return null;
        }
        Document document = (Document)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Document>(){

            public Document compute() {
                return FileDocumentManager.getInstance().getDocument(file2);
            }
        });
        if (document == null) {
            return null;
        }
        return new FileDocumentContentImpl(project2, document, file2);
    }

    @Nullable
    public FileContent createFile(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2.isDirectory()) {
            return null;
        }
        return (FileContent)this.create(project2, file2);
    }

    @NotNull
    public DiffContent createClipboardContent() {
        return this.createClipboardContent(null);
    }

    @NotNull
    public DocumentContent createClipboardContent(@Nullable DocumentContent mainContent) {
        String text = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        FileType type = mainContent != null ? mainContent.getContentType() : null;
        VirtualFile highlightFile = mainContent != null ? mainContent.getHighlightFile() : null;
        return DiffContentFactoryImpl.createImpl(StringUtil.notNullize((String)text), type, highlightFile, null, true, false);
    }

    @NotNull
    private static DocumentContent createImpl(@NotNull String text, @Nullable FileType type, @Nullable VirtualFile highlightFile, @Nullable Charset charset, boolean respectLineSeparators, boolean readOnly) {
        LineSeparator separator = respectLineSeparators ? StringUtil.detectSeparators((CharSequence)text) : null;
        Document document = EditorFactory.getInstance().createDocument((CharSequence)StringUtil.convertLineSeparators((String)text));
        if (readOnly) {
            document.setReadOnly(true);
        }
        return new DocumentContentImpl(document, type, highlightFile, separator, charset);
    }

    @NotNull
    public DiffContent createFromBytes(@Nullable Project project2, @NotNull FilePath filePath, @NotNull byte[] content) throws IOException {
        if (filePath.getFileType().isBinary()) {
            return DiffContentFactory.getInstance().createBinary(project2, filePath.getName(), filePath.getFileType(), content);
        }
        return FileAwareDocumentContent.create(project2, content, filePath);
    }

    @NotNull
    public DiffContent createFromBytes(@Nullable Project project2, @NotNull VirtualFile highlightFile, @NotNull byte[] content) throws IOException {
        if (highlightFile.getFileType().isBinary()) {
            return DiffContentFactory.getInstance().createBinary(project2, highlightFile.getName(), highlightFile.getFileType(), content);
        }
        return FileAwareDocumentContent.create(project2, content, highlightFile);
    }

    @NotNull
    public DiffContent createBinary(@Nullable Project project2, @NotNull String name, @NotNull FileType type, @NotNull byte[] content) throws IOException {
        BinaryLightVirtualFile file2;
        boolean useTemporalFile;
        boolean bl = useTemporalFile = type instanceof ArchiveFileType || BinaryFileTypeDecompilers.INSTANCE.forFileType(type) != null;
        if (useTemporalFile) {
            file2 = type.getDefaultExtension().isEmpty() ? DiffContentFactoryImpl.createTemporalFile(project2, "tmp_", "_" + name, content) : DiffContentFactoryImpl.createTemporalFile(project2, name + "_", "." + type.getDefaultExtension(), content);
        } else {
            file2 = new BinaryLightVirtualFile(name, type, content);
            file2.setWritable(false);
        }
        return this.create(project2, (VirtualFile)file2);
    }

    @NotNull
    public static VirtualFile createTemporalFile(@Nullable Project project2, @NotNull String prefix, @NotNull String suffix, @NotNull byte[] content) throws IOException {
        VirtualFile file2;
        File tempFile2 = FileUtil.createTempFile((String)PathUtil.suggestFileName((String)(prefix + "_"), (boolean)true, (boolean)false), (String)PathUtil.suggestFileName((String)("_" + suffix), (boolean)true, (boolean)false), (boolean)true);
        if (content.length != 0) {
            FileUtil.writeToFile((File)tempFile2, (byte[])content);
        }
        if (!tempFile2.setWritable(false, false)) {
            LOG.warn("Can't set writable attribute of temporal file");
        }
        if ((file2 = VfsUtil.findFileByIoFile((File)tempFile2, (boolean)true)) == null) {
            throw new IOException("Can't create temp file for revision content");
        }
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{file2});
        return file2;
    }
}

