/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.diff.Diff;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Block {
    private static final Logger LOG = Logger.getInstance(Block.class);
    @NotNull
    private final String[] mySource;
    private final int myStart;
    private final int myEnd;

    public Block(@NotNull String source, int start, int end) {
        this(LineTokenizer.tokenize((CharSequence)source, (boolean)false, (boolean)false), start, end);
    }

    public Block(@NotNull String[] source, int start, int end) {
        this.mySource = source;
        this.myStart = Math.min(Math.max(0, start), source.length);
        this.myEnd = Math.min(Math.max(this.myStart, end), source.length);
    }

    @NotNull
    public Block createPreviousBlock(@NotNull String prevContent) {
        return this.createPreviousBlock(LineTokenizer.tokenize((CharSequence)prevContent, (boolean)false, (boolean)false));
    }

    @NotNull
    public Block createPreviousBlock(@NotNull String[] prevContent) {
        int start = -1;
        int end = -1;
        int shift = 0;
        Diff.Change change = Diff.buildChangesSomehow((Object[])prevContent, (Object[])this.getSource());
        while (change != null) {
            int startLine1 = change.line0;
            int startLine2 = change.line1;
            int endLine1 = startLine1 + change.deleted;
            int endLine2 = startLine2 + change.inserted;
            if (Math.max(this.myStart, startLine2) < Math.min(this.myEnd, endLine2)) {
                if (startLine2 <= this.myStart) {
                    start = startLine1;
                }
                if (endLine2 > this.myEnd) {
                    end = endLine1;
                }
            }
            if (startLine2 > this.myStart) {
                if (start == -1) {
                    start = this.myStart - shift;
                }
                if (end == -1 && startLine2 >= this.myEnd) {
                    end = this.myEnd - shift;
                }
            }
            shift += change.inserted - change.deleted;
            change = change.link;
        }
        if (start == -1) {
            start = this.myStart - shift;
        }
        if (end == -1) {
            end = this.myEnd - shift;
        }
        if (start < 0 || end > prevContent.length || end < start) {
            LOG.error("Invalid block range: [" + start + ", " + end + "); length - " + prevContent.length);
        }
        return new Block(prevContent, start, end);
    }

    @NotNull
    public String getBlockContent() {
        return StringUtil.join(this.getLines(), (String)"\n");
    }

    @NotNull
    public List<String> getLines() {
        return Arrays.asList(this.mySource).subList(this.myStart, this.myEnd);
    }

    public int hashCode() {
        return Arrays.hashCode(this.mySource) ^ this.myStart ^ this.myEnd;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Block)) {
            return false;
        }
        Block other = (Block)object;
        return Arrays.equals(this.mySource, other.mySource) && this.myStart == other.myStart && this.myEnd == other.myEnd;
    }

    public int getStart() {
        return this.myStart;
    }

    public int getEnd() {
        return this.myEnd;
    }

    @NotNull
    public String[] getSource() {
        return this.mySource;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        this.appendLines(result, 0, this.myStart);
        result.append("<-----------------------------\n");
        this.appendLines(result, this.myStart, this.myEnd);
        result.append("----------------------------->\n");
        this.appendLines(result, this.myEnd, this.mySource.length);
        return result.toString();
    }

    private void appendLines(@NotNull StringBuilder result, int from, int to) {
        for (int i = from; i < to; ++i) {
            result.append(this.mySource[i]);
            result.append("\n");
        }
    }
}

