/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.logging.IndependentLogFilter;
import com.intellij.diagnostic.logging.LogConsolePreferences;
import com.intellij.diagnostic.logging.LogFilter;
import com.intellij.diagnostic.logging.LogFilterListener;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DefaultLogFilterModel
extends LogFilterModel {
    private final Project myProject;
    private boolean myCheckStandardFilters = true;
    private String myPrevType = null;

    public DefaultLogFilterModel(Project project2) {
        this.myProject = project2;
    }

    protected LogConsolePreferences getPreferences() {
        return LogConsolePreferences.getInstance((Project)this.myProject);
    }

    public boolean isCheckStandartFilters() {
        return this.myCheckStandardFilters;
    }

    public void setCheckStandartFilters(boolean checkStandardFilters) {
        this.myCheckStandardFilters = checkStandardFilters;
    }

    public void updateCustomFilter(String filter) {
        super.updateCustomFilter(filter);
        this.getPreferences().updateCustomFilter(filter);
    }

    public String getCustomFilter() {
        return this.getPreferences().CUSTOM_FILTER;
    }

    public void addFilterListener(LogFilterListener listener2) {
        this.getPreferences().addFilterListener(listener2);
    }

    public boolean isApplicable(String line) {
        if (!super.isApplicable(line)) {
            return false;
        }
        return this.getPreferences().isApplicable(line, this.myPrevType, this.myCheckStandardFilters);
    }

    public void removeFilterListener(LogFilterListener listener2) {
        this.getPreferences().removeFilterListener(listener2);
    }

    public List<LogFilter> getLogFilters() {
        LogConsolePreferences preferences = this.getPreferences();
        ArrayList<LogFilter> filters = new ArrayList<LogFilter>();
        if (this.myCheckStandardFilters) {
            this.addStandardFilters(filters, preferences);
        }
        filters.addAll(preferences.getRegisteredLogFilters());
        return filters;
    }

    private void addStandardFilters(ArrayList<LogFilter> filters, final LogConsolePreferences preferences) {
        filters.add((LogFilter)new MyFilter(DiagnosticBundle.message("log.console.filter.show.all", new Object[0]), preferences){

            public void selectFilter() {
                preferences.FILTER_ERRORS = false;
                preferences.FILTER_INFO = false;
                preferences.FILTER_WARNINGS = false;
                preferences.FILTER_DEBUG = false;
            }

            public boolean isSelected() {
                return !preferences.FILTER_ERRORS && !preferences.FILTER_INFO && !preferences.FILTER_WARNINGS && !preferences.FILTER_DEBUG;
            }
        });
        filters.add((LogFilter)new MyFilter(DiagnosticBundle.message("log.console.filter.show.errors.warnings.and.infos", new Object[0]), preferences){

            public void selectFilter() {
                preferences.FILTER_ERRORS = false;
                preferences.FILTER_INFO = false;
                preferences.FILTER_WARNINGS = false;
                preferences.FILTER_DEBUG = true;
            }

            public boolean isSelected() {
                return !preferences.FILTER_ERRORS && !preferences.FILTER_INFO && !preferences.FILTER_WARNINGS && preferences.FILTER_DEBUG;
            }
        });
        filters.add((LogFilter)new MyFilter(DiagnosticBundle.message("log.console.filter.show.errors.and.warnings", new Object[0]), preferences){

            public void selectFilter() {
                preferences.FILTER_ERRORS = false;
                preferences.FILTER_INFO = true;
                preferences.FILTER_WARNINGS = false;
                preferences.FILTER_DEBUG = true;
            }

            public boolean isSelected() {
                return !preferences.FILTER_ERRORS && preferences.FILTER_INFO && !preferences.FILTER_WARNINGS && preferences.FILTER_DEBUG;
            }
        });
        filters.add((LogFilter)new MyFilter(DiagnosticBundle.message("log.console.filter.show.errors", new Object[0]), preferences){

            public void selectFilter() {
                preferences.FILTER_ERRORS = false;
                preferences.FILTER_INFO = true;
                preferences.FILTER_WARNINGS = true;
                preferences.FILTER_DEBUG = true;
            }

            public boolean isSelected() {
                return !preferences.FILTER_ERRORS && preferences.FILTER_INFO && preferences.FILTER_WARNINGS && preferences.FILTER_DEBUG;
            }
        });
    }

    public boolean isFilterSelected(LogFilter filter) {
        return this.getPreferences().isFilterSelected(filter);
    }

    public void selectFilter(LogFilter filter) {
        this.getPreferences().selectOnlyFilter(filter);
    }

    @NotNull
    public LogFilterModel.MyProcessingResult processLine(String line) {
        Key contentType;
        String type = LogConsolePreferences.getType((String)line);
        Key key = type != null ? LogConsolePreferences.getProcessOutputTypes((String)type) : (contentType = "ERROR".equals(this.myPrevType) ? ProcessOutputTypes.STDERR : ProcessOutputTypes.STDOUT);
        if (type != null) {
            this.myPrevType = type;
        }
        boolean applicable = this.isApplicable(line);
        return new LogFilterModel.MyProcessingResult(contentType, applicable, null);
    }

    private abstract class MyFilter
    extends IndependentLogFilter {
        private final LogConsolePreferences myPreferences;

        protected MyFilter(String name, LogConsolePreferences preferences) {
            super(name);
            this.myPreferences = preferences;
        }

        public boolean isAcceptable(String line) {
            return this.myPreferences.isApplicable(line, DefaultLogFilterModel.this.myPrevType, DefaultLogFilterModel.this.myCheckStandardFilters);
        }
    }
}

