/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VMOptions {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.diagnostic.VMOptions");
    private static String ourTestPath;

    public static int readXmx() {
        return VMOptions.readOption(MemoryKind.HEAP, true);
    }

    public static int readMaxPermGen() {
        return VMOptions.readOption(MemoryKind.PERM_GEN, true);
    }

    public static int readCodeCache() {
        return VMOptions.readOption(MemoryKind.CODE_CACHE, true);
    }

    public static void writeXmx(int value) {
        VMOptions.writeOption(MemoryKind.HEAP, value);
    }

    public static void writeMaxPermGen(int value) {
        VMOptions.writeOption(MemoryKind.PERM_GEN, value);
    }

    public static void writeCodeCache(int value) {
        VMOptions.writeOption(MemoryKind.CODE_CACHE, value);
    }

    public static int readOption(MemoryKind kind, boolean effective) {
        List<String> arguments;
        if (ourTestPath != null) {
            try {
                String content = FileUtil.loadFile((File)new File(ourTestPath));
                arguments = Collections.singletonList(content);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (effective) {
            arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        } else {
            File file2 = VMOptions.getWriteFile();
            if (file2 == null || !file2.exists()) {
                return -1;
            }
            try {
                String content = FileUtil.loadFile((File)file2);
                arguments = Collections.singletonList(content);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                return -1;
            }
        }
        for (String argument : arguments) {
            Matcher m = kind.pattern.matcher(argument);
            if (!m.find()) continue;
            try {
                int value = Integer.parseInt(m.group(1));
                double multiplier = VMOptions.parseUnit(m.group(2));
                return (int)((double)value * multiplier);
            }
            catch (NumberFormatException e) {
                LOG.info((Throwable)e);
                break;
            }
        }
        return -1;
    }

    private static double parseUnit(String unitString) {
        if (StringUtil.startsWithIgnoreCase((String)unitString, (String)"k")) {
            return 9.765625E-4;
        }
        if (StringUtil.startsWithIgnoreCase((String)unitString, (String)"g")) {
            return 1024.0;
        }
        return 1.0;
    }

    private static void writeOption(MemoryKind option, int value) {
        File file2 = VMOptions.getWriteFile();
        if (file2 == null) {
            return;
        }
        try {
            String content = file2.exists() ? FileUtil.loadFile((File)file2) : VMOptions.read();
            String optionValue = option.option + value + "m";
            if (!StringUtil.isEmptyOrSpaces((String)content)) {
                Matcher m = option.pattern.matcher(content);
                if (m.find()) {
                    StringBuffer b = new StringBuffer();
                    m.appendReplacement(b, Matcher.quoteReplacement(optionValue));
                    m.appendTail(b);
                    content = b.toString();
                } else {
                    content = StringUtil.trimTrailing((String)content) + SystemProperties.getLineSeparator() + optionValue;
                }
            } else {
                content = optionValue;
            }
            if (file2.exists()) {
                FileUtil.setReadOnlyAttribute((String)file2.getPath(), (boolean)false);
            } else {
                FileUtil.ensureExists((File)file2.getParentFile());
            }
            FileUtil.writeToFile((File)file2, (String)content);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Nullable
    public static String read() {
        try {
            File newFile = VMOptions.getWriteFile();
            if (newFile != null && newFile.exists()) {
                return FileUtil.loadFile((File)newFile);
            }
            String vmOptionsFile = System.getProperty("jb.vmOptionsFile");
            if (vmOptionsFile != null) {
                return FileUtil.loadFile((File)new File(vmOptionsFile));
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return null;
    }

    @Nullable
    public static File getWriteFile() {
        if (ourTestPath != null) {
            return new File(ourTestPath);
        }
        String location = PathManager.getCustomOptionsDirectory();
        if (location == null) {
            LOG.warn("custom options directory not specified (idea.paths.selector not set?)");
            return null;
        }
        return new File(location, VMOptions.getCustomFileName());
    }

    @Nullable
    public static File getCustomFile(boolean ifExists) {
        File f = new File(VMOptions.doGetSettingsFilePath(true)).getAbsoluteFile();
        if (!f.exists()) {
            if (ifExists) {
                return null;
            }
            return f;
        }
        String location = PathManager.getCustomOptionsDirectory();
        if (location == null) {
            LOG.warn("custom options directory not specified (idea.paths.selector not set?)");
            return null;
        }
        return new File(location, VMOptions.getCustomFileName());
    }

    @NotNull
    private static String doGetSettingsFilePath(boolean customLocation) {
        String[] optionsFiles;
        String vmOptionsFile;
        if (customLocation && !StringUtil.isEmptyOrSpaces((String)(vmOptionsFile = System.getProperty("jb.vmOptionsFile"))) && (optionsFiles = vmOptionsFile.split(",")).length > 1) {
            LOG.debug("doGetSettingsFilePath(true): " + optionsFiles[optionsFiles.length - 1]);
            return optionsFiles[optionsFiles.length - 1];
        }
        String filePath = (customLocation ? PathManager.getConfigPath() : PathManager.getBinPath()) + File.separatorChar + VMOptions.getCustomFileName();
        LOG.debug("doGetSettingsFilePath(" + customLocation + "): " + filePath);
        return filePath;
    }

    @NotNull
    public static String getCustomFileName() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(ourTestPath != null ? "test" : ApplicationNamesInfo.getInstance().getProductName().toLowerCase(Locale.US));
        if (SystemInfo.is64Bit && !SystemInfo.isMac) {
            sb.append("64");
        }
        if (SystemInfo.isWindows) {
            sb.append(".exe");
        }
        sb.append(".vmoptions");
        return sb.toString();
    }

    static void setTestFile(String path) {
        ourTestPath = path;
    }

    static void clearTestFile() {
        ourTestPath = null;
    }

    public static enum MemoryKind {
        HEAP("Xmx", ""),
        PERM_GEN("XX:MaxPermSize", "="),
        CODE_CACHE("XX:ReservedCodeCacheSize", "=");

        public final String optionName;
        public final String option;
        public final Pattern pattern;

        private MemoryKind(String name, String separator) {
            this.optionName = name;
            this.option = "-" + name + separator;
            this.pattern = Pattern.compile(this.option + "(\\d*)([a-zA-Z]*)");
        }
    }
}

