/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.errordialog.DisablePluginWarningDialog;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.containers.hash.HashSet;
import java.util.Set;
import javax.swing.JRootPane;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

class PluginErrorNotifications {
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Plugin Errors", NotificationDisplayType.STICKY_BALLOON, true);
    private static final Set<String> myPluginsShowing = new HashSet();

    private PluginErrorNotifications() {
    }

    static void maybeNotifyUi(@NotNull LogMessage message) {
        final PluginId pluginId = IdeErrorsDialog.findPluginId(message.getThrowable());
        if (pluginId == null || myPluginsShowing.contains(pluginId.getIdString()) || PluginManager.getPlugin(pluginId).isBundled()) {
            return;
        }
        myPluginsShowing.add(pluginId.getIdString());
        String title = "Plugin Error";
        String notificationText = String.format("%s threw an uncaught %s. <a href='xxx'>Disable Plugin</a>", PluginManager.getPlugin(pluginId).getName(), message.getThrowable().getClass().getSimpleName());
        NotificationListener listener2 = new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                JRootPane rootPane = WindowManager.getInstance().findVisibleFrame().getRootPane();
                DisablePluginWarningDialog.disablePlugin(pluginId, rootPane);
            }
        };
        Notification notification = new Notification(NOTIFICATION_GROUP.getDisplayId(), title, notificationText, NotificationType.ERROR, listener2){

            public void expire() {
                super.expire();
                myPluginsShowing.remove(pluginId.getIdString());
            }
        };
        notification.notify(null);
        message.setNotification(notification);
    }
}

