/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.Developer;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.io.HttpRequests;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

class DevelopersLoader {
    private static final String DEVELOPERS_LIST_URL = "http://ea-engine.labs.intellij.net/data?category=developers";
    public static final int TIMEOUT = 1000;

    private DevelopersLoader() {
    }

    public static Collection<Developer> fetchDevelopers(final @NotNull ProgressIndicator indicator) throws IOException {
        return (Collection)HttpRequests.request((String)DEVELOPERS_LIST_URL).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Collection<Developer>>(){

            public Collection<Developer> process(@NotNull HttpRequests.Request request) throws IOException {
                String line;
                LinkedList<Developer> developers = new LinkedList<Developer>();
                developers.add(Developer.NULL);
                BufferedReader reader = request.getReader();
                while ((line = reader.readLine()) != null) {
                    int i = line.indexOf(9);
                    if (i == -1) {
                        throw new IOException("Protocol error");
                    }
                    int id = Integer.parseInt(line.substring(0, i));
                    String name = line.substring(i + 1);
                    developers.add(new Developer(id, name));
                    indicator.checkCanceled();
                }
                return developers;
            }
        });
    }
}

