/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable.editors;

import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanEditor
extends PropertyEditor {
    protected final JCheckBox myCheckBox = new JCheckBox();
    private boolean myInsideChange;

    public BooleanEditor() {
        this.myCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BooleanEditor.this.myInsideChange) {
                    BooleanEditor.this.fireValueCommitted(false, true);
                }
            }
        });
    }

    @Override
    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this.myCheckBox);
    }

    @Override
    public Object getValue() throws Exception {
        return this.myCheckBox.isSelected();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myCheckBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public JComponent getComponent(@Nullable PropertiesContainer container, @Nullable PropertyContext context, Object value, @Nullable InplaceContext inplaceContext) {
        try {
            this.myInsideChange = true;
            this.myCheckBox.setBackground(UIUtil.getTableBackground());
            this.myCheckBox.setSelected(value != null && (Boolean)value != false);
            JCheckBox jCheckBox = this.myCheckBox;
            return jCheckBox;
        }
        finally {
            this.myInsideChange = false;
        }
    }
}

