/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable.actions;

import com.intellij.designer.DesignerBundle;
import com.intellij.designer.model.Property;
import com.intellij.designer.propertyTable.RadPropertyTable;
import com.intellij.designer.propertyTable.actions.IPropertyTableAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;

public class RestoreDefault
extends AnAction
implements IPropertyTableAction {
    private final RadPropertyTable myTable;

    public RestoreDefault(RadPropertyTable table) {
        this.myTable = table;
        Presentation presentation = this.getTemplatePresentation();
        String text = DesignerBundle.message("designer.properties.restore_default", new Object[0]);
        presentation.setText(text);
        presentation.setDescription(text);
        presentation.setIcon(AllIcons.General.Reset);
    }

    public void update(AnActionEvent e) {
        RestoreDefault.setEnabled(this.myTable, e.getPresentation());
    }

    @Override
    public void update() {
        RestoreDefault.setEnabled(this.myTable, this.getTemplatePresentation());
    }

    private static void setEnabled(RadPropertyTable table, Presentation presentation) {
        try {
            Property property = table.getSelectionProperty();
            presentation.setEnabled(property != null && !table.isEditing() && !table.isDefault(property));
        }
        catch (Exception e) {
            presentation.setEnabled(false);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        this.myTable.restoreDefaultValue();
        RestoreDefault.setEnabled(this.myTable, this.getTemplatePresentation());
    }
}

