/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.model;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.designer.model.QuickFix;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ErrorInfo {
    private static final String KEY = "Inspection.Errors";
    private final String myName;
    private final String myPropertyName;
    private final HighlightDisplayLevel myLevel;
    private final List<QuickFix> myQuickFixes = new ArrayList<QuickFix>();

    public ErrorInfo(@NotNull String name, @Nullable String propertyName, @NotNull HighlightDisplayLevel level) {
        this.myName = name;
        this.myPropertyName = propertyName;
        this.myLevel = level;
    }

    public String getName() {
        return this.myName;
    }

    public HighlightDisplayLevel getLevel() {
        return this.myLevel;
    }

    @Nullable
    public String getPropertyName() {
        return this.myPropertyName;
    }

    public List<QuickFix> getQuickFixes() {
        return this.myQuickFixes;
    }

    public static boolean haveFixes(List<ErrorInfo> errorInfos) {
        for (ErrorInfo errorInfo : errorInfos) {
            if (errorInfo.getQuickFixes().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

