/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class DesignerEditorState
implements FileEditorState {
    private static final String DESIGNER_ZOOM = "ui-designer-zoom";
    private final long myModificationStamp;
    private final double myZoom;

    public DesignerEditorState(VirtualFile file2, double zoom) {
        Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
        this.myModificationStamp = document != null ? document.getModificationStamp() : file2.getModificationStamp();
        this.myZoom = zoom;
    }

    public double getZoom() {
        return this.myZoom;
    }

    public int hashCode() {
        int A = (int)(this.myModificationStamp ^ this.myModificationStamp >>> 32);
        long B2 = Double.doubleToLongBits(this.myZoom);
        return 31 * A + (int)(B2 ^ B2 >>> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DesignerEditorState) {
            DesignerEditorState state = (DesignerEditorState)object;
            return this.myModificationStamp == state.myModificationStamp && this.myZoom == state.myZoom;
        }
        return false;
    }

    public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
        return otherState instanceof DesignerEditorState;
    }

    @NotNull
    public static FileEditorState readState(@NotNull Element sourceElement, @NotNull VirtualFile file2, double defaultZoom) {
        double zoom = defaultZoom;
        try {
            zoom = Double.parseDouble(sourceElement.getAttributeValue(DESIGNER_ZOOM));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new DesignerEditorState(file2, zoom);
    }

    public static void writeState(@NotNull FileEditorState state, @NotNull Element targetElement) {
        targetElement.setAttribute(DESIGNER_ZOOM, Double.toString(((DesignerEditorState)state).getZoom()));
    }
}

