/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render.configurables;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.ui.CompletionEditor;
import com.intellij.debugger.ui.DebuggerExpressionComboBox;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.Table;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;

public class NamedChildrenConfigurable
implements UnnamedConfigurable,
Disposable {
    private Table myTable;
    private final EnumerationChildrenRenderer myRenderer;
    private JPanel myPanel;
    private JLabel myTableLabel;
    private JButton myButtonAdd;
    private JButton myButtonRemove;
    private JButton myButtonUp;
    private JButton myButtonDown;
    private final CompletionEditor myCompletionEditor;

    public NamedChildrenConfigurable(@NotNull Project project2, EnumerationChildrenRenderer renderer) {
        this.myRenderer = renderer;
        this.$$$setupUI$$$();
        this.myTableLabel.setLabelFor((Component)this.myTable);
        this.getModel().addColumn((Object)DebuggerBundle.message((String)"label.named.children.configurable.table.header.column.name", (Object[])new Object[0]), (Object[])null);
        String expressionColumnName = DebuggerBundle.message((String)"label.named.children.configurable.table.header.column.expression", (Object[])new Object[0]);
        this.getModel().addColumn((Object)expressionColumnName, (Object[])null);
        PsiClass psiClass = DebuggerUtils.findClass((String)this.myRenderer.getClassName(), (Project)project2, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project2));
        this.myCompletionEditor = new DebuggerExpressionComboBox(project2, this, (PsiElement)psiClass, "NamedChildrenConfigurable");
        this.myTable.setDragEnabled(false);
        this.myTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.myTable.getColumn((Object)expressionColumnName).setCellEditor((TableCellEditor)new AbstractTableCellEditor(){

            public Object getCellEditorValue() {
                return NamedChildrenConfigurable.this.myCompletionEditor.getText();
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                NamedChildrenConfigurable.this.myCompletionEditor.setText((TextWithImports)value);
                return NamedChildrenConfigurable.this.myCompletionEditor;
            }
        });
        this.myButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamedChildrenConfigurable.this.getModel().addRow(new Object[]{"", DebuggerUtils.getInstance().createExpressionWithImports("")});
            }
        });
        this.myButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = NamedChildrenConfigurable.this.myTable.getSelectedRow();
                if (selectedRow >= 0 && selectedRow < NamedChildrenConfigurable.this.myTable.getRowCount()) {
                    NamedChildrenConfigurable.this.getModel().removeRow(selectedRow);
                }
            }
        });
        this.myButtonDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableUtil.moveSelectedItemsDown((JTable)NamedChildrenConfigurable.this.myTable);
            }
        });
        this.myButtonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableUtil.moveSelectedItemsUp((JTable)NamedChildrenConfigurable.this.myTable);
            }
        });
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                NamedChildrenConfigurable.this.updateButtons();
            }
        });
        this.updateButtons();
    }

    private void updateButtons() {
        int selectedRow = this.myTable.getSelectedRow();
        this.myButtonRemove.setEnabled(selectedRow != -1);
        this.myButtonUp.setEnabled(selectedRow > 0);
        this.myButtonDown.setEnabled(selectedRow < this.myTable.getRowCount() - 1);
    }

    private DefaultTableModel getModel() {
        return (DefaultTableModel)this.myTable.getModel();
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return false;
    }

    public void apply() throws ConfigurationException {
        DefaultTableModel model = this.getModel();
        int size = model.getRowCount();
        ArrayList<Pair<String, TextWithImports>> result = new ArrayList<Pair<String, TextWithImports>>();
        for (int idx = 0; idx < size; ++idx) {
            result.add((Pair<String, TextWithImports>)Pair.create((Object)((String)model.getValueAt(idx, 0)), (Object)((TextWithImports)model.getValueAt(idx, 1))));
        }
        this.myRenderer.setChildren(result);
    }

    public void reset() {
        while (this.myTable.getModel().getRowCount() > 0) {
            this.getModel().removeRow(0);
        }
        for (Pair<String, TextWithImports> pair : this.myRenderer.getChildren()) {
            this.getModel().addRow(new Object[]{pair.getFirst(), pair.getSecond()});
        }
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        Table table;
        JLabel jLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTableLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.named.children.configurable.node.descendants"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myTable = table = new Table();
        table.setPreferredScrollableViewportSize(new Dimension(-1, -1));
        jBScrollPane.setViewportView((Component)table);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myButtonRemove = jButton4 = new JButton();
        this.$$$loadButtonText$$$(jButton4, ResourceBundle.getBundle("messages/DebuggerBundle").getString("button.remove"));
        jPanel3.add((Component)jButton4, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myButtonUp = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("messages/DebuggerBundle").getString("button.move.up"));
        jPanel3.add((Component)jButton3, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myButtonDown = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/DebuggerBundle").getString("button.move.down"));
        jPanel3.add((Component)jButton2, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myButtonAdd = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/DebuggerBundle").getString("button.add"));
        jPanel3.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

