/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.ToStringBasedRenderer;
import com.intellij.execution.filters.ExceptionFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StackTraceElementObjectRenderer
extends ToStringBasedRenderer
implements FullValueEvaluatorProvider {
    private static final Logger LOG = Logger.getInstance(StackTraceElementObjectRenderer.class);

    public StackTraceElementObjectRenderer(NodeRendererSettings rendererSettings) {
        super(rendererSettings, "StackTraceElement", null, null);
        this.setClassName("java.lang.StackTraceElement");
        this.setEnabled(true);
    }

    @Override
    @Nullable
    public XFullValueEvaluator getFullValueEvaluator(final EvaluationContextImpl evaluationContext, final ValueDescriptorImpl valueDescriptor) {
        return new JavaValue.JavaFullValueEvaluator(DebuggerBundle.message((String)"message.node.navigate", (Object[])new Object[0]), evaluationContext){

            @Override
            public void evaluate(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                Value value = valueDescriptor.getValue();
                ClassType type = (ClassType)value.type();
                Method toString = type.concreteMethodByName("toString", "()Ljava/lang/String;");
                if (toString != null) {
                    try {
                        Value res = evaluationContext.getDebugProcess().invokeMethod((EvaluationContext)evaluationContext, (ObjectReference)value, toString, Collections.emptyList());
                        if (res instanceof StringReference) {
                            callback.evaluated("");
                            final String line = ((StringReference)res).value();
                            ApplicationManager.getApplication().runReadAction(new Runnable(){

                                @Override
                                public void run() {
                                    HyperlinkInfo info;
                                    ExceptionFilter filter = new ExceptionFilter(evaluationContext.getDebugProcess().getSession().getSearchScope());
                                    Filter.Result result = filter.applyFilter(line, line.length());
                                    if (result != null && (info = result.getFirstHyperlinkInfo()) != null) {
                                        DebuggerUIUtil.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                info.navigate(valueDescriptor.getProject());
                                            }
                                        });
                                    }
                                }
                            });
                        }
                    }
                    catch (EvaluateException e) {
                        LOG.info("Exception while getting stack info", (Throwable)e);
                    }
                }
            }

            public boolean isShowValuePopup() {
                return false;
            }
        };
    }
}

