/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;

public abstract class CustomPopupFullValueEvaluator<T>
extends JavaValue.JavaFullValueEvaluator {
    public CustomPopupFullValueEvaluator(@NotNull String linkText, @NotNull EvaluationContextImpl evaluationContext) {
        super(linkText, evaluationContext);
        this.setShowValuePopup(false);
    }

    protected abstract T getData();

    protected abstract JComponent createComponent(T var1);

    @Override
    public void evaluate(final @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
        final T data = this.getData();
        DebuggerUIUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (callback.isObsolete()) {
                    return;
                }
                JComponent comp = CustomPopupFullValueEvaluator.this.createComponent(data);
                Project project2 = CustomPopupFullValueEvaluator.this.getEvaluationContext().getProject();
                JBPopup popup = DebuggerUIUtil.createValuePopup(project2, comp, null);
                JFrame frame = WindowManager.getInstance().getFrame(project2);
                Dimension frameSize = frame.getSize();
                Dimension size = new Dimension(frameSize.width / 2, frameSize.height / 2);
                popup.setSize(size);
                if (comp instanceof Disposable) {
                    Disposer.register((Disposable)popup, (Disposable)((Disposable)comp));
                }
                callback.evaluated("");
                popup.show(new RelativePoint((Component)frame, new Point(size.width / 2, size.height / 2)));
            }
        });
    }
}

