/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public class ThrownExceptionValueDescriptorImpl
extends ValueDescriptorImpl {
    @NotNull
    private final ObjectReference myExceptionObj;

    public ThrownExceptionValueDescriptorImpl(Project project2, @NotNull ObjectReference exceptionObj) {
        super(project2);
        this.myExceptionObj = exceptionObj;
        this.setRenderer(DebugProcessImpl.getDefaultRenderer(exceptionObj));
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        return this.myExceptionObj;
    }

    @Override
    public String getName() {
        return "Exception";
    }

    @Override
    @NotNull
    public Type getType() {
        return this.myExceptionObj.referenceType();
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        throw new EvaluateException("Evaluation not supported for thrown exception object");
    }

    @Override
    public boolean canSetValue() {
        return false;
    }
}

