/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.sun.jdi.Value;

public class ThisDescriptorImpl
extends ValueDescriptorImpl {
    public ThisDescriptorImpl(Project project2) {
        super(project2);
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        return evaluationContext != null ? evaluationContext.getThisObject() : null;
    }

    @Override
    public String getName() {
        return "this";
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        try {
            return elementFactory.createExpressionFromText("this", null);
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean canSetValue() {
        return false;
    }
}

