/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class MethodBreakpoint
extends BreakpointWithHighlighter<JavaMethodBreakpointProperties> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.MethodBreakpoint");
    @Nullable
    private JVMName mySignature;
    private boolean myIsStatic;
    @NonNls
    public static final Key<MethodBreakpoint> CATEGORY = BreakpointCategory.lookup("method_breakpoints");

    protected MethodBreakpoint(@NotNull Project project2, XBreakpoint breakpoint) {
        super(project2, breakpoint);
    }

    public boolean isStatic() {
        return this.myIsStatic;
    }

    @Override
    @NotNull
    public Key<MethodBreakpoint> getCategory() {
        return CATEGORY;
    }

    @Nullable
    public PsiMethod getPsiMethod() {
        Document document = this.getDocument();
        if (document == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile instanceof PsiJavaFile) {
            int line = this.getLineIndex();
            int offset = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)document.getLineStartOffset(line), (String)" \t");
            return DebuggerUtilsEx.findPsiMethod(psiFile, offset);
        }
        return null;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.getMethodName() != null;
    }

    @Override
    protected void reload(@NotNull PsiFile psiFile) {
        PsiClass psiClass;
        this.setMethodName(null);
        this.mySignature = null;
        MethodDescriptor descriptor = MethodBreakpoint.getMethodDescriptor(this.myProject, psiFile, this.getSourcePosition());
        if (descriptor != null) {
            this.setMethodName(descriptor.methodName);
            this.mySignature = descriptor.methodSignature;
            this.myIsStatic = descriptor.isStatic;
        }
        if ((psiClass = this.getPsiClass()) != null) {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myClassPattern = psiClass.getQualifiedName();
        }
        if (this.myIsStatic) {
            this.setInstanceFiltersEnabled(false);
        }
    }

    @Override
    protected void createRequestForPreparedClass(@NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType) {
        try {
            boolean hasMethod = false;
            for (Method method : classType.allMethods()) {
                String signature = method.signature();
                String name = method.name();
                if (!this.getMethodName().equals(name) || !this.mySignature.getName(debugProcess).equals(signature)) continue;
                hasMethod = true;
                break;
            }
            if (!hasMethod) {
                debugProcess.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.method.not.found", (Object[])new Object[]{classType.name()}));
                return;
            }
            RequestManagerImpl requestManager = debugProcess.getRequestsManager();
            if (this.isWatchEntry()) {
                MethodEntryRequest entryRequest = MethodBreakpoint.findRequest(debugProcess, MethodEntryRequest.class, this);
                if (entryRequest == null) {
                    entryRequest = requestManager.createMethodEntryRequest(this);
                } else {
                    entryRequest.disable();
                }
                entryRequest.addClassFilter(classType);
                debugProcess.getRequestsManager().enableRequest(entryRequest);
            }
            if (this.isWatchExit()) {
                MethodExitRequest exitRequest = MethodBreakpoint.findRequest(debugProcess, MethodExitRequest.class, this);
                if (exitRequest == null) {
                    exitRequest = requestManager.createMethodExitRequest(this);
                } else {
                    exitRequest.disable();
                }
                exitRequest.addClassFilter(classType);
                debugProcess.getRequestsManager().enableRequest(exitRequest);
            }
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
    }

    @Override
    public String getEventMessage(@NotNull LocatableEvent event) {
        Location location = event.location();
        String locationQName = DebuggerUtilsEx.getLocationMethodQName(location);
        String locationFileName = "";
        try {
            locationFileName = location.sourceName();
        }
        catch (AbsentInformationException e) {
            locationFileName = this.getFileName();
        }
        int locationLine = location.lineNumber();
        if (event instanceof MethodEntryEvent) {
            MethodEntryEvent entryEvent = (MethodEntryEvent)event;
            Method method = entryEvent.method();
            return DebuggerBundle.message((String)"status.method.entry.breakpoint.reached", (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine});
        }
        if (event instanceof MethodExitEvent) {
            MethodExitEvent exitEvent = (MethodExitEvent)event;
            Method method = exitEvent.method();
            return DebuggerBundle.message((String)"status.method.exit.breakpoint.reached", (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine});
        }
        return "";
    }

    @Override
    public PsiElement getEvaluationElement() {
        return this.getPsiClass();
    }

    @Override
    @NotNull
    protected Icon getDisabledIcon(boolean isMuted) {
        Breakpoint master = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this);
        if (isMuted) {
            return master == null ? AllIcons.Debugger.Db_muted_disabled_method_breakpoint : AllIcons.Debugger.Db_muted_dep_method_breakpoint;
        }
        return master == null ? AllIcons.Debugger.Db_disabled_method_breakpoint : AllIcons.Debugger.Db_dep_method_breakpoint;
    }

    @Override
    @NotNull
    protected Icon getSetIcon(boolean isMuted) {
        return isMuted ? AllIcons.Debugger.Db_muted_method_breakpoint : AllIcons.Debugger.Db_method_breakpoint;
    }

    @Override
    @NotNull
    protected Icon getInvalidIcon(boolean isMuted) {
        return isMuted ? AllIcons.Debugger.Db_muted_invalid_method_breakpoint : AllIcons.Debugger.Db_invalid_method_breakpoint;
    }

    @Override
    @NotNull
    protected Icon getVerifiedIcon(boolean isMuted) {
        return isMuted ? AllIcons.Debugger.Db_muted_verified_method_breakpoint : AllIcons.Debugger.Db_verified_method_breakpoint;
    }

    @Override
    @NotNull
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        return isMuted ? AllIcons.Debugger.Db_muted_method_warning_breakpoint : AllIcons.Debugger.Db_method_warning_breakpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDisplayName() {
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            if (this.isValid()) {
                boolean classNameExists;
                String className = this.getClassName();
                boolean bl = classNameExists = className != null && className.length() > 0;
                if (classNameExists) {
                    buffer.append(className);
                }
                if (this.getMethodName() != null) {
                    if (classNameExists) {
                        buffer.append(".");
                    }
                    buffer.append(this.getMethodName());
                }
            } else {
                buffer.append(DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]));
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    @Override
    public boolean evaluateCondition(@NotNull EvaluationContextImpl context, @NotNull LocatableEvent event) throws EvaluateException {
        if (!this.matchesEvent(event, context.getDebugProcess())) {
            return false;
        }
        return super.evaluateCondition(context, event);
    }

    public boolean matchesEvent(@NotNull LocatableEvent event, DebugProcessImpl process) throws EvaluateException {
        if (this.getMethodName() == null || this.mySignature == null) {
            return false;
        }
        Method method = event.location().method();
        return method != null && method.name().equals(this.getMethodName()) && method.signature().equals(this.mySignature.getName(process));
    }

    @Nullable
    public static MethodBreakpoint create(@NotNull Project project2, XBreakpoint xBreakpoint) {
        MethodBreakpoint breakpoint = new MethodBreakpoint(project2, xBreakpoint);
        return (MethodBreakpoint)breakpoint.init();
    }

    @Nullable
    private static MethodDescriptor getMethodDescriptor(final @NotNull Project project2, @NotNull PsiFile psiJavaFile, final @NotNull SourcePosition sourcePosition) {
        PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)project2);
        final Document document = docManager.getDocument(psiJavaFile);
        if (document == null) {
            return null;
        }
        MethodDescriptor descriptor = (MethodDescriptor)ApplicationManager.getApplication().runReadAction((Computable)new Computable<MethodDescriptor>(){

            @Nullable
            public MethodDescriptor compute() {
                PsiMethod method = PositionUtil.getPsiElementAt(project2, PsiMethod.class, sourcePosition);
                if (method == null) {
                    return null;
                }
                int methodOffset = method.getTextOffset();
                if (methodOffset < 0) {
                    return null;
                }
                if (document.getLineNumber(methodOffset) < sourcePosition.getLine()) {
                    return null;
                }
                PsiIdentifier identifier = method.getNameIdentifier();
                int methodNameOffset = identifier != null ? identifier.getTextOffset() : methodOffset;
                MethodDescriptor descriptor = new MethodDescriptor();
                descriptor.methodName = JVMNameUtil.getJVMMethodName(method);
                try {
                    descriptor.methodSignature = JVMNameUtil.getJVMSignature(method);
                    descriptor.isStatic = method.hasModifierProperty("static");
                }
                catch (IndexNotReadyException ignored) {
                    return null;
                }
                descriptor.methodLine = document.getLineNumber(methodNameOffset);
                return descriptor;
            }
        });
        if (descriptor == null || descriptor.methodName == null || descriptor.methodSignature == null) {
            return null;
        }
        return descriptor;
    }

    @Nullable
    static <T extends EventRequest> T findRequest(@NotNull DebugProcessImpl debugProcess, Class<T> requestClass, Requestor requestor) {
        Set<EventRequest> requests = debugProcess.getRequestsManager().findRequests(requestor);
        for (EventRequest eventRequest : requests) {
            if (!eventRequest.getClass().equals(requestClass)) continue;
            return (T)eventRequest;
        }
        return null;
    }

    @Override
    public void readExternal(@NotNull Element breakpointNode) throws InvalidDataException {
        super.readExternal(breakpointNode);
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)breakpointNode, (String)"WATCH_ENTRY"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)breakpointNode, (String)"WATCH_EXIT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isBodyAt(@NotNull Document document, int offset) {
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile instanceof PsiJavaFile) {
            PsiMethod method = DebuggerUtilsEx.findPsiMethod(psiFile, offset);
            return method == this.getPsiMethod();
        }
        return false;
    }

    private boolean isWatchEntry() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY;
    }

    private boolean isWatchExit() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT;
    }

    @Nullable
    private String getMethodName() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName;
    }

    private void setMethodName(@Nullable String methodName) {
        ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName = methodName;
    }

    private static final class MethodDescriptor {
        String methodName;
        JVMName methodSignature;
        boolean isStatic;
        int methodLine;

        private MethodDescriptor() {
        }
    }
}

