/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpointPropertiesPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class JavaMethodBreakpointType
extends JavaLineBreakpointTypeBase<JavaMethodBreakpointProperties>
implements JavaBreakpointType<JavaMethodBreakpointProperties> {
    public JavaMethodBreakpointType() {
        super("java-method", DebuggerBundle.message((String)"method.breakpoints.tab.title", (Object[])new Object[0]));
    }

    @NotNull
    public Icon getEnabledIcon() {
        return AllIcons.Debugger.Db_method_breakpoint;
    }

    @NotNull
    public Icon getDisabledIcon() {
        return AllIcons.Debugger.Db_disabled_method_breakpoint;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        return AllIcons.Debugger.Db_muted_method_breakpoint;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        return AllIcons.Debugger.Db_muted_disabled_method_breakpoint;
    }

    protected String getHelpID() {
        return "debugging.methodBreakpoint";
    }

    public String getDisplayName() {
        return DebuggerBundle.message((String)"method.breakpoints.tab.title", (Object[])new Object[0]);
    }

    public String getShortText(XLineBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        return JavaMethodBreakpointType.getText(breakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getText(XBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            boolean classNameExists;
            String className = ((JavaMethodBreakpointProperties)breakpoint.getProperties()).myClassPattern;
            boolean bl = classNameExists = className != null && className.length() > 0;
            if (classNameExists) {
                buffer.append(className);
            }
            if (((JavaMethodBreakpointProperties)breakpoint.getProperties()).myMethodName != null) {
                if (classNameExists) {
                    buffer.append(".");
                }
                buffer.append(((JavaMethodBreakpointProperties)breakpoint.getProperties()).myMethodName);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel createCustomPropertiesPanel() {
        return new MethodBreakpointPropertiesPanel();
    }

    @Nullable
    public JavaMethodBreakpointProperties createProperties() {
        return new JavaMethodBreakpointProperties();
    }

    @Nullable
    public JavaMethodBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file2, int line) {
        return new JavaMethodBreakpointProperties();
    }

    @Override
    @NotNull
    public Breakpoint<JavaMethodBreakpointProperties> createJavaBreakpoint(Project project2, XBreakpoint breakpoint) {
        return new MethodBreakpoint(project2, breakpoint);
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }
}

