/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.CommonBundle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.ui.breakpoints.AddFieldBreakpointDialog;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.debugger.ui.breakpoints.FieldBreakpointPropertiesPanel;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaFieldBreakpointProperties;

public class JavaFieldBreakpointType
extends JavaLineBreakpointTypeBase<JavaFieldBreakpointProperties>
implements JavaBreakpointType<JavaFieldBreakpointProperties> {
    public JavaFieldBreakpointType() {
        super("java-field", DebuggerBundle.message((String)"field.watchpoints.tab.title", (Object[])new Object[0]));
    }

    @Override
    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    @NotNull
    public Icon getEnabledIcon() {
        return AllIcons.Debugger.Db_field_breakpoint;
    }

    @NotNull
    public Icon getDisabledIcon() {
        return AllIcons.Debugger.Db_disabled_field_breakpoint;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        return AllIcons.Debugger.Db_muted_field_breakpoint;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        return AllIcons.Debugger.Db_muted_disabled_field_breakpoint;
    }

    protected String getHelpID() {
        return "debugging.fieldWatchpoint";
    }

    public String getDisplayName() {
        return DebuggerBundle.message((String)"field.watchpoints.tab.title", (Object[])new Object[0]);
    }

    public String getShortText(XLineBreakpoint<JavaFieldBreakpointProperties> breakpoint) {
        return this.getText(breakpoint);
    }

    public String getText(XLineBreakpoint<JavaFieldBreakpointProperties> breakpoint) {
        JavaFieldBreakpointProperties properties = (JavaFieldBreakpointProperties)breakpoint.getProperties();
        String className = properties.myClassName;
        return className != null && !className.isEmpty() ? className + "." + properties.myFieldName : properties.myFieldName;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<JavaFieldBreakpointProperties>> createCustomPropertiesPanel() {
        return new FieldBreakpointPropertiesPanel();
    }

    @Nullable
    public JavaFieldBreakpointProperties createProperties() {
        return new JavaFieldBreakpointProperties();
    }

    @Nullable
    public JavaFieldBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file2, int line) {
        return new JavaFieldBreakpointProperties();
    }

    @Nullable
    public XLineBreakpoint<JavaFieldBreakpointProperties> addBreakpoint(final Project project2, JComponent parentComponent) {
        final Ref result = Ref.create(null);
        AddFieldBreakpointDialog dialog = new AddFieldBreakpointDialog(project2){

            @Override
            protected boolean validateData() {
                final String className = this.getClassName();
                if (className.length() == 0) {
                    Messages.showMessageDialog((Project)project2, (String)DebuggerBundle.message((String)"error.field.breakpoint.class.name.not.specified", (Object[])new Object[0]), (String)DebuggerBundle.message((String)"add.field.breakpoint.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                    return false;
                }
                final String fieldName = this.getFieldName();
                if (fieldName.length() == 0) {
                    Messages.showMessageDialog((Project)project2, (String)DebuggerBundle.message((String)"error.field.breakpoint.field.name.not.specified", (Object[])new Object[0]), (String)DebuggerBundle.message((String)"add.field.breakpoint.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                    return false;
                }
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)project2).findClass(className, GlobalSearchScope.allScope((Project)project2));
                if (psiClass != null) {
                    final PsiFile psiFile = psiClass.getContainingFile();
                    Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile);
                    if (document != null) {
                        PsiField field = psiClass.findFieldByName(fieldName, true);
                        if (field != null) {
                            final int line = document.getLineNumber(field.getTextOffset());
                            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                @Override
                                public void run() {
                                    XLineBreakpoint fieldBreakpoint = XDebuggerManager.getInstance((Project)project2).getBreakpointManager().addLineBreakpoint((XLineBreakpointType)JavaFieldBreakpointType.this, psiFile.getVirtualFile().getUrl(), line, (XBreakpointProperties)new JavaFieldBreakpointProperties(fieldName, className));
                                    result.set((Object)fieldBreakpoint);
                                }
                            });
                            return true;
                        }
                        Messages.showMessageDialog((Project)project2, (String)DebuggerBundle.message((String)"error.field.breakpoint.field.not.found", (Object[])new Object[]{className, fieldName, fieldName}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                    }
                } else {
                    Messages.showMessageDialog((Project)project2, (String)DebuggerBundle.message((String)"error.field.breakpoint.class.sources.not.found", (Object[])new Object[]{className, fieldName, className}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                }
                return false;
            }
        };
        dialog.show();
        return (XLineBreakpoint)result.get();
    }

    @Override
    @NotNull
    public Breakpoint<JavaFieldBreakpointProperties> createJavaBreakpoint(Project project2, XBreakpoint breakpoint) {
        return new FieldBreakpoint(project2, breakpoint);
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }
}

