/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.ui.breakpoints.AnyExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpointPropertiesPanel;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointTypeBase;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaExceptionBreakpointProperties;

public class JavaExceptionBreakpointType
extends JavaBreakpointTypeBase<JavaExceptionBreakpointProperties>
implements JavaBreakpointType<JavaExceptionBreakpointProperties> {
    public JavaExceptionBreakpointType() {
        super("java-exception", DebuggerBundle.message((String)"exception.breakpoints.tab.title", (Object[])new Object[0]));
    }

    @NotNull
    public Icon getEnabledIcon() {
        return AllIcons.Debugger.Db_exception_breakpoint;
    }

    @NotNull
    public Icon getDisabledIcon() {
        return AllIcons.Debugger.Db_disabled_exception_breakpoint;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        return AllIcons.Debugger.Db_muted_exception_breakpoint;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        return AllIcons.Debugger.Db_muted_disabled_exception_breakpoint;
    }

    protected String getHelpID() {
        return "debugging.exceptionBreakpoint";
    }

    public String getDisplayName() {
        return DebuggerBundle.message((String)"exception.breakpoints.tab.title", (Object[])new Object[0]);
    }

    public String getDisplayText(XBreakpoint<JavaExceptionBreakpointProperties> breakpoint) {
        String name = ((JavaExceptionBreakpointProperties)breakpoint.getProperties()).myQualifiedName;
        if (name != null) {
            return DebuggerBundle.message((String)"breakpoint.exception.breakpoint.display.name", (Object[])new Object[]{name});
        }
        return DebuggerBundle.message((String)"breakpoint.any.exception.display.name", (Object[])new Object[0]);
    }

    @Nullable
    public JavaExceptionBreakpointProperties createProperties() {
        return new JavaExceptionBreakpointProperties();
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XBreakpoint<JavaExceptionBreakpointProperties>> createCustomPropertiesPanel() {
        return new ExceptionBreakpointPropertiesPanel();
    }

    @Nullable
    public XBreakpoint<JavaExceptionBreakpointProperties> createDefaultBreakpoint(@NotNull XBreakpointType.XBreakpointCreator<JavaExceptionBreakpointProperties> creator) {
        return creator.createBreakpoint((XBreakpointProperties)new JavaExceptionBreakpointProperties());
    }

    @Nullable
    public XBreakpoint<JavaExceptionBreakpointProperties> addBreakpoint(final Project project2, JComponent parentComponent) {
        String qName;
        PsiClass throwableClass = JavaPsiFacade.getInstance((Project)project2).findClass("java.lang.Throwable", GlobalSearchScope.allScope((Project)project2));
        TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)project2).createInheritanceClassChooser(DebuggerBundle.message((String)"add.exception.breakpoint.classchooser.title", (Object[])new Object[0]), GlobalSearchScope.allScope((Project)project2), throwableClass, true, true, null);
        chooser.showDialog();
        final PsiClass selectedClass = chooser.getSelected();
        String string = qName = selectedClass == null ? null : JVMNameUtil.getNonAnonymousClassName(selectedClass);
        if (qName != null && qName.length() > 0) {
            return (XBreakpoint)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<XBreakpoint<JavaExceptionBreakpointProperties>>(){

                public XBreakpoint<JavaExceptionBreakpointProperties> compute() {
                    return XDebuggerManager.getInstance((Project)project2).getBreakpointManager().addBreakpoint((XBreakpointType)JavaExceptionBreakpointType.this, (XBreakpointProperties)new JavaExceptionBreakpointProperties(qName, ((PsiClassOwner)selectedClass.getContainingFile()).getPackageName()));
                }
            });
        }
        return null;
    }

    @Override
    @NotNull
    public Breakpoint<JavaExceptionBreakpointProperties> createJavaBreakpoint(Project project2, XBreakpoint<JavaExceptionBreakpointProperties> breakpoint) {
        if (!XDebuggerManager.getInstance((Project)project2).getBreakpointManager().isDefaultBreakpoint(breakpoint)) {
            return new ExceptionBreakpoint(project2, breakpoint);
        }
        return new AnyExceptionBreakpoint(project2, breakpoint);
    }
}

