/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.CommonBundle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerManagerAdapter;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapManager;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.HotSwapProgressImpl;
import com.intellij.debugger.ui.HotSwapUI;
import com.intellij.debugger.ui.HotSwapVetoableListener;
import com.intellij.debugger.ui.RunHotswapDialog;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.compiler.ex.CompilerPathsEx;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.PairFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

public class HotSwapUIImpl
extends HotSwapUI
implements ProjectComponent {
    private final List<HotSwapVetoableListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myAskBeforeHotswap = true;
    private final Project myProject;
    private boolean myPerformHotswapAfterThisCompilation = true;

    public HotSwapUIImpl(Project project2, final MessageBus bus, DebuggerManager debugManager) {
        this.myProject = project2;
        ((DebuggerManagerEx)debugManager).addDebuggerManagerListener(new DebuggerManagerAdapter(){
            private MessageBusConnection myConn = null;

            @Override
            public void sessionAttached(DebuggerSession session) {
                if (this.myConn == null) {
                    this.myConn = bus.connect();
                    this.myConn.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new MyCompilationStatusListener());
                }
            }

            @Override
            public void sessionDetached(DebuggerSession session) {
                if (!HotSwapUIImpl.this.getHotSwappableDebugSessions().isEmpty()) {
                    return;
                }
                MessageBusConnection conn = this.myConn;
                if (conn != null) {
                    Disposer.dispose((Disposable)conn);
                    this.myConn = null;
                }
            }
        });
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NotNull
    public String getComponentName() {
        return "HotSwapUI";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @Override
    public void addListener(HotSwapVetoableListener listener2) {
        this.myListeners.add(listener2);
    }

    @Override
    public void removeListener(HotSwapVetoableListener listener2) {
        this.myListeners.remove(listener2);
    }

    private static boolean shouldDisplayHangWarning(DebuggerSettings settings, List<DebuggerSession> sessions) {
        if (!settings.HOTSWAP_HANG_WARNING_ENABLED) {
            return false;
        }
        for (DebuggerSession session : sessions) {
            if (!session.isPaused()) continue;
            return true;
        }
        return false;
    }

    private void hotSwapSessions(final List<DebuggerSession> sessions, final @Nullable Map<String, List<String>> generatedPaths) {
        HotSwapProgressImpl findClassesProgress;
        boolean shouldPerformScan;
        final boolean shouldAskBeforeHotswap = this.myAskBeforeHotswap;
        this.myAskBeforeHotswap = true;
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        final DebuggerSettings settings = DebuggerSettings.getInstance();
        final String runHotswap = settings.RUN_HOTSWAP_AFTER_COMPILE;
        final boolean shouldDisplayHangWarning = HotSwapUIImpl.shouldDisplayHangWarning(settings, sessions);
        if (shouldAskBeforeHotswap && "RunHotswapNever".equals(runHotswap)) {
            return;
        }
        boolean bl = shouldPerformScan = generatedPaths == null;
        if (shouldPerformScan) {
            findClassesProgress = new HotSwapProgressImpl(this.myProject);
        } else {
            boolean createProgress = false;
            for (DebuggerSession session : sessions) {
                if (!session.isModifiedClassesScanRequired()) continue;
                createProgress = true;
                break;
            }
            findClassesProgress = createProgress ? new HotSwapProgressImpl(this.myProject) : null;
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                HashMap<DebuggerSession, Map<String, HotSwapFile>> modifiedClasses;
                if (shouldPerformScan) {
                    modifiedClasses = HotSwapUIImpl.scanForModifiedClassesWithProgress(sessions, findClassesProgress, false);
                } else {
                    ArrayList<DebuggerSession> toScan = new ArrayList<DebuggerSession>();
                    ArrayList<DebuggerSession> toUseGenerated = new ArrayList<DebuggerSession>();
                    for (DebuggerSession session : sessions) {
                        (session.isModifiedClassesScanRequired() ? toScan : toUseGenerated).add(session);
                        session.setModifiedClassesScanRequired(false);
                    }
                    modifiedClasses = new HashMap<DebuggerSession, Map<String, HotSwapFile>>();
                    if (!toUseGenerated.isEmpty()) {
                        modifiedClasses.putAll(HotSwapManager.findModifiedClasses(toUseGenerated, generatedPaths));
                    }
                    if (!toScan.isEmpty()) {
                        modifiedClasses.putAll(HotSwapUIImpl.scanForModifiedClassesWithProgress(toScan, findClassesProgress, false));
                    }
                }
                final Application application = ApplicationManager.getApplication();
                if (modifiedClasses.isEmpty()) {
                    String message = DebuggerBundle.message((String)"status.hotswap.uptodate", (Object[])new Object[0]);
                    HotSwapProgressImpl.NOTIFICATION_GROUP.createNotification(message, NotificationType.INFORMATION).notify(HotSwapUIImpl.this.myProject);
                    return;
                }
                application.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int answer;
                        if (shouldAskBeforeHotswap && !"RunHotswapAlways".equals(runHotswap)) {
                            RunHotswapDialog dialog = new RunHotswapDialog(HotSwapUIImpl.this.myProject, sessions, shouldDisplayHangWarning);
                            if (!dialog.showAndGet()) {
                                for (DebuggerSession session : modifiedClasses.keySet()) {
                                    session.setModifiedClassesScanRequired(true);
                                }
                                return;
                            }
                            HashSet<DebuggerSession> toReload = new HashSet<DebuggerSession>(dialog.getSessionsToReload());
                            for (DebuggerSession session : modifiedClasses.keySet()) {
                                if (toReload.contains(session)) continue;
                                session.setModifiedClassesScanRequired(true);
                            }
                            modifiedClasses.keySet().retainAll(toReload);
                        } else if (shouldDisplayHangWarning && (answer = Messages.showCheckboxMessageDialog((String)DebuggerBundle.message((String)"hotswap.dialog.hang.warning", (Object[])new Object[0]), (String)DebuggerBundle.message((String)"hotswap.dialog.title", (Object[])new Object[0]), (String[])new String[]{"Perform &Reload Classes", "&Skip Reload Classes"}, (String)CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]), (boolean)false, (int)1, (int)1, (Icon)Messages.getWarningIcon(), (PairFunction)new PairFunction<Integer, JCheckBox, Integer>(){

                            public Integer fun(Integer exitCode, JCheckBox cb) {
                                settings.HOTSWAP_HANG_WARNING_ENABLED = !cb.isSelected();
                                return exitCode == 0 ? exitCode : 1;
                            }
                        })) == 1) {
                            for (DebuggerSession session : modifiedClasses.keySet()) {
                                session.setModifiedClassesScanRequired(true);
                            }
                            return;
                        }
                        if (!modifiedClasses.isEmpty()) {
                            final HotSwapProgressImpl progress = new HotSwapProgressImpl(HotSwapUIImpl.this.myProject);
                            application.executeOnPooledThread(new Runnable(){

                                @Override
                                public void run() {
                                    HotSwapUIImpl.reloadModifiedClasses(modifiedClasses, progress);
                                }
                            });
                        }
                    }
                }, ModalityState.NON_MODAL);
            }
        });
    }

    private static Map<DebuggerSession, Map<String, HotSwapFile>> scanForModifiedClassesWithProgress(final List<DebuggerSession> sessions, final HotSwapProgressImpl progress, final boolean scanWithVFS) {
        final Ref result = Ref.create(null);
        ProgressManager.getInstance().runProcess(new Runnable(){

            @Override
            public void run() {
                try {
                    result.set(HotSwapManager.scanForModifiedClasses(sessions, progress, scanWithVFS));
                }
                finally {
                    progress.finished();
                }
            }
        }, progress.getProgressIndicator());
        return (Map)result.get();
    }

    private static void reloadModifiedClasses(final Map<DebuggerSession, Map<String, HotSwapFile>> modifiedClasses, final HotSwapProgressImpl progress) {
        ProgressManager.getInstance().runProcess(new Runnable(){

            @Override
            public void run() {
                HotSwapManager.reloadModifiedClasses(modifiedClasses, progress);
                progress.finished();
            }
        }, progress.getProgressIndicator());
    }

    @Override
    public void reloadChangedClasses(DebuggerSession session, boolean compileBeforeHotswap) {
        this.dontAskHotswapAfterThisCompilation();
        if (compileBeforeHotswap) {
            CompilerManager.getInstance((Project)session.getProject()).make(null);
        } else if (session.isAttached()) {
            this.hotSwapSessions(Collections.singletonList(session), null);
        }
    }

    @Override
    public void dontPerformHotswapAfterThisCompilation() {
        this.myPerformHotswapAfterThisCompilation = false;
    }

    public void dontAskHotswapAfterThisCompilation() {
        this.myAskBeforeHotswap = false;
    }

    public static boolean canHotSwap(@NotNull DebuggerSession debuggerSession) {
        return debuggerSession.isAttached() && debuggerSession.getProcess().canRedefineClasses();
    }

    @NotNull
    private List<DebuggerSession> getHotSwappableDebugSessions() {
        return (List)DebuggerManagerEx.getInstanceEx(this.myProject).getSessions().stream().filter(HotSwapUIImpl::canHotSwap).collect(Collectors.toCollection(SmartList::new));
    }

    private class MyCompilationStatusListener
    implements CompilationStatusListener {
        private final AtomicReference<Map<String, List<String>>> myGeneratedPaths = new AtomicReference(new HashMap());
        private final THashSet<File> myOutputRoots = new THashSet(FileUtil.FILE_HASHING_STRATEGY);

        private MyCompilationStatusListener() {
            for (String path : CompilerPathsEx.getOutputPaths((Module[])ModuleManager.getInstance((Project)HotSwapUIImpl.this.myProject).getModules())) {
                this.myOutputRoots.add((Object)new File(path));
            }
        }

        public void fileGenerated(String outputRoot, String relativePath) {
            if (StringUtil.endsWith((CharSequence)relativePath, (CharSequence)".class") && JpsPathUtil.isUnder(this.myOutputRoots, (File)new File(outputRoot))) {
                Map<String, List<String>> map = this.myGeneratedPaths.get();
                List<String> paths = map.get(outputRoot);
                if (paths == null) {
                    paths = new ArrayList<String>();
                    map.put(outputRoot, paths);
                }
                paths.add(relativePath);
            }
        }

        public void compilationFinished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
            Map generated = this.myGeneratedPaths.getAndSet(new HashMap());
            if (HotSwapUIImpl.this.myProject.isDisposed()) {
                return;
            }
            if (errors == 0 && !aborted && HotSwapUIImpl.this.myPerformHotswapAfterThisCompilation) {
                for (HotSwapVetoableListener listener2 : HotSwapUIImpl.this.myListeners) {
                    if (listener2.shouldHotSwap(compileContext)) continue;
                    return;
                }
                List sessions = HotSwapUIImpl.this.getHotSwappableDebugSessions();
                if (!sessions.isEmpty()) {
                    HotSwapUIImpl.this.hotSwapSessions(sessions, generated);
                }
            }
            HotSwapUIImpl.this.myPerformHotswapAfterThisCompilation = true;
        }
    }
}

