/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.concurrency.ResultConsumer;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.ValueHint;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import org.jetbrains.annotations.NotNull;

class DebuggerTreeCreatorImpl
implements DebuggerTreeCreator<Pair<NodeDescriptorImpl, String>> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.ValueHintTreeComponent");
    private final Project myProject;

    public DebuggerTreeCreatorImpl(Project project2) {
        this.myProject = project2;
    }

    @Override
    @NotNull
    public String getTitle(@NotNull Pair<NodeDescriptorImpl, String> descriptor) {
        return (String)descriptor.getSecond();
    }

    @Override
    public void createDescriptorByNode(Object node, final ResultConsumer<Pair<NodeDescriptorImpl, String>> resultConsumer) {
        if (node instanceof DebuggerTreeNodeImpl) {
            final DebuggerTreeNodeImpl debuggerTreeNode = (DebuggerTreeNodeImpl)node;
            final DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(this.myProject).getContext();
            context.getDebugProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(context){

                @Override
                public void threadAction() {
                    try {
                        TextWithImports evaluationText = DebuggerTreeNodeExpression.createEvaluationText(debuggerTreeNode, context);
                        resultConsumer.onSuccess((Object)Pair.create((Object)debuggerTreeNode.getDescriptor(), (Object)evaluationText.getText()));
                    }
                    catch (EvaluateException e) {
                        resultConsumer.onFailure((Throwable)e);
                    }
                }
            });
        }
    }

    @Override
    @NotNull
    public Tree createTree(@NotNull Pair<NodeDescriptorImpl, String> descriptor) {
        return ValueHint.createInspectTree((NodeDescriptorImpl)descriptor.first, this.myProject);
    }
}

