/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.ui.DebuggerEditorImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.EditorComboBoxEditor;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.xdebugger.impl.XDebuggerHistoryManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerExpressionComboBox
extends DebuggerEditorImpl {
    public static final Key<String> KEY = Key.create((String)"DebuggerComboBoxEditor.KEY");
    public static final int MAX_ROWS = 20;
    private final MyEditorComboBoxEditor myEditor;
    private final ComboBox myComboBox;
    private static final DocumentListener REPLACE_NEWLINES_LISTENER = new DocumentAdapter(){

        public void documentChanged(DocumentEvent e) {
            String text = e.getNewFragment().toString();
            String replaced = text.replace('\n', ' ');
            if (replaced != text) {
                e.getDocument().replaceString(e.getOffset(), e.getOffset() + e.getNewLength(), (CharSequence)replaced);
            }
        }
    };

    public DebuggerExpressionComboBox(@NotNull Project project2, @NotNull Disposable parentDisposable, @Nullable PsiElement context, @Nullable String recentsId) {
        this(project2, parentDisposable, context, recentsId, DefaultCodeFragmentFactory.getInstance());
    }

    public DebuggerExpressionComboBox(@NotNull Project project2, @NotNull Disposable parentDisposable, @Nullable PsiElement context, @Nullable String recentsId, @NotNull CodeFragmentFactory factory) {
        super(project2, factory, parentDisposable, context, recentsId);
        this.setLayout(new BorderLayout(0, 0));
        this.myComboBox = new ComboBox((ComboBoxModel)new MyComboboxModel(this.getRecents()), 100);
        this.myComboBox.setSwingPopup(false);
        this.myComboBox.setLightWeightPopupEnabled(false);
        this.myEditor = new MyEditorComboBoxEditor(this.getProject(), (FileType)this.getCurrentFactory().getFileType());
        this.myComboBox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)this.myEditor));
        this.myComboBox.setEditable(true);
        this.myComboBox.setEditor((ComboBoxEditor)this.myEditor);
        this.add(this.addChooseFactoryLabel((JComponent)this.myComboBox, false));
    }

    public void selectPopupValue() {
        Object currentPopupValue = this.getCurrentPopupValue();
        if (currentPopupValue != null) {
            this.myComboBox.getModel().setSelectedItem(currentPopupValue);
            this.myComboBox.getEditor().setItem(currentPopupValue);
        }
        this.myComboBox.setPopupVisible(false);
    }

    public boolean isPopupVisible() {
        return this.myComboBox.isVisible() && this.myComboBox.isPopupVisible();
    }

    public void setPopupVisible(boolean b) {
        this.myComboBox.setPopupVisible(b);
    }

    @Nullable
    public Object getCurrentPopupValue() {
        if (!this.isPopupVisible()) {
            return null;
        }
        ComboPopup popup = this.myComboBox.getPopup();
        if (popup != null) {
            return popup.getList().getSelectedValue();
        }
        return null;
    }

    @Override
    protected void doSetText(TextWithImports item) {
        String itemText = item.getText().replace('\n', ' ');
        this.restoreFactory(item);
        item.setText(itemText);
        if (!(StringUtil.isEmpty((String)itemText) || this.myComboBox.getItemCount() != 0 && item.equals(this.myComboBox.getItemAt(0)))) {
            this.myComboBox.insertItemAt((Object)item, 0);
        }
        if (this.myComboBox.getItemCount() > 0) {
            this.myComboBox.setSelectedIndex(0);
        }
        this.myComboBox.getEditor().setItem(item);
    }

    @Override
    protected void updateEditorUi() {
    }

    @Override
    public TextWithImports getText() {
        return (TextWithImports)this.myComboBox.getEditor().getItem();
    }

    @Nullable
    private List<TextWithImports> getRecents() {
        String recentsId = this.getRecentsId();
        if (recentsId != null) {
            return XDebuggerHistoryManager.getInstance(this.getProject()).getRecentExpressions(recentsId).stream().filter(expression -> expression.getExpression().indexOf(10) == -1).map(TextWithImportsImpl::fromXExpression).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        size.width = 100;
        return size;
    }

    @Override
    public TextWithImports createText(String text, String importsString) {
        return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, text, importsString, (FileType)this.getCurrentFactory().getFileType());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myComboBox.setEnabled(enabled);
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.myComboBox.getEditor().getEditorComponent();
    }

    public void selectAll() {
        this.myComboBox.getEditor().selectAll();
    }

    public Editor getEditor() {
        return this.myEditor.getEditor();
    }

    public JComponent getEditorComponent() {
        return this.myEditor.getEditorComponent();
    }

    @Override
    public void addRecent(TextWithImports text) {
        if (text.getText().length() != 0) {
            Editor editor;
            EditorTextField textField;
            Component editorComponent = this.myComboBox.getEditor().getEditorComponent();
            boolean focusOwner = editorComponent.isFocusOwner();
            int offset = -1;
            if (editorComponent instanceof EditorTextField && (textField = (EditorTextField)((Object)editorComponent)).getEditor() != null) {
                offset = textField.getCaretModel().getOffset();
            }
            super.addRecent(text);
            this.myComboBox.insertItemAt((Object)text, 0);
            this.myComboBox.setSelectedIndex(0);
            editorComponent = this.myComboBox.getEditor().getEditorComponent();
            if (offset != -1 && editorComponent instanceof EditorTextField && (editor = (textField = (EditorTextField)((Object)editorComponent)).getEditor()) != null) {
                int textLength = editor.getDocument().getTextLength();
                offset = Math.min(offset, textLength);
                textField.getCaretModel().moveToOffset(offset);
                editor.getSelectionModel().setSelection(offset, offset);
            }
            if (focusOwner) {
                editorComponent.requestFocus();
            }
        }
    }

    private static class MyComboboxModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        private List<TextWithImports> myItems = new ArrayList<TextWithImports>();
        private int mySelectedIndex = -1;

        private MyComboboxModel(@Nullable List<TextWithImports> recents) {
            if (recents != null) {
                this.myItems = recents;
            }
        }

        @Override
        public void setSelectedItem(Object anItem) {
            int oldSelectedIndex = this.mySelectedIndex;
            int n = this.mySelectedIndex = anItem instanceof TextWithImports ? this.myItems.indexOf(anItem) : -1;
            if (oldSelectedIndex != this.mySelectedIndex) {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.mySelectedIndex == -1 || this.mySelectedIndex > this.myItems.size() - 1 ? null : this.myItems.get(this.mySelectedIndex);
        }

        @Override
        public int getSize() {
            return this.myItems.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.myItems.get(index);
        }

        public void addElement(Object obj) {
            this.insertElementAt(obj, this.myItems.size() - 1);
            if (this.mySelectedIndex == -1 && this.myItems.size() == 1 && obj != null) {
                this.setSelectedItem(obj);
            }
        }

        @Override
        public void removeElement(Object obj) {
            this.removeElement(obj, true);
        }

        public void removeElement(Object obj, boolean checkSelection) {
            if (!(obj instanceof TextWithImports)) {
                throw new IllegalArgumentException();
            }
            int index = this.myItems.indexOf((TextWithImports)obj);
            if (index != -1) {
                this.myItems.remove(index);
                if (checkSelection) {
                    if (this.mySelectedIndex == index) {
                        if (this.myItems.size() == 0) {
                            this.setSelectedItem(null);
                        } else if (index > this.myItems.size() - 1) {
                            this.setSelectedItem(this.myItems.get(this.myItems.size() - 1));
                        }
                    }
                    this.fireIntervalRemoved(this, index, index);
                }
            }
        }

        public void insertElementAt(Object obj, int index) {
            if (!(obj instanceof TextWithImports)) {
                throw new IllegalArgumentException();
            }
            this.removeElement(obj, false);
            this.myItems.add(index, (TextWithImports)obj);
            this.fireIntervalAdded(this, index, index);
            if (this.myItems.size() > 20) {
                for (int i = this.myItems.size() - 1; i > 19; --i) {
                    this.myItems.remove(i);
                }
            }
        }

        @Override
        public void removeElementAt(int index) {
            if (index < 0 || index > this.myItems.size() - 1) {
                throw new IndexOutOfBoundsException();
            }
            this.removeElement(this.myItems.get(index));
        }
    }

    private class MyEditorComboBoxEditor
    extends EditorComboBoxEditor {
        public MyEditorComboBoxEditor(Project project2, FileType fileType) {
            super(project2, fileType);
        }

        @Override
        public Object getItem() {
            Document document = (Document)super.getItem();
            return DebuggerExpressionComboBox.this.createItem(document, DebuggerExpressionComboBox.this.getProject());
        }

        @Override
        public void setItem(Object item) {
            TextWithImports twi = (TextWithImports)item;
            if (twi != null) {
                DebuggerExpressionComboBox.this.restoreFactory(twi);
            }
            Document document = DebuggerExpressionComboBox.this.createDocument(twi);
            this.getEditorComponent().setNewDocumentAndFileType((FileType)DebuggerExpressionComboBox.this.getCurrentFactory().getFileType(), document);
            super.setItem(document);
            if (document != null) {
                document.addDocumentListener(REPLACE_NEWLINES_LISTENER);
            }
        }
    }
}

