/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.options.ConfigurableUi;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class JavaHotSwapConfigurableUi
implements ConfigurableUi<DebuggerSettings> {
    private JCheckBox myHotswapInBackground;
    private JCheckBox myCbCompileBeforeHotswap;
    private JCheckBox myCbHangWarningEnabled;
    private JRadioButton myRbAlways;
    private JRadioButton myRbNever;
    private JRadioButton myRbAsk;

    JavaHotSwapConfigurableUi() {
    }

    public void reset(@NotNull DebuggerSettings settings) {
        this.myHotswapInBackground.setSelected(settings.HOTSWAP_IN_BACKGROUND);
        this.myCbCompileBeforeHotswap.setSelected(settings.COMPILE_BEFORE_HOTSWAP);
        this.myCbHangWarningEnabled.setSelected(settings.HOTSWAP_HANG_WARNING_ENABLED);
        if ("RunHotswapAlways".equals(settings.RUN_HOTSWAP_AFTER_COMPILE)) {
            this.myRbAlways.setSelected(true);
        } else if ("RunHotswapNever".equals(settings.RUN_HOTSWAP_AFTER_COMPILE)) {
            this.myRbNever.setSelected(true);
        } else {
            this.myRbAsk.setSelected(true);
        }
    }

    public void apply(@NotNull DebuggerSettings settings) {
        this.getSettingsTo(settings);
    }

    private void getSettingsTo(DebuggerSettings settings) {
        settings.HOTSWAP_IN_BACKGROUND = this.myHotswapInBackground.isSelected();
        settings.COMPILE_BEFORE_HOTSWAP = this.myCbCompileBeforeHotswap.isSelected();
        settings.HOTSWAP_HANG_WARNING_ENABLED = this.myCbHangWarningEnabled.isSelected();
        settings.RUN_HOTSWAP_AFTER_COMPILE = this.myRbAlways.isSelected() ? "RunHotswapAlways" : (this.myRbNever.isSelected() ? "RunHotswapNever" : "RunHotswapAsk");
    }

    public boolean isModified(@NotNull DebuggerSettings currentSettings) {
        DebuggerSettings debuggerSettings = currentSettings.clone();
        this.getSettingsTo(debuggerSettings);
        return !debuggerSettings.equals(currentSettings);
    }

    @NotNull
    public JComponent getComponent() {
        Insets insets;
        JPanel panel = new JPanel(new GridBagLayout());
        this.myCbCompileBeforeHotswap = new JCheckBox(DebuggerBundle.message((String)"label.debugger.hotswap.configurable.compile.before.hotswap", (Object[])new Object[0]));
        this.myCbHangWarningEnabled = new JCheckBox(DebuggerBundle.message((String)"label.debugger.hotswap.configurable.enable.vm.hang.warning", (Object[])new Object[0]));
        this.myHotswapInBackground = new JCheckBox(DebuggerBundle.message((String)"label.debugger.hotswap.configurable.hotswap.background", (Object[])new Object[0]));
        this.myRbAlways = new JRadioButton(DebuggerBundle.message((String)"label.debugger.hotswap.configurable.always", (Object[])new Object[0]));
        this.myRbNever = new JRadioButton(DebuggerBundle.message((String)"label.debugger.hotswap.configurable.never", (Object[])new Object[0]));
        this.myRbAsk = new JRadioButton(DebuggerBundle.message((String)"label.debugger.hotswap.configurable.ask", (Object[])new Object[0]));
        panel.add((Component)this.myCbCompileBeforeHotswap, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.myCbHangWarningEnabled, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, 0, 0, 0), 0, 0));
        panel.add((Component)this.myHotswapInBackground, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, 0, 0, 0), 0, 0));
        int cbLeftOffset = 0;
        Border border = this.myCbCompileBeforeHotswap.getBorder();
        if (border != null && (insets = border.getBorderInsets(this.myCbCompileBeforeHotswap)) != null) {
            cbLeftOffset = insets.left;
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.myRbAlways);
        group.add(this.myRbNever);
        group.add(this.myRbAsk);
        Box box = Box.createHorizontalBox();
        box.add(this.myRbAlways);
        box.add(this.myRbNever);
        box.add(this.myRbAsk);
        JPanel reloadPanel = new JPanel(new BorderLayout());
        reloadPanel.add((Component)box, "Center");
        reloadPanel.add((Component)new JLabel(DebuggerBundle.message((String)"label.debugger.hotswap.configurable.reload.classes", (Object[])new Object[0])), "West");
        panel.add((Component)reloadPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 0, new Insets(4, cbLeftOffset, 0, 0), 0, 0));
        return panel;
    }
}

